/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.dr;

import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.dr.DRActivateAlarmGenerator;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAbstractConsistencyGroupImpl;
import com.sanrad.nms.server.logic.dr.DRAbstractConsistencyGroupImpl;
import com.sanrad.nms.server.logic.dr.DRLogicObjectImpl;
import com.sanrad.nms.server.logic.validation.Validator;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class DRAbstractConsistencyGroupAlarmGenerator
extends DRActivateAlarmGenerator {
    protected DRAbstractConsistencyGroupAlarmGenerator() {
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToOpen(GeneralLogicObject source, VSwitchImpl vSwitch) throws RemoteException {
        List<AlarmImpl> openAlarms = new ArrayList<AlarmImpl>();
        if (((DRAbstractConsistencyGroupImpl)source).getPairsCount() == 0) {
            return openAlarms;
        }
        if (this.m_father != DRActivateAlarmGenerator.class) {
            openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        }
        if (((DRLogicObjectImpl)source).getLocalElement() != null && ((DRLogicObjectImpl)source).getRemoteElement() != null && ((DRClusterAbstractConsistencyGroupImpl)((DRAbstractConsistencyGroupImpl)source).getLocalElement()).isPairEquals((DRClusterAbstractConsistencyGroupImpl)((DRLogicObjectImpl)source).getRemoteElement())) {
            this.addAlarmAndMsg(source, vSwitch, openAlarms, " Is illegal ", AlarmType.ILLEAGAL_PAIR_CG);
        }
        if (Boolean.TRUE.equals(Validator.getInstance().validAccordingToParameter((GeneralLogicObjectImpl)source, AlarmType.CG_DR_UNKNOWN, vSwitch))) {
            this.addAlarmAndMsg(source, vSwitch, openAlarms, " Pairs are working in inconsistent mode within the group ", AlarmType.CG_DR_UNKNOWN);
        }
        if (((DRAbstractConsistencyGroupImpl)source).getLocalElement() != null && ((DRAbstractConsistencyGroupImpl)source).getRemoteElement() != null && !((DRAbstractConsistencyGroupImpl)source).comparePolicies()) {
            this.addAlarmAndMsg(source, vSwitch, openAlarms, " replication policy is inconsistent between sites ", AlarmType.INCONS_REPLICATION);
        }
        return openAlarms;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToClose(GeneralLogicObject source, VSwitchImpl vSwitch, List<AlarmImpl> openAlarms) throws RemoteException {
        ArrayList<AlarmImpl> closeAlarms = new ArrayList();
        if (this.m_father != DRActivateAlarmGenerator.class) {
            closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        }
        for (AlarmImpl alarm : openAlarms) {
            if (((DRAbstractConsistencyGroupImpl)source).getLocalElement() == null || ((DRAbstractConsistencyGroupImpl)source).getRemoteElement() == null || !((DRAbstractConsistencyGroupImpl)source).comparePolicies()) continue;
            closeAlarms.add(alarm);
        }
        return closeAlarms;
    }
}

