/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm;

import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.alarm.AlarmList;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRLogicObject;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.types.constants.DrSiteConstant;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class PendingAlarmList
extends AlarmList {
    private Integer vSwitchGroupId;

    public PendingAlarmList(AlarmList alarmList, Integer vSwitchGroupId) throws RemoteException {
        super(alarmList);
        this.vSwitchGroupId = vSwitchGroupId;
    }

    public PendingAlarmList(Hashtable<Integer, PendingAlarmList> pendingAlarmLists) throws RemoteException {
        super(pendingAlarmLists);
        this.vSwitchGroupId = DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue();
    }

    private List<Alarm> getClosedAlarms(AlarmList liveAlarmList, GeneralLogicObjectImpl source) throws RemoteException {
        ArrayList<Alarm> closedAlarms = new ArrayList<Alarm>();
        List<Alarm> liveAlarms = liveAlarmList.getAlarms(source);
        List<Alarm> pendingAlarms = this.getAlarms(source);
        if (liveAlarms != null) {
            for (Alarm pendingAlarm : pendingAlarms) {
                if (liveAlarms.contains(pendingAlarm)) continue;
                closedAlarms.add(pendingAlarm);
            }
        } else if (pendingAlarms != null) {
            closedAlarms.addAll(pendingAlarms);
        }
        return closedAlarms;
    }

    public List<Alarm> removePendingAlarms(AlarmList liveAlarmList) throws RemoteException {
        Hashtable<GeneralLogicObject, List<Alarm>> pendingList = this.getAllAlarms();
        ArrayList<Alarm> allClosedAlarms = new ArrayList<Alarm>();
        if (pendingList == null) {
            return null;
        }
        Enumeration<GeneralLogicObject> e = pendingList.keys();
        while (e.hasMoreElements()) {
            GeneralLogicObjectImpl source = (GeneralLogicObjectImpl)e.nextElement();
            if (source == null) continue;
            List<Alarm> closedAlarms = this.getClosedAlarms(liveAlarmList, source);
            allClosedAlarms.addAll(closedAlarms);
            this.addToHistory(closedAlarms, true);
        }
        return allClosedAlarms;
    }

    public int hashCode() {
        return this.vSwitchGroupId;
    }

    public boolean equals(Object list) {
        return list instanceof PendingAlarmList && ((PendingAlarmList)list).vSwitchGroupId.intValue() == this.vSwitchGroupId.intValue();
    }

    public List<Alarm> getPendingAlarms(LogicObjectImpl source, VSwitch vSwitch) throws RemoteException {
        return this.getAlarms((GeneralLogicObjectImpl)source, vSwitch);
    }

    public List<Alarm> getAcknowledgedPendingAlarms(LogicObjectImpl source, VSwitch vSwitch) throws RemoteException {
        List<Alarm> pendingAlarms = this.getPendingAlarms(source, vSwitch);
        ArrayList<Alarm> acknowledgedPendingAlarms = new ArrayList<Alarm>();
        for (Alarm alarm : pendingAlarms) {
            if (!alarm.isAcknowledged()) continue;
            acknowledgedPendingAlarms.add(alarm);
        }
        return acknowledgedPendingAlarms;
    }

    public List<Alarm> getAcknowledgedPendingAlarms() throws RemoteException {
        ArrayList<Alarm> acknowledgedPendingAlarms = new ArrayList<Alarm>();
        Hashtable<GeneralLogicObject, List<Alarm>> pending = this.getAllAlarms();
        Enumeration<GeneralLogicObject> e = pending.keys();
        while (e.hasMoreElements()) {
            GeneralLogicObjectImpl source = (GeneralLogicObjectImpl)e.nextElement();
            List<Alarm> alarms = pending.get(source);
            if (alarms == null) continue;
            for (Alarm alarm : alarms) {
                if (!alarm.isAcknowledged()) continue;
                acknowledgedPendingAlarms.add(alarm);
            }
        }
        return acknowledgedPendingAlarms;
    }

    @Override
    public List<Alarm> getAlarms(GeneralLogicObjectImpl source) throws RemoteException {
        Hashtable<GeneralLogicObject, List<Alarm>> allPendingAlarms;
        List<Alarm> alarms = super.getAlarms(source);
        if (alarms == null && (allPendingAlarms = this.getAllAlarms()) != null) {
            Enumeration<GeneralLogicObject> e = allPendingAlarms.keys();
            while (e.hasMoreElements()) {
                GeneralLogicObject key = e.nextElement();
                if (source instanceof DRLogicObject) {
                    if (!(key instanceof DRLogicObject) || !key.equals(source) && !((GeneralLogicObjectImpl)key).equalsByCommKey((Object)source)) continue;
                    alarms = allPendingAlarms.get(key);
                    break;
                }
                if (!(key instanceof LogicObject) || !((LogicObject)key).getCommKeyClassId().equals((Object)((LogicObject)source).getCommKeyClassId())) continue;
                alarms = allPendingAlarms.get(key);
                break;
            }
        }
        return alarms;
    }

    @Override
    public Hashtable<GeneralLogicObject, List<Alarm>> getAllAlarms() throws RemoteException {
        return this.list;
    }

    public AlarmImpl getAlarm(AlarmType type, GeneralLogicObject source, VSwitch vSwitch, Object additionalKeyObject) throws RemoteException {
        List<Alarm> pendingAlarms = this.getAlarms((GeneralLogicObjectImpl)source);
        if (pendingAlarms != null) {
            for (Alarm pendingAlarm : pendingAlarms) {
                Object pendingAdditionalKeyObject;
                VSwitch pendingVSwitch;
                if (!pendingAlarm.getType().equals(type) || !((GeneralLogicObjectImpl)pendingAlarm.getSource()).equalsByCommKey((Object)source) || ((pendingVSwitch = pendingAlarm.getVSwitch()) == null || vSwitch == null || !pendingVSwitch.equals(vSwitch)) && (pendingVSwitch != null || vSwitch != null) || ((pendingAdditionalKeyObject = pendingAlarm.getAdditionalKeyObject()) == null || pendingAdditionalKeyObject == null || !pendingAdditionalKeyObject.equals(additionalKeyObject)) && (pendingAdditionalKeyObject != null || additionalKeyObject != null)) continue;
                return (AlarmImpl)pendingAlarm;
            }
        }
        return null;
    }
}

