/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.RemoteObjectImpl;
import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmHistoryIterator;
import com.sanrad.nms.server.alarm.AlarmHistoryList;
import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.alarm.AlarmList;
import com.sanrad.nms.server.alarm.AlarmMgr;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.AlarmsNotificationData;
import com.sanrad.nms.server.alarm.DrAlarmMgrImpl;
import com.sanrad.nms.server.alarm.PendingAlarmList;
import com.sanrad.nms.server.alarm.event.AlarmEvent;
import com.sanrad.nms.server.alarm.event.AlarmEventImpl;
import com.sanrad.nms.server.event.AllEventsListener;
import com.sanrad.nms.server.event.SrElementEvent;
import com.sanrad.nms.server.event.SrEvent;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.DataWarehouse;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.VSwitchGroup;
import com.sanrad.nms.server.logic.VSwitchGroupImpl;
import com.sanrad.nms.server.logic.acl.AclEntry;
import com.sanrad.nms.server.logic.acl.AclImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.identity.Credentials;
import com.sanrad.nms.server.logic.identity.IdentityImpl;
import com.sanrad.nms.server.logic.identity.IdentityNameImpl;
import com.sanrad.nms.server.logic.lu.LU;
import com.sanrad.nms.server.logic.target.TargetImpl;
import com.sanrad.nms.server.logic.volume.Volume;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrBoolean;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.constants.DrSiteConstant;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public abstract class GeneralAlarmMgrImpl
extends RemoteObjectImpl
implements AlarmMgr,
AllEventsListener {
    protected Hashtable<Integer, AlarmList> alarmLists = new Hashtable();
    protected Hashtable<Integer, PendingAlarmList> pendingAlarmLists = new Hashtable();
    protected AlarmsNotificationData alarmsNotificationData = new AlarmsNotificationData();
    private static HashMap<GeneralLogicObjectImpl, List<AlarmImpl>> theAlarmSourceToSilencedAlarms = new HashMap();
    private static SrLogger theLogger = SrLogger.getLogger();

    protected GeneralAlarmMgrImpl() throws RemoteException {
        LogicMgrAOImpl.getInstance().addAllEventsListener((AllEventsListener)this);
    }

    public void addAlarmToSilencedList(AlarmImpl aAlarm, GeneralLogicObjectImpl aSource) {
        if (aAlarm == null || aSource == null) {
            throw new IllegalArgumentException("The given parameters should not be null. aAlarm = " + aAlarm + "; aSource = " + aSource);
        }
        List<AlarmImpl> alarmList = theAlarmSourceToSilencedAlarms.get(aSource);
        if (alarmList == null) {
            alarmList = new ArrayList<AlarmImpl>();
            theAlarmSourceToSilencedAlarms.put(aSource, alarmList);
        }
        alarmList.add(aAlarm);
    }

    public void addAlarmToSilencedList(AlarmImpl aAlarm) {
        if (aAlarm == null) {
            throw new IllegalArgumentException("The given alarms list should not be null.");
        }
        try {
            this.addAlarmToSilencedList(aAlarm, aAlarm.getSource());
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.EXCEPTION, (Throwable)exp, new Object[]{"A remote exception has occured inside a server context."});
        }
    }

    public void addAlarmsToSilencedList(Collection<AlarmImpl> aAlarmList) {
        if (aAlarmList == null) {
            throw new IllegalArgumentException("The given alarms list should not be null.");
        }
        for (AlarmImpl curAlarm : aAlarmList) {
            this.addAlarmToSilencedList(curAlarm);
        }
    }

    public boolean isAlarmExistsInTheSilencedList(AlarmImpl aAlarm) {
        if (aAlarm == null) {
            throw new IllegalArgumentException("The given alarm should not be null.");
        }
        List<AlarmImpl> allAlarms = null;
        try {
            allAlarms = theAlarmSourceToSilencedAlarms.get(aAlarm.getSource());
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.EXCEPTION, (Throwable)exp, new Object[]{"A remote exception has occured inside a server context."});
        }
        if (allAlarms == null) {
            return false;
        }
        return allAlarms.contains(aAlarm);
    }

    public void removeAlarmsFromSilencedList(GeneralLogicObjectImpl aSource) {
        if (aSource == null) {
            throw new IllegalArgumentException("The given source should not be null.");
        }
        theAlarmSourceToSilencedAlarms.remove(aSource);
    }

    public void removeClustersSilencedAlarms(ClusterImpl aCluster) {
        if (aCluster == null) {
            throw new IllegalArgumentException("The given cluster should not be null.");
        }
        Vector refs = aCluster.getCommKeyRefMap().getAllRefs();
        if (refs != null) {
            for (Object curObj : refs) {
                if (curObj == null) continue;
                this.removeAlarmsFromSilencedList((GeneralLogicObjectImpl)((LogicObjectImpl)curObj));
            }
        }
    }

    public List<AlarmImpl> getNonSilencedAlarms(Iterable<AlarmImpl> aAlarmsList) {
        if (aAlarmsList == null) {
            throw new IllegalArgumentException("The given alarms list should not be null.");
        }
        ArrayList<AlarmImpl> retList = new ArrayList<AlarmImpl>();
        for (AlarmImpl curAlarm : aAlarmsList) {
            if (this.isAlarmExistsInTheSilencedList(curAlarm)) continue;
            retList.add(curAlarm);
        }
        return retList;
    }

    public Map<GeneralLogicObject, List<Alarm>> getNonSilencedAlarms(Map<GeneralLogicObject, List<Alarm>> aAlarmsMap) {
        if (aAlarmsMap == null) {
            throw new IllegalArgumentException("The given alarms map should not be null.");
        }
        Hashtable<GeneralLogicObject, List<Alarm>> retMap = new Hashtable<GeneralLogicObject, List<Alarm>>();
        for (Map.Entry<GeneralLogicObject, List<Alarm>> curEntry : aAlarmsMap.entrySet()) {
            ArrayList<AlarmImpl> alarms = new ArrayList<AlarmImpl>();
            for (Alarm curAlarm : curEntry.getValue()) {
                alarms.add((AlarmImpl)curAlarm);
            }
            ArrayList<AlarmImpl> alarmsVec = new ArrayList<AlarmImpl>(this.getNonSilencedAlarms(alarms));
            retMap.put(curEntry.getKey(), alarmsVec);
        }
        return retMap;
    }

    protected AlarmList createAlarmList(Integer vSwitchGroupId) throws RemoteException, IllegalValueException {
        if (vSwitchGroupId == null) {
            vSwitchGroupId = DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue();
        }
        AlarmList alarmList = null;
        alarmList = this.alarmLists.get(vSwitchGroupId);
        if (alarmList == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Added an empty alarm list for group id ", vSwitchGroupId});
            alarmList = new AlarmList();
            this.alarmLists.put(vSwitchGroupId, alarmList);
        }
        return alarmList;
    }

    protected PendingAlarmList createPendingAlarmList(Integer vSwitchGroupId) throws RemoteException {
        PendingAlarmList pendingAlarmList = this.pendingAlarmLists.get(vSwitchGroupId);
        if (pendingAlarmList == null || pendingAlarmList.isListEmpty()) {
            pendingAlarmList = new PendingAlarmList(this.getAlarmList(vSwitchGroupId), vSwitchGroupId);
            this.pendingAlarmLists.put(vSwitchGroupId, pendingAlarmList);
        }
        return pendingAlarmList;
    }

    protected void updateSourceOfAlarms(AlarmList alarmList) throws RemoteException {
    }

    public void removeAlarmList(VSwitchGroupImpl vSwitchGroup) throws RemoteException, IllegalValueException {
        AlarmList alarmList = this.alarmLists.remove(vSwitchGroup.getVSwitchGroupId());
        if (alarmList != null) {
            alarmList.removeAlarm((GeneralLogicObjectImpl)vSwitchGroup);
        }
    }

    protected AlarmList getAlarmList(Integer vSwitchGroupId) throws RemoteException {
        AlarmList alarmList = null;
        if (vSwitchGroupId != null) {
            alarmList = this.alarmLists.get(vSwitchGroupId);
        }
        if (alarmList == null || this.alarmLists == null) {
            try {
                alarmList = this.createAlarmList(vSwitchGroupId);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            catch (IllegalValueException e) {
                e.printStackTrace();
            }
        }
        return alarmList;
    }

    protected PendingAlarmList getPendingAlarmList(Integer vSwitchGroupId) throws RemoteException {
        PendingAlarmList pendingAlarmList = this.pendingAlarmLists.get(vSwitchGroupId);
        if (pendingAlarmList == null) {
            pendingAlarmList = this.createPendingAlarmList(vSwitchGroupId);
        }
        return pendingAlarmList;
    }

    protected AlarmList getAlarmList(VSwitchGroup vSwitchGroup) throws RemoteException {
        if (vSwitchGroup == null) {
            try {
                return this.getAlarmList();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            catch (IllegalValueException e) {
                e.printStackTrace();
            }
        }
        return this.getAlarmList(vSwitchGroup.getVSwitchGroupId());
    }

    public void takePendingAlarmList(ClusterImpl cluster) throws RemoteException {
        this.createPendingAlarmList(this.getVswitchGroupId(cluster));
        this.clear(cluster);
    }

    public void clear(ClusterImpl cluster) throws RemoteException {
        AlarmList alarmList = this.getAlarmList(this.getVswitchGroupId(cluster));
        alarmList.clear();
    }

    public Integer getVswitchGroupId(ClusterImpl cluster) {
        if (cluster == null) {
            return DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue();
        }
        return cluster.getVSwitchGroupId();
    }

    public void takePendingAlarms() throws RemoteException, IllegalValueException {
        AlarmList alarmList = this.getAlarmList();
        this.createPendingAlarmList();
        alarmList.clear();
    }

    protected void closePendingAlarms(VSwitchGroup vSwitchGroup) throws RemoteException {
        SystemRootImpl.setStatusInProcess((String)("Check closing pending alarms for " + vSwitchGroup + "..."));
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Check closing for pending alarms"});
        PendingAlarmList pendingAlarmList = this.getPendingAlarmList(vSwitchGroup.getVSwitchGroupId());
        AlarmList alarmList = this.getAlarmList(vSwitchGroup);
        if (pendingAlarmList != null) {
            pendingAlarmList.removePendingAlarms(alarmList);
            pendingAlarmList.clear();
            this.pendingAlarmLists.remove(vSwitchGroup.getVSwitchGroupId());
        }
        SystemRootImpl.setStatusReady();
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Done closing pending alarms"});
    }

    protected void closePendingAlarms() throws RemoteException, IllegalValueException {
        SystemRootImpl.setStatusInProcess((String)"Check closing for pending alarms...");
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Check closing for pending alarms"});
        PendingAlarmList pendingAlarmList = this.getPendingAlarmList();
        AlarmList alarmList = this.getAlarmList();
        if (pendingAlarmList != null) {
            pendingAlarmList.removePendingAlarms(alarmList);
        }
        SystemRootImpl.setStatusReady();
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Done closing pending alarms"});
    }

    public void verifyEmptyPendingAlarmsAndClear() {
        if (this.pendingAlarmLists == null) {
            return;
        }
        Set<Map.Entry<Integer, PendingAlarmList>> entries = this.pendingAlarmLists.entrySet();
        for (Map.Entry<Integer, PendingAlarmList> curEntry : entries) {
            try {
                Hashtable<GeneralLogicObject, List<Alarm>> curAlarmsMap = curEntry.getValue().getAllAlarms();
                ArrayList<Alarm> alarmsToHist = new ArrayList<Alarm>();
                for (List<Alarm> curAlarmVec : curAlarmsMap.values()) {
                    alarmsToHist.addAll(curAlarmVec);
                }
                theLogger.warn(SrLogCategories.ERROR, new Object[]{"The pending alarm list should be empty but it ", "contains the following alarms for VS group id ", curEntry.getKey(), ": ", alarmsToHist, " This is not a major problem since we are manually ", "cleaning it up in the 'verifyEmptyPendingAlarmsAndClear' method"});
                curEntry.getValue().addToHistory(alarmsToHist, true);
                DataWarehouse.getInstance().removeAlarms(alarmsToHist);
            }
            catch (RemoteException exp) {
                theLogger.error(SrLogCategories.EXCEPTION, (Throwable)exp, new Object[]{"A remote exception has occured inside a server context."});
            }
        }
        this.pendingAlarmLists.clear();
    }

    protected void setAlarmsIfNeed(GeneralLogicObjectImpl source, PendingAlarmList pendingAlarmList) throws RemoteException {
        this.setAlarmsIfNeed(source, null, pendingAlarmList);
    }

    protected void setAlarmsIfNeed(GeneralLogicObjectImpl source) throws RemoteException {
        this.setAlarmsIfNeed(source, (PendingAlarmList)null);
    }

    protected void setAlarmsIfNeed(GeneralLogicObjectImpl source, VSwitchImpl vSwitch) throws RemoteException {
        this.setAlarmsIfNeed(source, vSwitch, null);
    }

    public void setAlarmsOnAllVSwitchesIfNeed(GeneralLogicObjectImpl source) throws RemoteException {
        VSwitchImpl[] vSwitches = source.getConnectedVSwitches();
        for (int i = 0; i < vSwitches.length; ++i) {
            this.setAlarmsIfNeed(source, vSwitches[i]);
        }
    }

    protected void setAlarmsIfNeed(GeneralLogicObjectImpl source, VSwitchImpl vSwitch, PendingAlarmList pendingAlarmList) throws RemoteException {
        if (source == null) {
            return;
        }
        AlarmGenerator alarmGenerator = source.getAlarmGenerator();
        if (alarmGenerator != null) {
            if (source.getClassId().equals((Object)ClassID.HARDWARE)) {
                source = vSwitch;
            }
            List<AlarmImpl> openAlarms = alarmGenerator.checkForAlarmsToOpen((GeneralLogicObject)source, vSwitch, pendingAlarmList);
            AlarmList alarmList = this.getAlarmList((VSwitchGroup)source.getCluster());
            List<Alarm> currentOpenAlarmsOnVSwitch = alarmList.getAlarms(source, (VSwitch)vSwitch);
            List<Alarm> currentOpenAlarms = alarmList.getAlarms(source, null);
            currentOpenAlarmsOnVSwitch.addAll(currentOpenAlarms);
            ArrayList<AlarmImpl> tmpList = new ArrayList<AlarmImpl>();
            for (Alarm alarm : currentOpenAlarmsOnVSwitch) {
                tmpList.add((AlarmImpl)alarm);
            }
            List<AlarmImpl> closeAlarmsList = alarmGenerator.checkForAlarmsToClose((GeneralLogicObject)source, vSwitch, tmpList);
            ArrayList<Alarm> closeAlarms = new ArrayList<Alarm>(closeAlarmsList);
            alarmList.removeAlarm(closeAlarms);
            alarmList.addAlarmIfNotExists((GeneralLogicObject)source, new ArrayList<AlarmImpl>(openAlarms));
        }
    }

    @Override
    public Hashtable<GeneralLogicObject, List<Alarm>> getAllAlarms(Integer vSwitchGroupId) throws RemoteException {
        if (vSwitchGroupId == null) {
            vSwitchGroupId = DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue();
        }
        AlarmList alarmList = this.getAlarmList(vSwitchGroupId);
        Hashtable<GeneralLogicObject, List<Alarm>> retMap = new Hashtable<GeneralLogicObject, List<Alarm>>(this.getNonSilencedAlarms(alarmList.getAllAlarms()));
        return retMap;
    }

    public Hashtable<GeneralLogicObject, List<Alarm>> getAllAlarms(VSwitchGroup vSwitchGroup) throws RemoteException, IllegalValueException {
        Hashtable<GeneralLogicObject, List<Alarm>> retMap = new Hashtable<GeneralLogicObject, List<Alarm>>(this.getNonSilencedAlarms(this.getAllAlarms(vSwitchGroup.getVSwitchGroupId())));
        return retMap;
    }

    @Override
    public Hashtable<GeneralLogicObject, List<Alarm>> getAllAlarms() throws RemoteException {
        Hashtable<GeneralLogicObject, List<Alarm>> allAlarms = new Hashtable<GeneralLogicObject, List<Alarm>>();
        for (Integer key : this.alarmLists.keySet()) {
            AlarmList alarmList = this.alarmLists.get(key);
            allAlarms.putAll(alarmList.getAllAlarms());
        }
        Hashtable<GeneralLogicObject, List<Alarm>> retMap = new Hashtable<GeneralLogicObject, List<Alarm>>(this.getNonSilencedAlarms(allAlarms));
        return retMap;
    }

    @Override
    public List<Alarm> getAlarms(CommKey[] commKeys, ClassID classId) throws RemoteException, IllegalValueException {
        LogicObjectImpl source = (LogicObjectImpl)SystemRootImpl.getInstance().getRefByStub(commKeys, classId);
        return this.getAlarms((GeneralLogicObjectImpl)source);
    }

    public List<Alarm> getAlarms(GeneralLogicObjectImpl source) {
        if (source == null) {
            return null;
        }
        try {
            AlarmList alarmList = this.getAlarmList((VSwitchGroup)source.getCluster());
            return alarmList.getAlarms(source);
        }
        catch (RemoteException e) {
            theLogger.error(SrLogCategories.EXCEPTION, (Throwable)e, new Object[0]);
            return null;
        }
    }

    public List<Alarm> getAlarms(GeneralLogicObjectImpl source, VSwitch vSwitch) throws RemoteException, IllegalValueException {
        AlarmList alarmList = this.getAlarmList((VSwitchGroup)source.getCluster());
        return alarmList.getAlarms(source, vSwitch);
    }

    @Override
    public List<Alarm> getAlarms(CommKey[] commKeys, ClassID classId, VSwitch vSwitch) throws IllegalValueException, RemoteException {
        LogicObjectImpl source = (LogicObjectImpl)SystemRootImpl.getInstance().getRefByStub(commKeys, classId);
        return this.getAlarms((GeneralLogicObjectImpl)source, vSwitch);
    }

    @Override
    public void silentAlarms(List<Alarm> alarms) throws RemoteException {
        Iterator<Integer> i = this.alarmLists.keySet().iterator();
        while (i.hasNext()) {
            AlarmList alarmList = this.alarmLists.get(i.next());
            alarmList.removeAlarms(alarms, "User", true);
            ArrayList<AlarmImpl> allAlarms = new ArrayList<AlarmImpl>();
            for (Alarm curAlarm : alarms) {
                allAlarms.add((AlarmImpl)curAlarm);
            }
            this.addAlarmsToSilencedList(allAlarms);
        }
    }

    @Override
    public AlarmHistoryIterator getAlarmHistoryIterator() throws RemoteException {
        return AlarmHistoryList.getInstance().getAlarmHistoryIterator();
    }

    @Override
    public int getHistoryAlarmCount() throws RemoteException {
        return AlarmHistoryList.getInstance().getHistoryAlarmCount();
    }

    public void closeAlarmsOnRemovedElement(GeneralLogicObjectImpl source, VSwitch vSwitch) throws RemoteException {
        AlarmList alarmList = this.getAlarmList((VSwitchGroup)source.getCluster());
        if (alarmList == null) {
            return;
        }
        ArrayList<Alarm> sourceAlarms = new ArrayList<Alarm>();
        if (alarmList.getAlarms(source) != null) {
            sourceAlarms.addAll(alarmList.getAlarms(source));
        }
        for (Alarm curAlarm : sourceAlarms) {
            if (curAlarm.getSource().equals(source)) {
                LogicMgrAOImpl.getInstance().__alarmClosed((AlarmEvent)new AlarmEventImpl(curAlarm.getSource(), curAlarm));
                continue;
            }
            theLogger.error(SrLogCategories.BUG, new Object[]{"The alarm ", curAlarm, " has the source ", curAlarm.getSource().getClassId(), " ", curAlarm.getSource(), " but it is listed in the alarms for source ", source.getClassId(), " ", source});
        }
        alarmList.removeAlarm(source, vSwitch);
        if (source.getConnectedVSwitchCounter() == 0 || vSwitch == null) {
            alarmList.removeAlarm(alarmList.getAlarms(source));
            alarmList.removeAlarm(source);
        }
    }

    public void generateAlarms(ClusterImpl cluster, int eventType, GeneralLogicObjectImpl source, VSwitchImpl vSwitch) {
        LogicMgrAOImpl.getInstance().generateAlarms(this, cluster, eventType, source, (VSwitch)vSwitch);
    }

    public void generateAlarmsInner(ClusterImpl cluster, int eventType, GeneralLogicObjectImpl source, VSwitchImpl vSwitch) throws RemoteException {
        ClassID classId;
        if (source == null) {
            return;
        }
        if (eventType == 3 || source instanceof LogicObjectImpl && ((LogicObjectImpl)source).isMerged()) {
            this.closeAlarmsOnRemovedElement(source, (VSwitch)vSwitch);
            if (vSwitch == null) {
                theLogger.trace(SrLogCategories.LEGACY, new Object[]{"remove alarms element ", source, "the cluster is ", cluster, " ", eventType});
                return;
            }
            if (source.getClassId().equals((Object)ClassID.VSWITCH)) {
                AlarmList alarmList = this.getAlarmList((VSwitchGroup)cluster);
                alarmList.closeAlarmsOnVSwitch((VSwitch)vSwitch);
                this.setAlarmsIfNeed((GeneralLogicObjectImpl)cluster);
                return;
            }
            if (source.getClassId().equals((Object)ClassID.LUN)) {
                this.setAlarmsIfNeed((GeneralLogicObjectImpl)cluster);
            }
            if (source.getConnectedVSwitchCounter() > 0 && vSwitch != null) {
                List connectedVSwitch;
                ArrayList<VSwitchImpl> removedVSwitch = new ArrayList<VSwitchImpl>();
                removedVSwitch.add(vSwitch);
                if (cluster != null && !(connectedVSwitch = cluster.getOtherVSwitches(removedVSwitch)).isEmpty() && vSwitch != null) {
                    this.setAlarmsIfNeed(source, (VSwitchImpl)connectedVSwitch.get(0));
                }
            }
        } else {
            this.setAlarmsIfNeed(source, vSwitch);
        }
        if ((classId = source.getClassId()).equals((Object)ClassID.LUN)) {
            this.setAlarmsIfNeed((GeneralLogicObjectImpl)((TargetImpl)((LU)source).getParentTarget()), vSwitch);
            VolumeNodeImpl volume = (VolumeNodeImpl)((LU)source).getVolumeChild();
            if (volume != null) {
                this.setAlarmsIfNeed((GeneralLogicObjectImpl)volume, vSwitch);
            }
        } else if (classId.equals((Object)ClassID.IDENTITY_NAME)) {
            this.setAlarmsIfNeed((GeneralLogicObjectImpl)((IdentityNameImpl)source).getIdentityParent(), vSwitch);
        } else if (classId.equals((Object)ClassID.CHAP_CREDENTIALS) || classId.equals((Object)ClassID.SRP_CREDENTIALS)) {
            if (((Credentials)source).getIdentityParent() != null) {
                this.setAlarmsIfNeed((GeneralLogicObjectImpl)((IdentityImpl)((Credentials)source).getIdentityParent()), vSwitch);
            }
        } else if (classId.equals((Object)ClassID.VSWITCH) || classId.equals((Object)ClassID.NEIGHBORE)) {
            this.setAlarmsIfNeed((GeneralLogicObjectImpl)cluster);
        } else if (classId.equals((Object)ClassID.ACL_ENTRY)) {
            AclImpl acl = (AclImpl)((AclEntry)source).getAclParent();
            TargetImpl target = acl.getTargetParent();
            if (!target.isDeletionProcessStarted()) {
                this.setAlarmsIfNeed((GeneralLogicObjectImpl)acl);
                this.setAlarmsIfNeed((GeneralLogicObjectImpl)target, vSwitch);
            }
        } else if (source instanceof VolumeNode) {
            List volChildren;
            Volume parent;
            LU lu = ((VolumeNode)source).getParentLU();
            if (lu != null) {
                this.setAlarmsIfNeed((GeneralLogicObjectImpl)((TargetImpl)lu.getParentTarget()), vSwitch);
            }
            if ((parent = ((VolumeNode)source).getParentVolume()) != null && parent.getClassId().equals((Object)ClassID.MIRROR_VOLUME) && ((LogicObjectImpl)parent).isKnownByVSwitch(vSwitch)) {
                this.setAlarmsIfNeed((GeneralLogicObjectImpl)((VolumeNodeImpl)parent), vSwitch);
            }
            if ((volChildren = ((VolumeNode)source).getChildren()) != null) {
                Iterator i = volChildren.iterator();
                while (i.hasNext()) {
                    this.generateAlarmsInner(cluster, eventType, (GeneralLogicObjectImpl)i.next(), vSwitch);
                }
            }
        }
    }

    public void generateAlarms(ClusterImpl cluster) throws RemoteException {
        LogicMgrAOImpl.getInstance().generateAlarms(this, cluster);
    }

    public void generateAlarmsInner(ClusterImpl cluster) throws RemoteException {
        Integer vswitchGroupId = null;
        AbstractList objects = null;
        if (cluster == null) {
            vswitchGroupId = DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue();
            objects = new ArrayList(DRRootImpl.getInstance().getDRObjects());
        } else {
            SystemRootImpl.setStatusInProcess((String)"Generate alarms...");
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Generate alarms"});
            vswitchGroupId = cluster.getVSwitchGroupId();
            objects = cluster.getCommKeyRefMap().getAllRefs();
        }
        PendingAlarmList pendingAlarmList = this.getPendingAlarmList(vswitchGroupId);
        for (Object curObj : objects) {
            GeneralLogicObjectImpl obj = (GeneralLogicObjectImpl)curObj;
            VSwitchImpl[] vSwitches = obj.getConnectedVSwitches();
            for (int i = 0; i < vSwitches.length; ++i) {
                this.setAlarmsIfNeed(obj, vSwitches[i], pendingAlarmList);
            }
        }
        try {
            this.closePendingAlarms();
        }
        catch (IllegalValueException e) {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{e});
        }
        if (cluster != null) {
            for (VSwitchImpl vSwitch : cluster.getVSwitches()) {
                this.setAlarmsIfNeed((GeneralLogicObjectImpl)vSwitch, pendingAlarmList);
            }
            this.setAlarmsIfNeed((GeneralLogicObjectImpl)cluster, pendingAlarmList);
            this.closePendingAlarms((VSwitchGroup)cluster);
        }
    }

    public void saveCachedClosedAlarms() {
        AlarmHistoryList.getInstance().saveCachedClosedAlarms();
    }

    @Override
    public void acknowledgeAlarms(List<Alarm> alarms, long period, String userName) throws RemoteException {
        Iterator<Integer> i = this.alarmLists.keySet().iterator();
        while (i.hasNext()) {
            AlarmList alarmList = this.alarmLists.get(i.next());
            alarmList.acknowledgeAlarms(alarms, userName);
        }
    }

    @Override
    public void unacknowledgeAlarms(List<Alarm> alarms) throws RemoteException {
        Iterator<Integer> i = this.alarmLists.keySet().iterator();
        while (i.hasNext()) {
            AlarmList alarmList = this.alarmLists.get(i.next());
            alarmList.unacknowledgeAlarms(alarms);
        }
    }

    private void setAlarmType(ClusterImpl cluster, HashMap parameterList) {
        String name = (String)((SrString)parameterList.get(ParameterCode.ALARM_TYPE_NAME)).value();
        AlarmType alarmType = AlarmType.getAlarmTypeByName(name);
        if (alarmType != null) {
            Object silent;
            Object troubleshooting;
            Object severityParam;
            Object categoryParam;
            Object emailParam = parameterList.get(ParameterCode.ALARM_TYPE_EMAIL);
            if (emailParam != null) {
                Boolean email = (Boolean)((SrBoolean)emailParam).value();
                alarmType.setMailEnabled(email);
            }
            if ((categoryParam = parameterList.get(ParameterCode.ALARM_TYPE_CATEGORY)) != null) {
                String category = (String)((SrString)categoryParam).value();
                alarmType.setCategory(category);
            }
            if ((severityParam = parameterList.get(ParameterCode.ALARM_TYPE_SEVERITY)) != null) {
                String severity = (String)((SrString)severityParam).value();
                alarmType.setAlarmSeverity(severity);
            }
            if ((troubleshooting = parameterList.get(ParameterCode.ALARM_TYPE_TROUBLESHOOTING)) != null && !troubleshooting.equals("")) {
                String troubleshoot = (String)((SrString)troubleshooting).value();
                alarmType.setTroubleShooting(troubleshoot);
            }
            if ((silent = parameterList.get(ParameterCode.ALARM_TYPE_SILENT)) != null) {
                String silentStr = (String)((SrString)silent).value();
                alarmType.setSilent(silentStr);
            }
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{"AlarmType: ", alarmType, " is set."});
        } else if (cluster != null) {
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{"AlarmType: ", name, " not found"});
        }
    }

    private void setEmailContactData(ClusterImpl cluster, HashMap parameterList) {
        String fromAddress = (String)((SrString)parameterList.get(ParameterCode.EMAIL_CONTACT_FROM_ADDRESS)).value();
        String toAddress = (String)((SrString)parameterList.get(ParameterCode.EMAIL_CONTACT_TO_ADDRESS)).value();
        String smtpHost = (String)((SrString)parameterList.get(ParameterCode.EMAIL_CONTACT_SMTP_HOST)).value();
        String smtpUser = (String)((SrString)parameterList.get(ParameterCode.EMAIL_CONTACT_SMTP_USER)).value();
        String smtpPassword = (String)((SrString)parameterList.get(ParameterCode.EMAIL_CONTACT_SMTP_PASSWORD)).value();
        this.alarmsNotificationData.setContactFromAddress(fromAddress);
        this.alarmsNotificationData.setContactToAddressList(toAddress);
        this.alarmsNotificationData.setContactSMTPHost(smtpHost);
        this.alarmsNotificationData.setContactSMTPPassword(smtpPassword);
        this.alarmsNotificationData.setContactSMTPUser(smtpUser);
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"from address: ", fromAddress, " is set."});
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"to address: ", toAddress, " is set."});
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"smtp server: ", smtpHost, " is set."});
    }

    public AlarmsNotificationData getAlarmsNotificationData() {
        return this.alarmsNotificationData;
    }

    @Override
    public List getEmailEnabledAlarmTypes() throws RemoteException {
        List<AlarmType> types = AlarmType.getAllAlarmTypes();
        ArrayList<AlarmType> emailEnabledTypes = new ArrayList<AlarmType>();
        for (int i = 0; i < types.size(); ++i) {
            AlarmType type = types.get(i);
            if (!type.isMailEnabled()) continue;
            emailEnabledTypes.add(type);
        }
        return emailEnabledTypes;
    }

    @Override
    public List<AlarmType> getAllAlarmTypes() throws RemoteException {
        return AlarmType.getAllAlarmTypes();
    }

    @Override
    public HashMap<String, String> getTroubleShootingMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        List<AlarmType> alarmTypes = AlarmType.getAllAlarmTypes();
        Iterator<AlarmType> i$ = alarmTypes.iterator();
        while (i$.hasNext()) {
            AlarmType curObj;
            AlarmType type = curObj = i$.next();
            map.put(type.getAlarmId(), type.getTroubleShooting());
        }
        return map;
    }

    @Override
    public HashMap getEmailContactParameters() throws RemoteException {
        HashMap<ClientParameterCode, String> parameters = new HashMap<ClientParameterCode, String>();
        parameters.put(ClientParameterCode.EMAIL_CONTACT_FROM_ADDRESS, this.alarmsNotificationData.getContactFromAddress());
        parameters.put(ClientParameterCode.EMAIL_CONTACT_TO_ADDRESS, this.alarmsNotificationData.getContactToAddressList());
        parameters.put(ClientParameterCode.EMAIL_CONTACT_SMTP_HOST, this.alarmsNotificationData.getContactSMTPHost());
        parameters.put(ClientParameterCode.EMAIL_CONTACT_SMTP_USER, this.alarmsNotificationData.getContactSMTPUser());
        parameters.put(ClientParameterCode.EMAIL_CONTACT_SMTP_PASSWORD, this.alarmsNotificationData.getContactSMTPPassword());
        return parameters;
    }

    @Override
    public void setEmailContactParameters(HashMap parameters) throws RemoteException {
        Object fromAddress = parameters.get(ClientParameterCode.EMAIL_CONTACT_FROM_ADDRESS);
        Object toAddress = parameters.get(ClientParameterCode.EMAIL_CONTACT_TO_ADDRESS);
        Object smtpHost = parameters.get(ClientParameterCode.EMAIL_CONTACT_SMTP_HOST);
        Object smtpUser = parameters.get(ClientParameterCode.EMAIL_CONTACT_SMTP_USER);
        Object smtpPassword = parameters.get(ClientParameterCode.EMAIL_CONTACT_SMTP_PASSWORD);
        if (fromAddress != null) {
            this.alarmsNotificationData.setContactFromAddress((String)fromAddress);
        }
        if (toAddress != null) {
            this.alarmsNotificationData.setContactToAddressList((String)toAddress);
        }
        if (smtpHost != null) {
            this.alarmsNotificationData.setContactSMTPHost((String)smtpHost);
        }
        if (smtpUser != null) {
            this.alarmsNotificationData.setContactSMTPUser((String)smtpUser);
        }
        if (smtpPassword != null) {
            this.alarmsNotificationData.setContactSMTPPassword((String)smtpPassword);
        }
        this.saveEmailContactConfiguration();
    }

    private void saveEmailContactConfiguration() throws RemoteException {
        ConfigElementData element = new ConfigElementData(ClassID.EMAIL_CONTACT);
        String from = this.alarmsNotificationData.getContactFromAddress();
        String to = this.alarmsNotificationData.getContactToAddressList();
        String host = this.alarmsNotificationData.getContactSMTPHost();
        String smtpUser = this.alarmsNotificationData.getContactSMTPUser();
        String smtpPassword = this.alarmsNotificationData.getContactSMTPPassword();
        if (from != null) {
            element.addParameter(new Parameter(ParameterCode.EMAIL_CONTACT_FROM_ADDRESS, (Object)new SrString(from)));
        }
        if (to != null) {
            element.addParameter(new Parameter(ParameterCode.EMAIL_CONTACT_TO_ADDRESS, (Object)new SrString(to)));
        }
        if (host != null) {
            element.addParameter(new Parameter(ParameterCode.EMAIL_CONTACT_SMTP_HOST, (Object)new SrString(host)));
        }
        if (smtpUser != null) {
            element.addParameter(new Parameter(ParameterCode.EMAIL_CONTACT_SMTP_USER, (Object)new SrString(smtpUser)));
        }
        if (smtpPassword != null) {
            element.addParameter(new Parameter(ParameterCode.EMAIL_CONTACT_SMTP_PASSWORD, (Object)new SrString(smtpPassword)));
        }
        DataMgrAdapter.getInstance().changeElement(element);
    }

    @Override
    public void setEmailEnabledAlarmTypes(List enabledAlarmTypes, List disabledAlarmTypes) throws RemoteException, IllegalValueException {
        AlarmType alarmType;
        AlarmType clientAlarmType;
        int i;
        ArrayList<AlarmType> types = new ArrayList<AlarmType>(enabledAlarmTypes.size() + disabledAlarmTypes.size());
        for (i = 0; i < enabledAlarmTypes.size(); ++i) {
            clientAlarmType = (AlarmType)enabledAlarmTypes.get(i);
            alarmType = AlarmType.getAlarmType(clientAlarmType.toString());
            alarmType.setMailEnabled(true);
            types.add(alarmType);
        }
        for (i = 0; i < disabledAlarmTypes.size(); ++i) {
            clientAlarmType = (AlarmType)disabledAlarmTypes.get(i);
            alarmType = AlarmType.getAlarmType(clientAlarmType.toString());
            alarmType.setMailEnabled(false);
            types.add(alarmType);
        }
        this.saveAlarmConfiguration(types);
    }

    private void saveAlarmConfiguration(List alarmTypes) throws RemoteException, IllegalValueException {
        ConfigElementDataList elementList = new ConfigElementDataList();
        for (int i = 0; i < alarmTypes.size(); ++i) {
            AlarmType type = (AlarmType)alarmTypes.get(i);
            ConfigElementData element = new ConfigElementData(ClassID.ALARM_TYPE);
            element.addParameter(new Parameter(ParameterCode.ALARM_TYPE_NAME, (Object)new SrString(type.getName())));
            element.addParameter(new Parameter(ParameterCode.ALARM_TYPE_EMAIL, (Object)new SrBoolean(type.isMailEnabled())));
            elementList.add((ElementData)element);
        }
        for (ElementData element : elementList) {
            DataMgrAdapter.getInstance().changeElement((ConfigElementData)element);
        }
    }

    public SrFuture<Void> handleElementEvent(SrEvent event) {
        int eventType = event.getType();
        if (eventType == 1 || eventType == 2) {
            ClusterImpl relevantCluster = null;
            SrElementEvent eventElement = (SrElementEvent)event;
            ConfigElementDataList cedList = eventElement.getElements();
            for (ElementData ced : cedList) {
                if (ced.getClassId().equals((Object)ClassID.ALARM_TYPE)) {
                    this.setAlarmType(relevantCluster, ced.getParametersList());
                    continue;
                }
                if (!ced.getClassId().equals((Object)ClassID.EMAIL_CONTACT)) continue;
                this.setEmailContactData(relevantCluster, ced.getParametersList());
            }
        }
        return new CompleteFuture("GeneralAlarmMgrImpl.handleElementEvent");
    }

    public void clearPendingAlarms(ClusterImpl cluster) throws RemoteException {
        this.getPendingAlarmList(this.getVswitchGroupId(cluster)).clear();
    }

    public void vSwitchGroupWasRemoved(VSwitchGroup vSwitchGroup) throws RemoteException {
        this.alarmLists.remove(vSwitchGroup.getVSwitchGroupId());
        this.pendingAlarmLists.remove(vSwitchGroup.getVSwitchGroupId());
    }

    protected abstract PendingAlarmList createPendingAlarmList() throws IllegalValueException, RemoteException;

    protected abstract AlarmList getAlarmList() throws RemoteException, IllegalValueException;

    protected abstract PendingAlarmList getPendingAlarmList() throws IllegalValueException, RemoteException;

    public static void removeAlarmFromMgrs(Alarm aAlarm) {
        if (aAlarm == null) {
            throw new IllegalArgumentException("The given argument should not be null");
        }
        ArrayList<Alarm> alarmsToRemove = new ArrayList<Alarm>();
        alarmsToRemove.add(aAlarm);
        try {
            Integer vsGroupId = aAlarm.getVSwitchGroupId();
            AlarmList vsList = DrAlarmMgrImpl.getInstance().getAlarmList(vsGroupId);
            if (vsList != null) {
                vsList.removeAlarm(alarmsToRemove);
                DataWarehouse.getInstance().removeAlarms(alarmsToRemove);
            }
            if ((vsList = AlarmMgrImpl.getInstance().getAlarmList(vsGroupId)) != null) {
                vsList.removeAlarm(alarmsToRemove);
                DataWarehouse.getInstance().removeAlarms(alarmsToRemove);
            }
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.EXCEPTION, (Throwable)exp, new Object[]{"A remote exception has occured inside a server context."});
        }
    }
}

