/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm;

import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.license.SrFeatureName;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class AlarmType
implements Serializable,
SrFeatureName {
    private static final long serialVersionUID = -4436504132988335898L;
    private static ArrayList<AlarmType> listVec = new ArrayList();
    private static int stateIndexCounter = 0;
    public static final AlarmType DISK_IS_MISSING = new AlarmType("0101", "StorageMissing", "Storage is missing", "Underlying resource unavailable", AlarmSeverity.CRITICAL, "Equipment");
    public static final AlarmType DISK_IS_INVALID = new AlarmType("0102", "StorageInvalid", "Storage is invalid", "Underlying resource unavailable", AlarmSeverity.MAJOR, "Equipment");
    public static final AlarmType DISK_UNKNOWN = new AlarmType("0103", "StorageUnknown", "Storage is unknown", "Underlying resource unavailable", AlarmSeverity.MAJOR, "Equipment");
    public static final AlarmType DISK_IS_CONFIGURED = new AlarmType("0104", "StorageProvisioned", "Storage is provisioning", "Configuration or customization error", AlarmSeverity.WARNING, "Equipment");
    public static final AlarmType SUBDISK_MISMATCH = new AlarmType("0105", "SubdiskMismatch", "Subdisk is mismatch", "Configuration or customization error", AlarmSeverity.MAJOR, "Equipment");
    public static final AlarmType VOLUME_NON_FUNC = new AlarmType("0201", "VolumeNonFunc", "Volume non-functional", "Underlying resource unavailable", AlarmSeverity.CRITICAL, "Communication");
    public static final AlarmType VOLUME_NEED_SYNC = new AlarmType("0203", "VolumeNeedSync", "Volume might need sync", "Corrupt data", AlarmSeverity.MINOR, "Environmental");
    public static final AlarmType MIR_NOT_MIR = new AlarmType("0208", "MirNotMir", "Mirror not mirroring", "Underlying resource unavailable", AlarmSeverity.MAJOR, "Quality of Service");
    public static final AlarmType OVER_USED_SNAPSHOT = new AlarmType("0213", "OverUsedSnapshot", "Snapshot Volume load threshold", "Corrupt data", AlarmSeverity.CRITICAL, "Environmental");
    public static final AlarmType SNAPSHOT_VOLUME_OUT_OF_SYNC = new AlarmType("0214", "SnapOutOfSync", "Snapshot Out Of Sync", "Configuration or customization error", AlarmSeverity.CRITICAL, "Environmental");
    public static final AlarmType SNAPSHOT_IS_FULL = new AlarmType("0215", "SnapshotFull", "Snapshot is full", "Configuration or customization error", AlarmSeverity.CRITICAL, "Environmental");
    public static final AlarmType SNAPSHOT_VOLUME_MODIFIED = new AlarmType("0216", "SnapshotModified", "Snapshot Modified", "Configuration or customization error", AlarmSeverity.MINOR, "Environmental");
    public static final AlarmType SNAPSHOT_EXPOSED_INCONSISTENT = new AlarmType("0217", "SnapshotExposedIncons", "Snapshot Exposure inconsistency", "Configuration or customization error", AlarmSeverity.CRITICAL, "Environmental");
    public static final AlarmType JOURNAL_OVER_USED = new AlarmType("0219", "OverUsedJournal", "Journal load threshold", "Configuration or customization error", AlarmSeverity.MAJOR, "Environmental");
    public static final AlarmType NON_VALIDATE = new AlarmType("0221", "NotValidated", "Element not validated", "Configuration or customization error", AlarmSeverity.WARNING, "Equipment");
    public static final AlarmType TARGET_NOT_CONNECTED = new AlarmType("0303", "TargetNotConnected", "iSCSI Target is not connected", "Underlying resource unavailable", AlarmSeverity.MAJOR, "Environmental");
    public static final AlarmType HARDWARE_FAN_FAULTY = new AlarmType("0401", "FANFaulty", "Fans faulty", "Equipment malfunction", AlarmSeverity.MINOR, "Equipment");
    public static final AlarmType HARDWARE_FAN_CRITICAL = new AlarmType("0402", "FANCritical", "Fans critical", "Equipment malfunction", AlarmSeverity.MAJOR, "Equipment");
    public static final AlarmType HARDWARE_POWER_SUPPLY_FAULTY = new AlarmType("0403", "PSFaulty", "Power supply faulty", "Equipment malfunction", AlarmSeverity.MAJOR, "Equipment");
    public static final AlarmType HARDWARE_CPU_TEMP_WARNING = new AlarmType("0404", "CPUTempWarning", "CPU temperature warning", "Heating or ventilation or cooling system problem", AlarmSeverity.MAJOR, "Equipment");
    public static final AlarmType HARDWARE_ON_BOARD_TEMP_WARNING = new AlarmType("0405", "OnBoardTempWarning", "On-board temperature warning", "Heating or ventilation or cooling system problem", AlarmSeverity.MAJOR, "Equipment");
    public static final AlarmType HARDWARE_NO_FAN = new AlarmType("0406", "NoFan", "No fans", "Equipment malfunction", AlarmSeverity.CRITICAL, "Equipment");
    public static final AlarmType HARDWARE_CPU_TEMP_CRITICAL = new AlarmType("0407", "CPUTempCritical", "CPU temperature critical", "Heating or ventilation or cooling system problem", AlarmSeverity.CRITICAL, "Equipment");
    public static final AlarmType HARDWARE_ON_BOARD_TEMP_CRITICAL = new AlarmType("0408", "OnBoardTempCritical", "On-board temperature critical", "Heating or ventilation or cooling system problem", AlarmSeverity.CRITICAL, "Equipment");
    public static final AlarmType DB_INCONSISTENT = new AlarmType("0409", "DBInconsistent", "Unexpected problem with the database", "Database integrity problem", AlarmSeverity.CRITICAL, "Environmental");
    public static final AlarmType NEIGH_DEAD = new AlarmType("0502", "NeighDead", "Neighbor dead", "LAN error", AlarmSeverity.CRITICAL, "Communication");
    public static final AlarmType NEIGH_SUSP = new AlarmType("0503", "NeighSusp", "Neighbor suspended", "Congestion", AlarmSeverity.MINOR, "Communication");
    public static final AlarmType NEIGH_UNK = new AlarmType("0504", "NeighUnk", "Neighbor unknown", "Communications protocol error", AlarmSeverity.WARNING, "Communication");
    public static final AlarmType OBJ_NOT_REDUNDANT = new AlarmType("0505", "ObjNotRedundant", "Object not redundant", "Configuration or customization error", AlarmSeverity.MINOR, "Processing Error");
    public static final AlarmType ALIAS_INCONS = new AlarmType("0506", "AliasIncons", "Alias inconsistency", "Configuration or customization error", AlarmSeverity.MINOR, "Processing Error");
    public static final AlarmType LU_NUMBER_INCONS = new AlarmType("0507", "LUTargetIncons", "LU number inconsistency", "Configuration or customization error", AlarmSeverity.CRITICAL, "Processing Error");
    public static final AlarmType ATTRIBUTE_INCONS = new AlarmType("0508", "AttributeIncons", "Attribute inconsistency", "Configuration or customization error", AlarmSeverity.MINOR, "Processing Error");
    public static final AlarmType SUB_DISK_INCONS = new AlarmType("0509", "SubDiskIncons", "Subdisk inconsistency", "Configuration or customization error", AlarmSeverity.CRITICAL, "Processing Error");
    public static final AlarmType ILLEGAL_SUB_DISK = new AlarmType("0510", "IllegalSubDisk", "Illegal subdisk", "Configuration or customization error", AlarmSeverity.CRITICAL, "Processing Error");
    public static final AlarmType VOLUME_ILLEGAL = new AlarmType("0511", "VolumeIllegal", "Illegal volume configuration", "Configuration or customization error", AlarmSeverity.CRITICAL, "Processing Error");
    public static final AlarmType LU_VOLUME_INCONS = new AlarmType("0512", "LUVolumeIncons", "LU inconsistency", "Configuration or customization error", AlarmSeverity.CRITICAL, "Processing Error");
    public static final AlarmType TARGET_VOLUME_INCONS = new AlarmType("0513", "TargetVolumeIncons", "Target inconsistency", "Configuration or customization error", AlarmSeverity.CRITICAL, "Processing Error");
    public static final AlarmType VSWITCH_TAKEOVER = new AlarmType("0514", "VSwitchTakeover", VSwitch.VSWITCH_DISPLAY_STRING + " takeover", "Communications protocol error", AlarmSeverity.WARNING, "Communication");
    public static final AlarmType ACL_INCONS = new AlarmType("0515", "InconsACL", "ACL inconsistency", "Configuration or customization error", AlarmSeverity.CRITICAL, "Communication");
    public static final AlarmType VOLUME_INCONSISTENT = new AlarmType("0516", "VolumeIncons", "Volume children might be inconsist", "Configuration or customization error", AlarmSeverity.CRITICAL, "Processing Error");
    public static final AlarmType VSWITCHES_NOT_NEIGHBORS = new AlarmType("0518", "VSwitchesNotNeighbors", VSwitch.VSWITCHES_DISPLAY_STRING + " are not neighbors", "Configuration or customization error", AlarmSeverity.MAJOR, "Environmental");
    public static final AlarmType TARGET_EXPOSED_INCONS = new AlarmType("0519", "TargetExposedIncons", "Target exposed inconsistency", "Configuration or customization error", AlarmSeverity.CRITICAL, "Processing Error");
    public static final AlarmType ILLEAGAL_VOL_PAIR = new AlarmType("0521", "IllegalVolPair", "Pair is not legal", "Configuration or customization error", AlarmSeverity.MAJOR, "Processing Error");
    public static final AlarmType ILLEAGAL_PAIR_CG = new AlarmType("0522", "IllegalPairCG", "Illegal pair in CG", "Configuration or customization error", AlarmSeverity.MAJOR, "Processing Error");
    public static final AlarmType PORTAL_INCONSISTENCY = new AlarmType("0524", "PortalInconsistency", "Portal is problematic comparatively to switches", "Configuration or customization error", AlarmSeverity.MINOR, "Environmental");
    public static final AlarmType ACL_ENTRY_NOT_REDUNDANT = new AlarmType("0525", "ACLEntryNotRedundant", "ACL entry not redundant", "Configuration or customization error", AlarmSeverity.MINOR, "Processing Error");
    public static final AlarmType VSWITCH_DISCONNECTED = new AlarmType("0901", "VSwitchDisconnected", VSwitch.VSWITCH_DISPLAY_STRING + " disconnected", "Underlying resource unavailable", AlarmSeverity.CRITICAL, "Equipment");
    public static final AlarmType VSWITCH_LOW_MEMORY = new AlarmType("0410", "LowMemory", "Device has low memory", "Equipment malfunction", AlarmSeverity.CRITICAL, "Environmental");
    public static final AlarmType VSWITCH_TRAP_PORT_IS_IN_USE = new AlarmType("0902", "VSwitchTrapPortInUse", "Trap port is in use", "Underlying resource unavailable", AlarmSeverity.CRITICAL, "Equipment");
    public static final AlarmType LINK_DOWN = new AlarmType("1001", "LinkDown", "Link down", "Equipment Malfunction", AlarmSeverity.WARNING, "Equipment");
    public static final AlarmType SFP_SPEED_TOO_HIGH = new AlarmType("1002", "MismSFP", "SFP connector speed is higher than interface port speed", "Configuration or customization error", AlarmSeverity.WARNING, "Equipment");
    public static final AlarmType SFP_SPEED_TOO_LOW = new AlarmType("1003", "SFPSpeedLow", "SFP connector speed is lower than interface port speed", "Configuration or customization error", AlarmSeverity.MAJOR, "Equipment");
    public static final AlarmType VOLUME_OPER = new AlarmType("1105", "VolumeOper", "Volume operational", "", AlarmSeverity.WARNING, "Environmental");
    public static final AlarmType VOLUME_OPER_ER = new AlarmType("1106", "VolumeOperEr", "Volume operational error", "Software program abnormally terminated", AlarmSeverity.MAJOR, "Processing Error");
    public static final AlarmType JOURNAL_OUT_OF_SYNC = new AlarmType("1201", "JournalOutOfSync", "Journal is out of sync", "Configuration or customization error", AlarmSeverity.CRITICAL, "Equipment");
    public static final AlarmType JOURNAL_FULL = new AlarmType("1202", "JournalFull", "Journal is full", "Configuration or customization error", AlarmSeverity.CRITICAL, "Equipment");
    public static final AlarmType DR_STATE_ERROR = new AlarmType("1203", "PairError", "Pair/CG is not able to replicate", "Configuration or customization error", AlarmSeverity.MAJOR, "Environmental");
    public static final AlarmType NEED_SYNC = new AlarmType("1204", "NeedSync", "Pair/CG needs to be synchronized", "Underlying resource unavailable", AlarmSeverity.MAJOR, "Communication");
    public static final AlarmType CG_DR_UNKNOWN = new AlarmType("1207", "CGDRUnknown", "Consistency group is in unknown mode", "Configuration or customization error", AlarmSeverity.CRITICAL, "Processing Error");
    public static final AlarmType CF_WAIT = new AlarmType("1214", "ControlFunctionWait", "Communication between sites is in process", "Configuration or customization error", AlarmSeverity.WARNING, "Environmental");
    public static final AlarmType CF_FAIL = new AlarmType("1215", "ControlFunctionFails", "Communication between sites was failed", "Configuration or customization error", AlarmSeverity.MINOR, "Environmental");
    public static final AlarmType NOT_SYMTRIC_DR = new AlarmType("1301", "NotSymetricDR", "Not symmetric GDR", "Configuration or customization error", AlarmSeverity.MINOR, "Environmental");
    public static final AlarmType UNEQUIVALENT_PAIR = new AlarmType("1302", "UnEquivalentPair", "Pair is not equal", " Configuration or customization error ", AlarmSeverity.MAJOR, "Environmental");
    public static final AlarmType INVERTED_PAIR = new AlarmType("1303", "InvertedPair", "Pair is inverted", " Configuration or customization error ", AlarmSeverity.CRITICAL, "Environmental");
    public static final AlarmType ASYMETRIC_ATTRIBUTE = new AlarmType("1304", "AsymetricAttribute", "Asymmetric attribute", "Configuration or customization error", AlarmSeverity.MAJOR, "Environmental");
    public static final AlarmType INVERT_ROLE = new AlarmType("1305", "InvertRole", "Role is inverted", "Configuration or customization error", AlarmSeverity.MAJOR, "Environmental");
    public static final AlarmType INCONS_REPLICATION = new AlarmType("1306", "InconsReplication", "The replication's policy is not consistent", " Configuration or customization error ", AlarmSeverity.MAJOR, "Environmental");
    public static final AlarmType DIFF_SIZE = new AlarmType("1308", "DiffSize", "Primary size is not equal to secondary size", "Configuration or customization error", AlarmSeverity.MAJOR, "Environmental");
    public static final AlarmType NON_FUNCTIONAL = new AlarmType("-1", "NonFunctional", "Source is not functional", "Underlying resource unavailable", AlarmSeverity.CRITICAL, "Communication");
    public static final AlarmType INCONSISTENT_NEIGHBOR_REMOVED = new AlarmType("0531", "NeighborRemoved", "Neighbor removed", "Configuration or customization error", AlarmSeverity.MAJOR, "Environmental");
    private final String name;
    private final String description;
    private final String probableCause;
    private AlarmSeverity severity;
    private String category;
    private boolean mailEnabled = false;
    private boolean callHomeEnabled = false;
    private final String alarmNumber;
    private String troubleShooting;
    private final int stateIndex;
    private boolean isSilent;

    private AlarmType(String alarmNumber, String name, String description, String probableCause, AlarmSeverity severity, String category) {
        this.name = name;
        this.description = description;
        this.probableCause = probableCause;
        this.severity = severity;
        this.category = category;
        this.alarmNumber = alarmNumber;
        listVec.add(this);
        this.stateIndex = stateIndexCounter++;
    }

    public String getProbableCause() {
        return this.probableCause;
    }

    public AlarmSeverity getSeverity() {
        return this.severity;
    }

    public void setAlarmSeverity(String severity) {
        this.severity = AlarmSeverity.getAlarmSeverity(severity);
    }

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AlarmType) {
            return ((AlarmType)obj).name.equals(this.name);
        }
        return false;
    }

    public String toString() {
        return this.description;
    }

    public static synchronized AlarmType getAlarmType(String description) {
        for (AlarmType alarmType : listVec) {
            if (!alarmType.description.equals(description)) continue;
            return alarmType;
        }
        return null;
    }

    public static synchronized AlarmType getAlarmTypeByName(String name) {
        for (AlarmType alarmType : listVec) {
            if (!alarmType.name.equals(name)) continue;
            return alarmType;
        }
        return null;
    }

    public void setMailEnabled(boolean mailEnabled) {
        this.mailEnabled = mailEnabled;
    }

    public boolean isMailEnabled() {
        return this.mailEnabled;
    }

    public void setCallHomeEnabled(boolean callHomeEnabled) {
        this.callHomeEnabled = callHomeEnabled;
    }

    public boolean isCallHomeEnabled() {
        return this.callHomeEnabled;
    }

    public static synchronized List<AlarmType> getAllAlarmTypes() {
        return listVec;
    }

    public String getAlarmId() {
        return this.alarmNumber;
    }

    public void setTroubleShooting(String troubleshooting) {
        this.troubleShooting = troubleshooting;
    }

    public void setSilent(String silent) {
        if (silent != null) {
            this.isSilent = true;
        }
        this.isSilent = false;
    }

    public String getTroubleShooting() {
        return this.troubleShooting;
    }

    public int getStateIndex() {
        return this.stateIndex;
    }

    public static int getCount() {
        return AlarmType.getAllAlarmTypes().size();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean getSilentValue() {
        return this.isSilent;
    }

    public static synchronized void removeIfNonSupportedAlarm(String support, String alarmName) {
        String string = support = support == null ? "true" : support;
        if (!new Boolean(support).booleanValue()) {
            AlarmType alarmType = AlarmType.getAlarmTypeByName(alarmName);
            AlarmType.getAllAlarmTypes().remove(alarmType);
        }
    }
}

