/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.RemoteEvent;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.ServerPropertiesFetcher;
import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmHistoryList;
import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.alarm.AlarmsNotificationData;
import com.sanrad.nms.server.alarm.GeneralAlarmMgrImpl;
import com.sanrad.nms.server.alarm.event.AlarmChangedEvent;
import com.sanrad.nms.server.alarm.event.AlarmChangedListener;
import com.sanrad.nms.server.alarm.event.AlarmEvent;
import com.sanrad.nms.server.alarm.event.AlarmEventImpl;
import com.sanrad.nms.server.alarm.event.AlarmEventListener;
import com.sanrad.nms.server.logic.DataWarehouse;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRLogicObject;
import com.sanrad.nms.server.logic.dr.DRLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.user.UserManagerImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.types.constants.DrSiteConstant;
import com.sanrad.security.StringCodec;
import com.sanrad.util.MailSender;
import com.sanrad.util.SrEventListenerManager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class AlarmList
implements Cloneable,
AlarmChangedListener {
    protected Hashtable<GeneralLogicObject, List<Alarm>> list = new Hashtable();
    private SrEventListenerManager m_listeners = new SrEventListenerManager();
    private static SrLogger theLogger = SrLogger.getLogger();
    private static MailSender mailSender = new MailSender();
    private static String from = null;
    private static String host = null;
    private static String to = null;
    private static String smtpUser = null;
    private static String smtpPassword = null;
    SrEventListenerManager.RemoteInformer<AlarmEventListener, AlarmEvent> alarmOpenedInformer = new SrEventListenerManager.RemoteInformer<AlarmEventListener, AlarmEvent>(){

        public void inform(AlarmEventListener listener, AlarmEvent event) {
            listener.alarmOpened(event);
        }
    };
    SrEventListenerManager.RemoteInformer<AlarmEventListener, AlarmEvent> alarmClosedInformer = new SrEventListenerManager.RemoteInformer<AlarmEventListener, AlarmEvent>(){

        public void inform(AlarmEventListener listener, AlarmEvent event) {
            listener.alarmClosed(event);
        }
    };

    public AlarmList() throws RemoteException {
        this.setEmailParameters();
    }

    private void setEmailParameters() throws RemoteException {
        String key = UserManagerImpl.getInstance().getCodecKey();
        AlarmsNotificationData data = AlarmMgrImpl.getInstance().getAlarmsNotificationData();
        from = data.getContactFromAddress();
        host = data.getContactSMTPHost();
        to = data.getContactToAddressList();
        smtpUser = data.getContactSMTPUser();
        smtpPassword = StringCodec.decryptString((String)key, (String)data.getContactSMTPPassword());
    }

    protected AlarmList(AlarmList alarmList) throws RemoteException {
        this.list = (Hashtable)alarmList.list.clone();
    }

    public void setAlarmList(Hashtable<GeneralLogicObject, List<Alarm>> alarmLists) {
        this.list = alarmLists;
    }

    public AlarmList(Hashtable<Integer, ? extends AlarmList> alarmLists) {
        AlarmList alarmList = alarmLists.get(DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue());
        this.list = alarmList.list;
    }

    private boolean isAlarmAlreadyExists(Alarm alarm) throws RemoteException {
        List<Alarm> alarms = this.getAlarms((GeneralLogicObjectImpl)alarm.getSource(), alarm.getVSwitch());
        for (Alarm openedAlarm : alarms) {
            if (!openedAlarm.equals(alarm)) continue;
            return true;
        }
        return false;
    }

    public synchronized void addAlarmEventListener(AlarmEventListener listener) {
        this.m_listeners.add((EventListener)listener);
    }

    public synchronized void removeAlarmEventListener(AlarmEventListener listener) {
        this.m_listeners.remove((EventListener)listener);
    }

    private AlarmEvent getAlarmEvent(Alarm alarm) throws RemoteException {
        return new AlarmEventImpl(alarm.getSource(), alarm);
    }

    public synchronized void addAlarmIfNotExists(GeneralLogicObject source, List<AlarmImpl> alarms) throws RemoteException {
        for (AlarmImpl alarm : alarms) {
            this.addAlarmIfNotExists(source, alarm);
        }
    }

    public synchronized void addAlarmIfNotExists(GeneralLogicObject source, Alarm alarm) throws RemoteException {
        if (this.isAlarmAlreadyExists(alarm)) {
            return;
        }
        List<Alarm> alarms = this.getAlarms((GeneralLogicObjectImpl)alarm.getSource());
        StringBuffer debugMsg = new StringBuffer("Alarm ");
        debugMsg.append(alarm.getType());
        debugMsg.append(" on source ");
        debugMsg.append(alarm.getSource());
        if (alarm.getVSwitch() != null) {
            debugMsg.append(" on ");
            debugMsg.append(ClassID.VSWITCH);
            debugMsg.append(" ");
            debugMsg.append(alarm.getVSwitch());
        }
        debugMsg.append(" was added to AlarmList");
        ((AlarmImpl)alarm).addAlarmChangedListener(this);
        if (alarms == null) {
            alarms = new ArrayList<Alarm>();
            alarms.add(alarm);
            this.list.put(source, alarms);
            debugMsg.append(" - this is the first alarm on this source");
        } else {
            alarms.add(alarm);
        }
        theLogger.trace(SrLogCategories.ERROR, new Object[]{LogicMgrAOImpl.getInstance().getLogicObject(alarm.hashKey()) != null, "The alarm cannot be found"});
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{debugMsg});
        this.notifySourceNewState(((AlarmImpl)alarm).getSource());
        if (!((AlarmImpl)alarm).isReopened()) {
            AlarmEvent event = this.getAlarmEvent(alarm);
            this.m_listeners.fireEvent(AlarmEventListener.class, (RemoteEvent)event, this.alarmOpenedInformer);
            if (!AlarmMgrImpl.getInstance().isAlarmExistsInTheSilencedList((AlarmImpl)alarm)) {
                if (!(event.getSource() instanceof DRClusterLogicObjectImpl)) {
                    LogicMgrAOImpl.getInstance().__alarmOpened(event);
                }
                this.setEmailParameters();
                if (alarm.getType().isMailEnabled() && to != null) {
                    theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Sending Email about alarm: '", alarm.getType(), "' to - ", to});
                    mailSender.initMessage(host, smtpUser, smtpPassword, from, to, "Alarm from " + Server.FULL_PRODUCT_NAME + ": " + alarm.getMessage());
                    mailSender.sendMail(((AlarmImpl)alarm).getAlarmEmailText());
                }
            }
        }
    }

    public synchronized void removeAlarm(GeneralLogicObjectImpl source, VSwitch vSwitch) throws RemoteException {
        this.removeAlarm(this.getAlarms(source, vSwitch));
    }

    public synchronized void removeAlarm(GeneralLogicObjectImpl source) throws RemoteException {
        this.removeAlarm(this.getAlarms(source, null));
    }

    public synchronized void removeAlarm(List<Alarm> alarms) throws RemoteException {
        this.removeAlarms(alarms, null, false);
    }

    public synchronized void removeAlarms(List<Alarm> alarms, String removedBy, boolean isSilent) throws RemoteException {
        if (alarms != null && !alarms.isEmpty()) {
            Alarm[] alarmsObj = alarms.toArray(new Alarm[alarms.size()]);
            int i = alarmsObj.length;
            while (i-- > 0) {
                this.removeAlarm(alarmsObj[i], removedBy, isSilent);
            }
        }
    }

    public synchronized void removeAlarm(Alarm alarm) throws RemoteException {
        this.removeAlarm(alarm, null);
    }

    private void removeAlarm(Alarm alarm, String removedBy) throws RemoteException {
        this.removeAlarm(alarm, removedBy, false);
    }

    public synchronized void removeAlarm(Alarm alarm, String removedBy, boolean isRemovedByUser) throws RemoteException {
        AlarmImpl alarmImpl;
        GeneralLogicObject source = alarm.getSource();
        List<Alarm> alarms = null;
        Object sourceImpl = null;
        sourceImpl = source instanceof DRLogicObject ? (source instanceof DRLogicObjectImpl ? (GeneralLogicObjectImpl)source : DRRootImpl.getInstance().getDRObject((DRLogicObject)source)) : (source instanceof LogicObjectImpl ? (GeneralLogicObjectImpl)source : (LogicObjectImpl)SystemRootImpl.getInstance().getRefByStub(((LogicObject)source).getCommKeys(), source.getClassId()));
        if (sourceImpl != null) {
            alarms = this.getAlarms((GeneralLogicObjectImpl)sourceImpl);
        }
        if (alarms != null && (alarmImpl = this.getAlarmImplFromAlarm(alarm)) != null) {
            alarmImpl.removeAlarmChangedListener(this);
            boolean closedAlarmSucceeded = false;
            if (isRemovedByUser) {
                alarmImpl.setSilent();
                closedAlarmSucceeded = true;
            } else {
                closedAlarmSucceeded = alarms.remove(alarmImpl);
            }
            StringBuffer debugMsg = new StringBuffer("Alarm ");
            debugMsg.append(alarm.getType());
            debugMsg.append(" on source ");
            debugMsg.append(alarm.getSource());
            if (alarm.getVSwitch() != null) {
                debugMsg.append(" on ");
                debugMsg.append(ClassID.VSWITCH);
                debugMsg.append(" ");
                debugMsg.append(alarm.getVSwitch());
            }
            if (closedAlarmSucceeded) {
                debugMsg.append(" was removed from AlarmList");
                if (alarms.isEmpty() && !isRemovedByUser) {
                    this.list.remove(alarm.getSource());
                    debugMsg.append(" - this was the last alarm on this source");
                }
                theLogger.trace(SrLogCategories.LEGACY, new Object[]{debugMsg});
                if (isRemovedByUser || !alarmImpl.isSilent()) {
                    this.addToHistory(alarm, removedBy, false, (GeneralLogicObject)sourceImpl);
                }
            } else {
                debugMsg.insert(0, "Failed to remove ");
                theLogger.warn(SrLogCategories.LEGACY, new Object[]{debugMsg});
            }
        }
        DataWarehouse.getInstance().removeAlarm(alarm.hashKey());
    }

    public void addToHistory(List<Alarm> alarms, boolean pendingAlarm) throws RemoteException {
        for (Alarm alarm : alarms) {
            this.addToHistory(alarm, null, pendingAlarm, alarm.getSource());
        }
    }

    protected void addToHistory(Alarm alarm, String removedBy, boolean pendingAlarm, GeneralLogicObject element) throws RemoteException {
        if (!pendingAlarm) {
            this.notifySourceNewState((GeneralLogicObjectImpl)element);
            if (alarm.getSource() != null) {
                AlarmEvent event = this.getAlarmEvent(alarm);
                this.m_listeners.fireEvent(AlarmEventListener.class, (RemoteEvent)event, this.alarmClosedInformer);
                LogicMgrAOImpl.getInstance().__alarmClosed(event);
            }
        }
        if (ServerPropertiesFetcher.isHistoryAlarmsEnabled()) {
            AlarmHistoryList.getInstance().addToAlarmHistoryList(alarm, removedBy);
        }
        GeneralAlarmMgrImpl.removeAlarmFromMgrs(alarm);
        DataWarehouse.getInstance().removeAlarm(alarm.hashKey());
    }

    public synchronized void removeAlarm(Alarm[] alarms) throws RemoteException {
        this.removeAlarm(alarms, null);
    }

    public synchronized void removeAlarm(Alarm[] alarms, String removedBy) throws RemoteException {
        for (int i = 0; i < alarms.length; ++i) {
            this.removeAlarm(alarms[i], removedBy);
        }
    }

    public List<Alarm> getAlarms(GeneralLogicObjectImpl source, VSwitch vSwitch) throws RemoteException {
        ArrayList<Alarm> alarms = new ArrayList<Alarm>();
        List<Alarm> allAlarms = this.getAlarms(source);
        if (allAlarms != null) {
            for (Alarm alarm : allAlarms) {
                if ((alarm.getVSwitch() == null || !alarm.getVSwitch().equals(vSwitch)) && (vSwitch != null || alarm.getVSwitch() != null)) continue;
                alarms.add(alarm);
            }
        }
        return alarms;
    }

    public Hashtable<GeneralLogicObject, List<Alarm>> getAllAlarms() throws RemoteException {
        Hashtable<GeneralLogicObject, List<Alarm>> sendList = new Hashtable<GeneralLogicObject, List<Alarm>>();
        Hashtable<GeneralLogicObject, List<Alarm>> iterList = new Hashtable<GeneralLogicObject, List<Alarm>>(this.list);
        for (GeneralLogicObject key : iterList.keySet()) {
            List<Alarm> alarms = iterList.get(key);
            if (alarms == null) continue;
            ArrayList<Alarm> sendAlarms = new ArrayList<Alarm>();
            for (int i = 0; i < alarms.size(); ++i) {
                if (alarms.get(i).isSilent()) continue;
                sendAlarms.add(alarms.get(i));
            }
            if (sendAlarms.isEmpty()) continue;
            sendList.put(key, sendAlarms);
        }
        return sendList;
    }

    public List<Alarm> getAllAlarmsOnVSwitch(VSwitch vSwitch) throws RemoteException {
        ArrayList<Alarm> alarmsOnVSwitch = new ArrayList<Alarm>();
        Enumeration<GeneralLogicObject> e = this.getAllAlarms().keys();
        while (e.hasMoreElements()) {
            LogicObjectImpl source = (LogicObjectImpl)e.nextElement();
            List<Alarm> alarms = this.getAlarms((GeneralLogicObjectImpl)source, vSwitch);
            alarmsOnVSwitch.addAll(alarms);
        }
        return alarmsOnVSwitch;
    }

    public List<Alarm> getAlarms(CommKey[] sourceCommKey, ClassID sourceClassId) throws RemoteException {
        LogicObjectImpl source = (LogicObjectImpl)SystemRootImpl.getInstance().getRefByStub(sourceCommKey, sourceClassId);
        if (source != null) {
            return this.getAlarms((GeneralLogicObjectImpl)source);
        }
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Source ", sourceClassId, ", ", sourceCommKey, " is null"});
        return null;
    }

    public List<Alarm> getAlarms(GeneralLogicObjectImpl source) throws RemoteException {
        if (this.list == null || source == null) {
            return new ArrayList<Alarm>();
        }
        return this.list.get(source);
    }

    public List<Alarm> getAlarms(GeneralLogicObject source) throws RemoteException {
        if (source instanceof DRLogicObject) {
            return this.getAlarms((GeneralLogicObjectImpl)DRRootImpl.getInstance().getDRObject((DRLogicObject)source));
        }
        return this.getAlarms(((LogicObject)source).getCommKeys(), ((LogicObject)source).getClassId());
    }

    private GeneralLogicObject notifySourceNewState(GeneralLogicObjectImpl source) throws RemoteException {
        AlarmSeverity newState;
        boolean stateModified;
        if (source != null && (stateModified = source.setStateSeverity(newState = this.getState((GeneralLogicObject)source)))) {
            this.notifySourceNewAcknowledgeState((GeneralLogicObject)source);
        }
        return source;
    }

    private void notifySourceNewAcknowledgeState(GeneralLogicObject source) throws RemoteException {
        AlarmSeverity newAckState = this.getAckState(source);
        source.setAcknowledgeStateSeverity(newAckState);
    }

    public void clear() {
        this.list.clear();
    }

    private synchronized AlarmSeverity getState(GeneralLogicObject source) throws RemoteException {
        List<Alarm> alarms = this.getAlarms(source);
        AlarmSeverity severity = AlarmSeverity.OK;
        if (alarms != null) {
            for (Alarm alarm : alarms) {
                AlarmSeverity alarmSeverity;
                if (alarm.isSilent() || !(alarmSeverity = alarm.getSeverity()).isMoreSevereThan(severity)) continue;
                severity = alarmSeverity;
            }
        }
        return severity;
    }

    private synchronized AlarmSeverity getAckState(GeneralLogicObject source) throws RemoteException {
        List<Alarm> alarms = this.getAlarms(source);
        AlarmSeverity severity = AlarmSeverity.OK;
        if (alarms != null) {
            for (Alarm alarm : alarms) {
                AlarmSeverity alarmSeverity;
                if (alarm.isAcknowledged() || alarm.isSilent() || !(alarmSeverity = alarm.getSeverity()).isMoreSevereThan(severity)) continue;
                severity = alarmSeverity;
            }
        }
        return severity;
    }

    public Object clone() {
        try {
            AlarmList newList = new AlarmList();
            newList.list = (Hashtable)this.list.clone();
            return newList;
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, (Throwable)re, new Object[0]);
            return null;
        }
    }

    public void closeAlarmsOnVSwitch(VSwitch vSwitch) throws RemoteException {
        List<Alarm> alarms = this.getAllAlarmsOnVSwitch(vSwitch);
        this.removeAlarm(alarms);
        alarms = this.getAllAlarmsOnVSwitch(null);
        this.removeAlarm(alarms);
    }

    public synchronized void acknowledgePendingAlarms(List<Alarm> pendingAlarms) throws RemoteException {
        if (pendingAlarms != null) {
            for (Alarm alarm : pendingAlarms) {
                this.acknowledgeAlarm(alarm, true, alarm.getAcknowledgedBy(), alarm.getAckDateAndTime());
            }
        }
    }

    public synchronized void acknowledgeAlarms(List<Alarm> alarms, String ackBy) throws RemoteException {
        if (alarms != null) {
            for (Alarm curAlarm : alarms) {
                this.acknowledgeAlarm(curAlarm, true, ackBy);
            }
        }
    }

    public synchronized void unacknowledgeAlarms(List<Alarm> alarms) throws RemoteException {
        if (alarms != null) {
            for (Alarm curAlarm : alarms) {
                this.unAcknowledgeAlarm(curAlarm);
            }
        }
    }

    private boolean compare(Alarm alarm, Alarm otherAlarm) throws RemoteException {
        boolean isSourceEqual;
        if (alarm.equals(otherAlarm)) {
            return true;
        }
        if (!(alarm.getSource() instanceof DRLogicObject)) {
            if (otherAlarm.getSource() instanceof DRLogicObject) {
                return false;
            }
            isSourceEqual = ((LogicObject)alarm.getSource()).getCommKeyClassId().equals((Object)((LogicObject)otherAlarm.getSource()).getCommKeyClassId());
        } else {
            isSourceEqual = alarm.getSource().hashKey().equals(alarm.getSource().hashKey());
        }
        boolean isTypeEqual = alarm.getType().equals(otherAlarm.getType());
        boolean isVSwitchEqual = alarm.getVSwitch() != null && otherAlarm.getVSwitch() != null ? alarm.getVSwitch().getCommKeyClassId().equals((Object)otherAlarm.getVSwitch().getCommKeyClassId()) : alarm.getVSwitch() == null && otherAlarm.getVSwitch() == null;
        Object alarmAdditionalKeyObject = alarm.getAdditionalKeyObject();
        Object otherAlarmAdditionalKeyObject = otherAlarm.getAdditionalKeyObject();
        boolean isAdditionalKeyEqual = alarmAdditionalKeyObject != null && otherAlarmAdditionalKeyObject != null ? (alarmAdditionalKeyObject instanceof LogicObject && otherAlarmAdditionalKeyObject instanceof LogicObject ? ((LogicObject)alarmAdditionalKeyObject).getCommKeyClassId().equals((Object)((LogicObject)otherAlarmAdditionalKeyObject).getCommKeyClassId()) : alarmAdditionalKeyObject.equals(otherAlarmAdditionalKeyObject)) : alarmAdditionalKeyObject == null && otherAlarmAdditionalKeyObject == null;
        return isSourceEqual && isTypeEqual && isVSwitchEqual && isAdditionalKeyEqual;
    }

    protected void unAcknowledgeAlarm(Alarm alarm) throws RemoteException {
        this.acknowledgeAlarm(alarm, false, "");
    }

    protected void acknowledgeAlarm(Alarm alarm, boolean ack, String ackBy) throws RemoteException {
        this.acknowledgeAlarm(alarm, ack, ackBy, 0L);
    }

    protected void acknowledgeAlarm(Alarm alarm, boolean ack, String ackBy, long dateAndTime) throws RemoteException {
        AlarmImpl alarmToAck = this.getAlarmImplFromAlarm(alarm);
        if (alarmToAck != null) {
            String debugMsgSuffix;
            if (ack) {
                debugMsgSuffix = " was acknowledged by " + ackBy;
                if (dateAndTime > 0L) {
                    alarmToAck.setAcknowledged(ackBy, dateAndTime);
                } else {
                    alarmToAck.setAcknowledged(ackBy);
                }
            } else {
                debugMsgSuffix = " was unacknowledged";
                alarmToAck.setUnacknowledged();
            }
            StringBuffer debugMsg = new StringBuffer("Alarm ");
            debugMsg.append(alarmToAck.getType());
            debugMsg.append(" on source ");
            debugMsg.append(alarmToAck.getSource());
            if (alarmToAck.getVSwitch() != null) {
                debugMsg.append(" on ");
                debugMsg.append(ClassID.VSWITCH);
                debugMsg.append(" ");
                debugMsg.append(alarmToAck.getVSwitch());
            }
            debugMsg.append(debugMsgSuffix);
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{debugMsg});
        }
    }

    private AlarmImpl getAlarmImplFromAlarm(Alarm alarm) throws RemoteException {
        if (alarm instanceof AlarmImpl) {
            return (AlarmImpl)alarm;
        }
        GeneralLogicObject source = alarm.getSource();
        List<Alarm> alarms = null;
        if (source instanceof DRLogicObject) {
            DRLogicObjectImpl sourceImpl = DRRootImpl.getInstance().getDRObject((DRLogicObject)source);
            if (sourceImpl != null) {
                alarms = this.getAlarms((GeneralLogicObject)sourceImpl);
            }
        } else {
            alarms = this.getAlarms(((LogicObject)source).getCommKeys(), source.getClassId());
        }
        if (alarms != null && !alarms.isEmpty()) {
            for (int i = 0; i < alarms.size(); ++i) {
                Alarm nextAlarm = alarms.get(i);
                if (!this.compare(alarm, nextAlarm)) continue;
                return (AlarmImpl)nextAlarm;
            }
        }
        return null;
    }

    @Override
    public void acknowledgeAlarmStateChanged(AlarmChangedEvent event) {
        Object source = null;
        try {
            source = event.getSourceObject() instanceof DRLogicObject ? this.findDrObjectFromStub(event.getSourceObject()) : SystemRootImpl.getInstance().getRefByStub(((LogicObject)event.getSourceObject()).getCommKeyClassId());
            this.notifySourceNewAcknowledgeState((GeneralLogicObject)source);
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, (Throwable)re, new Object[0]);
        }
    }

    private Object findDrObjectFromStub(GeneralLogicObject sourceObject) throws RemoteException {
        ArrayList list = DRRootImpl.getInstance().getDRObjects();
        for (int i = 0; i < list.size(); ++i) {
            if (!((DRLogicObject)list.get(i)).hashKey().equals(sourceObject.hashKey())) continue;
            return list.get(i);
        }
        return null;
    }

    public void addAlarmList(AlarmList alarmList) {
        this.list.putAll(alarmList.list);
    }

    public boolean isListEmpty() {
        return this.list.isEmpty();
    }

    class AcknowledeTimerTask
    extends TimerTask {
        private Timer timer;
        private Alarm alarm;

        public AcknowledeTimerTask(Timer timer, Alarm alarm) {
            this.alarm = alarm;
            this.timer = timer;
        }

        @Override
        public void run() {
            try {
                AlarmList.this.unAcknowledgeAlarm(this.alarm);
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.LEGACY, (Throwable)re, new Object[0]);
            }
            this.timer.cancel();
        }
    }
}

