/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm;

import com.sanrad.log.SrLogCategories;
import com.sanrad.nms.server.RemoteObjectImpl;
import com.sanrad.nms.server.alarm.AlarmHistoryFileMgr;
import com.sanrad.nms.server.alarm.AlarmHistoryIterator;
import com.sanrad.nms.server.alarm.HistoryAlarmImpl;
import com.sanrad.nms.server.logic.ClientParameterCode;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class AlarmHistoryIteratorImpl
extends RemoteObjectImpl
implements AlarmHistoryIterator {
    private static final int CACHE_ALARMS_CURSOR = -1;
    private AlarmHistoryFileMgr myAlarmHistoryFileMgr;
    private List<String> myHistoryFileNames;
    private int myMinCursorValue;
    private int myMaxCursorValue;
    private List<HistoryAlarmImpl> myHistoryAlarmsCache;
    private int cursorIndex;

    public AlarmHistoryIteratorImpl(AlarmHistoryFileMgr alarmHistoryFileMgr) throws RemoteException {
        this.myAlarmHistoryFileMgr = alarmHistoryFileMgr;
        this.myHistoryFileNames = this.myAlarmHistoryFileMgr.getFileNames();
        Collections.sort(this.myHistoryFileNames, new FileNameComparator());
        this.myHistoryAlarmsCache = this.myAlarmHistoryFileMgr.getCachedHistoryList();
        this.myMinCursorValue = this.myHistoryAlarmsCache.isEmpty() && this.myHistoryFileNames.isEmpty() ? -1 : (this.myHistoryAlarmsCache.isEmpty() ? 0 : -1);
        this.myMaxCursorValue = this.myHistoryFileNames.size() - 1;
        this.cursorIndex = this.myMinCursorValue - 1;
    }

    @Override
    public boolean hasNext() throws RemoteException {
        return this.cursorIndex < this.myMaxCursorValue;
    }

    @Override
    public boolean hasPrevious() throws RemoteException {
        return this.cursorIndex > this.myMinCursorValue;
    }

    @Override
    public List<HashMap<ClientParameterCode, Object>> next() throws RemoteException {
        if (!this.hasNext()) {
            return null;
        }
        ++this.cursorIndex;
        theLogger.info(SrLogCategories.HISTORY_ALARMS, new Object[]{"cursor index is: ", this.cursorIndex});
        theLogger.info(SrLogCategories.HISTORY_ALARMS, new Object[]{"The current object is: ", this});
        return this.getHistoryAlarms(this.cursorIndex);
    }

    @Override
    public List<HashMap<ClientParameterCode, Object>> previous() throws RemoteException {
        if (!this.hasPrevious()) {
            return null;
        }
        --this.cursorIndex;
        return this.getHistoryAlarms(this.cursorIndex);
    }

    private List<HashMap<ClientParameterCode, Object>> getHistoryAlarms(int index) throws RemoteException {
        if (index < this.myMinCursorValue || index > this.myMaxCursorValue) {
            throw new IllegalArgumentException("The index " + index + " is out of bounds, min - " + this.myMinCursorValue + ", max - " + this.myMaxCursorValue);
        }
        if (index < 0) {
            return this.getHashMapToClient(this.myHistoryAlarmsCache);
        }
        String fileName = this.myHistoryFileNames.get(index);
        List<HistoryAlarmImpl> alarms = this.myAlarmHistoryFileMgr.getAlarmsFromFile(fileName);
        return this.getHashMapToClient(alarms);
    }

    private List<HashMap<ClientParameterCode, Object>> getHashMapToClient(List<HistoryAlarmImpl> aLoadedHistoryList) throws RemoteException {
        ArrayList<HashMap<ClientParameterCode, Object>> retList = new ArrayList<HashMap<ClientParameterCode, Object>>();
        if (aLoadedHistoryList != null) {
            for (HistoryAlarmImpl curAlarm : aLoadedHistoryList) {
                retList.add(curAlarm.toClientHashMap());
            }
        }
        return retList;
    }

    private static class FileNameComparator
    implements Comparator<String> {
        private static final String HISTORY_PRE_POST_FIX_REGEX;

        private FileNameComparator() {
        }

        @Override
        public int compare(String file1, String file2) {
            int index1 = Integer.valueOf(this.removeExtraChars(file1));
            int index2 = Integer.valueOf(this.removeExtraChars(file2));
            return index2 - index1;
        }

        private String removeExtraChars(String aFileName) {
            String retVal = aFileName.replaceAll("alarms", "");
            retVal = retVal.replaceAll("\\.history\\.xml", "");
            retVal = retVal.replaceAll("\\.history", "");
            return retVal;
        }

        static {
            StringBuilder regexSb = new StringBuilder();
            regexSb.append("alarms");
            regexSb.append("|\\");
            regexSb.append(".history");
            regexSb.append("\\.xml");
            HISTORY_PRE_POST_FIX_REGEX = regexSb.toString();
        }
    }
}

