/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;

public class ServerPropertiesFetcher {
    public static final String SERVER_PROPERTIES_FILE_NAME = "server.properties";
    private static String DEFAULT_PROPERTIES_FILE_DIR = "./";
    public static final String RMI_REGISTRY_PORT_PROPERTY = "rmiRegPort";
    public static final String STORAGE_MGR_DIR_PROPERTY = "StorageManager.WinDir";
    public static final String STORAGE_MGR_CLI_APPLICATION_NAME_PROPERTY = "StorageManager.CliFile";
    public static final String HISTORY_ALARMS_ENABLE = "historyAlarmsEnable";
    private static Boolean myHistoryAlarmsEnableCache = null;
    public static final String REMOVE_TARGET_ENABLE = "removeTargetEnable";
    private static Boolean myRemoveTargetEnableCache = null;
    public static final String LOGIC_UPDATE_FUTURE_ENABLE = "logicUpdateFutureEnable";
    private static Boolean myLogicUpdateFutureEnableCache = null;
    public static final String HOSTNAME_PROPERTY = "hostname";
    private static final String TRUE_PROPERTY_VALUE = "true";
    private static final String STORAGE_DISCOVERY_POLL_INTERVAL_PROPERTY = "waitForStorDiscoveryPollInterval";
    private static final String STORAGE_DISCOVERY_POLL_COUNT_PROPERTY = "waitForStorDiscoveryPollCount";
    private static final String STORAGE_DISCOVERY_POLL_INTERVAL_DEFAULT_VALUE = "5000";
    private static final String STORAGE_DISCOVERY_POLL_COUNT_DEFAULT_VALUE = "3";
    private static final String RAID_REGISTRATION_RETRIES_COUNT_PROPERTY = "raidRegistrationRetriesCount";
    private static final String RAID_REGISTRATION_RETRIES_COUNT_DEFAULT_VALUE = "3";
    private static final String MAX_SNAPSHOTS_PER_VOLUME_PROPERTY = "maxSnapshotsPerVolume";
    private static final String MAX_SNAPSHOTS_PER_VOLUME_DEFAULT_VALUE = "7";

    private ServerPropertiesFetcher() {
    }

    @Deprecated
    public static void setDefaultPropertiesFileDir(String inDir) {
        DEFAULT_PROPERTIES_FILE_DIR = inDir;
    }

    @Deprecated
    public static String getHost() {
        String host = ServerPropertiesFetcher.getHostname();
        if (host == null || host.trim().equals("")) {
            host = ServerPropertiesFetcher.getHostAddress();
        }
        return host;
    }

    public static String getHostname() {
        return ServerPropertiesFetcher.getServerPropertyValue(HOSTNAME_PROPERTY, "localhost", DEFAULT_PROPERTIES_FILE_DIR);
    }

    private static String getPropertiesFileFullName(String inPropertiesFileDir) {
        if (!inPropertiesFileDir.endsWith("/")) {
            inPropertiesFileDir = inPropertiesFileDir + "/";
        }
        return inPropertiesFileDir + SERVER_PROPERTIES_FILE_NAME;
    }

    public static String getServerPropertyValue(String inPropertyName) {
        return ServerPropertiesFetcher.getServerPropertyValue(inPropertyName, null, DEFAULT_PROPERTIES_FILE_DIR);
    }

    private static String getServerPropertyValue(String inPropertyName, String defaultValue) {
        return ServerPropertiesFetcher.getServerPropertyValue(inPropertyName, defaultValue, DEFAULT_PROPERTIES_FILE_DIR);
    }

    private static String getServerPropertyValue(String inPropertyName, String defaultValue, String inPropertiesFileDir) {
        String propertyValue = null;
        try {
            Properties serverData = new Properties();
            String propertiesFileFullName = ServerPropertiesFetcher.getPropertiesFileFullName(inPropertiesFileDir);
            serverData.load(new FileInputStream(propertiesFileFullName));
            propertyValue = serverData.getProperty(inPropertyName, defaultValue);
        }
        catch (IOException e) {
            propertyValue = defaultValue;
            SrLogger.getLogger().error(SrLogCategories.EXCEPTION, (Throwable)e, new Object[0]);
        }
        return propertyValue;
    }

    public static String getRMIRegistryPort() {
        return ServerPropertiesFetcher.getServerPropertyValue(RMI_REGISTRY_PORT_PROPERTY, "1099", DEFAULT_PROPERTIES_FILE_DIR);
    }

    public static boolean isHistoryAlarmsEnabled() {
        if (myHistoryAlarmsEnableCache == null) {
            myHistoryAlarmsEnableCache = TRUE_PROPERTY_VALUE.equalsIgnoreCase(ServerPropertiesFetcher.getServerPropertyValue(HISTORY_ALARMS_ENABLE, TRUE_PROPERTY_VALUE, DEFAULT_PROPERTIES_FILE_DIR));
        }
        return myHistoryAlarmsEnableCache;
    }

    public static boolean isRemoveTargetEnabled() {
        if (myRemoveTargetEnableCache == null) {
            myRemoveTargetEnableCache = TRUE_PROPERTY_VALUE.equalsIgnoreCase(ServerPropertiesFetcher.getServerPropertyValue(REMOVE_TARGET_ENABLE, TRUE_PROPERTY_VALUE, DEFAULT_PROPERTIES_FILE_DIR));
        }
        return myRemoveTargetEnableCache;
    }

    public static boolean isLogicUpdateFutureEnabled() {
        if (myLogicUpdateFutureEnableCache == null) {
            myLogicUpdateFutureEnableCache = TRUE_PROPERTY_VALUE.equalsIgnoreCase(ServerPropertiesFetcher.getServerPropertyValue(LOGIC_UPDATE_FUTURE_ENABLE, null, DEFAULT_PROPERTIES_FILE_DIR));
        }
        return myLogicUpdateFutureEnableCache;
    }

    public static String getRMIRegistryPort(String inPropertiesFileDir) {
        String port = ServerPropertiesFetcher.getServerPropertyValue(RMI_REGISTRY_PORT_PROPERTY, "1099", inPropertiesFileDir);
        if (port == null) {
            return String.valueOf(1099);
        }
        return port;
    }

    public static InetAddress getHostInetAddress() {
        InetAddress[] hostAddressList = ServerPropertiesFetcher.getHostAddressList();
        return hostAddressList[0];
    }

    public static String getHostAddress() {
        return ServerPropertiesFetcher.getHostInetAddress().getHostAddress();
    }

    public static InetAddress[] getHostAddressList() {
        try {
            return InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException uhe) {
            uhe.printStackTrace();
            return null;
        }
    }

    public static String getStorageMgmtApplicationPath() throws FileNotFoundException, IOException {
        return ServerPropertiesFetcher.getServerPropertyValue(STORAGE_MGR_DIR_PROPERTY);
    }

    public static String getStorageMgmtCliApplicationName() throws FileNotFoundException, IOException {
        return ServerPropertiesFetcher.getServerPropertyValue(STORAGE_MGR_CLI_APPLICATION_NAME_PROPERTY);
    }

    public static long getStorageDiscoveryPollInterval() {
        String strValue = ServerPropertiesFetcher.getServerPropertyValue(STORAGE_DISCOVERY_POLL_INTERVAL_PROPERTY, STORAGE_DISCOVERY_POLL_INTERVAL_DEFAULT_VALUE);
        return Long.valueOf(strValue);
    }

    public static long getStorageDiscoveryPollCount() {
        String strValue = ServerPropertiesFetcher.getServerPropertyValue(STORAGE_DISCOVERY_POLL_COUNT_PROPERTY, "3");
        return Long.valueOf(strValue);
    }

    public static int getRaidRegistrationRetriesCount() {
        String strValue = ServerPropertiesFetcher.getServerPropertyValue(RAID_REGISTRATION_RETRIES_COUNT_PROPERTY, "3");
        return Integer.valueOf(strValue);
    }

    public static int getMaxSnapshotPerVolume() {
        String strValue = ServerPropertiesFetcher.getServerPropertyValue(MAX_SNAPSHOTS_PER_VOLUME_PROPERTY, MAX_SNAPSHOTS_PER_VOLUME_DEFAULT_VALUE);
        return Integer.valueOf(strValue);
    }
}

