/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.init;

import com.sun.jnlp.JNLPClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import org.jdesktop.jdic.browser.internal.WebBrowserUtil;
import org.jdesktop.jdic.init.InitUtility;
import org.jdesktop.jdic.init.JNLPClassLoaderAccessor;
import org.jdesktop.jdic.init.JdicInitException;
import org.jdesktop.jdic.init.NativeExtractor;

public class JdicManager {
    private static Class clNativeExtractor = null;
    static String nativeLibPath = null;
    private static boolean initNativeLoader = false;
    private static HashSet loadedLibraries = new HashSet();
    private static boolean initBrowserDLLPath = false;

    private JdicManager() {
    }

    public static String getPlatform() {
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows")) {
            return "windows";
        }
        return JdicManager.canonical(string);
    }

    public static String getPlatformSuffix() {
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows")) {
            return "windows";
        }
        return "unix";
    }

    public static String getArchitecture() {
        String string = System.getProperty("os.arch");
        if (string.endsWith("86")) {
            return "x86";
        }
        return JdicManager.canonical(string);
    }

    private static String canonical(String string) {
        WebBrowserUtil.trace("value:" + string);
        WebBrowserUtil.trace("canonical:" + string.toLowerCase().replaceAll("[\\\\/ ]", "_"));
        return string.toLowerCase().replaceAll("[\\\\/ ]", "_");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init() throws JdicInitException {
        System.err.println("{init");
        try {
            WebBrowserUtil.trace("{Native loader");
            clNativeExtractor = NativeExtractor.class;
            WebBrowserUtil.trace("}Native loader");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Object object;
            String string = System.getProperty("javawebstart.version");
            if (null != string) {
                WebBrowserUtil.trace("Loaded by JavaWebStart,version is " + string);
                if (null != clNativeExtractor) {
                    WebBrowserUtil.trace("plagin-2 in action!");
                } else {
                    object = JdicManager.class.getClassLoader();
                    if (!(object instanceof JNLPClassLoader)) throw new JdicInitException("Unexpected ClassLoader for webstart, only com.sun.jnlp.JNLPClassLoader is supported.");
                    nativeLibPath = new File(JNLPClassLoaderAccessor.findLibrary((JNLPClassLoader)object, "jdic")).getParentFile().getCanonicalPath();
                }
            } else if (null == clNativeExtractor && JdicManager.class.getClassLoader() instanceof URLClassLoader) {
                nativeLibPath = new File(new URL(JdicManager.class.getProtectionDomain().getCodeSource().getLocation(), ".").openConnection().getPermission().getName()).getCanonicalPath() + File.separator + JdicManager.getPlatform() + File.separator + JdicManager.getArchitecture();
            }
            System.err.println("New binary?:" + nativeLibPath);
            if (null != nativeLibPath) {
                object = nativeLibPath + File.pathSeparator + System.getProperty("java.library.path");
                System.err.println("New binary:" + (String)object);
                System.setProperty("java.library.path", (String)object);
                return;
            } else {
                if (null == clNativeExtractor) return;
                nativeLibPath = NativeExtractor.getBinary();
            }
            return;
        }
        catch (JdicInitException jdicInitException) {
            throw jdicInitException;
        }
        catch (Throwable throwable) {
            throw new JdicInitException(throwable);
        }
    }

    public static String getBinaryPath() {
        return nativeLibPath;
    }

    public static void initBrowserNative() throws JdicInitException {
        try {
            boolean bl = JdicManager.getPlatform().equals("windows");
            String string = bl ? "PATH" : "LD_LIBRARY_PATH";
            String string2 = JdicManager.getBinaryPath();
            InitUtility.preAppendEnv(string, string2);
            WebBrowserUtil.trace("JDIC found BIN path=[" + string2 + "]");
            String string3 = WebBrowserUtil.getBrowserPath();
            if (string3 == null) {
                throw new JdicInitException("Can't locate the native browser path!");
            }
            if (WebBrowserUtil.isDefaultBrowserMozilla()) {
                Object object;
                String string4 = InitUtility.getEnv("MOZILLA_FIVE_HOME");
                if (string4 == null) {
                    object = new File(string3);
                    string4 = ((File)object).isDirectory() ? ((File)object).getCanonicalPath() : ((File)object).getCanonicalFile().getParent();
                }
                if (!bl) {
                    InitUtility.preAppendEnv("PATH", string2);
                } else {
                    object = string4 + File.separator + "xpcom.dll";
                    if (!new File((String)object).isFile()) {
                        String string5 = WebBrowserUtil.getMozillaGreHome();
                        if (string5 == null) {
                            throw new JdicInitException("Can't locate the GRE directory of the installed Mozilla binary: " + string4);
                        }
                        string4 = string5;
                    }
                }
                InitUtility.setEnv("MOZILLA_FIVE_HOME", string4);
                InitUtility.preAppendEnv(string, string4);
            }
        }
        catch (Throwable throwable) {
            throw new JdicInitException(throwable);
        }
    }

    public static synchronized void loadLibrary(final String string) throws PrivilegedActionException {
        try {
            if (!initNativeLoader) {
                initNativeLoader = true;
                JdicManager.init();
            }
            if (!loadedLibraries.contains(string)) {
                loadedLibraries.add(string);
                if (null != clNativeExtractor) {
                    NativeExtractor.loadLibruary((String)string);
                } else {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            System.loadLibrary(string);
                            return null;
                        }
                    });
                }
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw privilegedActionException;
        }
        catch (Exception exception) {
            throw new PrivilegedActionException(exception);
        }
    }

    public static synchronized Process exec(final String[] stringArray) throws PrivilegedActionException {
        try {
            if (!initNativeLoader) {
                initNativeLoader = true;
                JdicManager.init();
            }
            if (!initBrowserDLLPath) {
                initBrowserDLLPath = true;
                JdicManager.initBrowserNative();
            }
            if (null != clNativeExtractor) {
                return NativeExtractor.exec((String[])stringArray);
            }
            final Process[] processArray = new Process[]{null};
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    processArray[0] = Runtime.getRuntime().exec(stringArray);
                    return null;
                }
            });
            return processArray[0];
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw privilegedActionException;
        }
        catch (Exception exception) {
            throw new PrivilegedActionException(exception);
        }
    }
}

