/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util.filter;

import com.sanrad.util.filter.SortKeyProvider;
import com.sanrad.util.filter.SrFilterRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SrSortingMap<K, V> {
    private HashMap<K, List<V>> myMap = new HashMap();
    private SortKeyProvider<K, V> mySorter;

    public SrSortingMap() {
    }

    public SrSortingMap(SortKeyProvider<K, V> aSorter) {
        this.mySorter = aSorter;
    }

    private void put(K key, V value) {
        List<V> list = this.myMap.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            this.myMap.put(key, list);
        }
        list.add(value);
    }

    public void putAll(Collection<V> c) {
        if (this.mySorter == null) {
            throw new UnsupportedOperationException("Sorting immpossible, the sorter is null");
        }
        for (V value : c) {
            this.add(value);
        }
    }

    public void add(V value) {
        if (this.mySorter == null) {
            throw new UnsupportedOperationException("Sorting immpossible, the sorter is null");
        }
        this.put(this.mySorter.getSortBy(value), value);
    }

    public Map<K, List<V>> getSortedGroups() {
        return new HashMap<K, List<V>>(this.myMap);
    }

    public static <K, V> Map<K, List<V>> sort(SortKeyProvider<K, V> aSorter, Collection<V> aValues) {
        SrSortingMap<K, V> map = new SrSortingMap<K, V>(aSorter);
        map.putAll(aValues);
        return map.getSortedGroups();
    }

    public Set<K> keySet() {
        return this.myMap.keySet();
    }

    public Collection<List<V>> values() {
        return this.myMap.values();
    }

    public List<V> getGroup(K aKey) {
        ArrayList<V> retList = new ArrayList<V>();
        List<V> tempList = this.myMap.get(aKey);
        if (tempList != null) {
            retList.addAll(tempList);
        }
        return retList;
    }

    public SrSortingMap<K, V> getFilteredMap(SrFilterRule<Map.Entry<K, List<V>>> aFilterRule) {
        SrSortingMap<K, V> retMap = new SrSortingMap<K, V>();
        for (Map.Entry<K, List<V>> entry : this.myMap.entrySet()) {
            if (!aFilterRule.isValid(entry, this)) continue;
            retMap.myMap.put(entry.getKey(), entry.getValue());
        }
        return retMap;
    }

    public List<K> getKeysSorted(Comparator<K> aComparator) {
        ArrayList<K> keys = new ArrayList<K>(this.keySet());
        Collections.sort(keys, aComparator);
        return keys;
    }

    public int size() {
        return this.myMap.size();
    }

    public boolean containsKey(K aKey) {
        return this.myMap.containsKey(aKey);
    }
}

