/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util.filter;

import com.sanrad.util.filter.SrFilterRule;
import com.sanrad.util.filter.SrFilterRuleListener;
import java.util.ArrayList;
import java.util.List;

public abstract class SrFilterDynamicRule<T>
implements SrFilterRule<T> {
    private List<Object> myObjects = new ArrayList<Object>();
    private List<SrFilterRuleListener<T>> myListeners = new ArrayList<SrFilterRuleListener<T>>();

    public boolean addObject(Object aObj) {
        if (!this.myObjects.add(aObj)) {
            return false;
        }
        this.notifyListeners();
        return true;
    }

    public boolean removeObject(Object aObj) {
        if (!this.myObjects.remove(aObj)) {
            return false;
        }
        this.notifyListeners();
        return true;
    }

    public void clearObjects() {
        this.myObjects.clear();
        this.notifyListeners();
    }

    public List<Object> getObjects() {
        return new ArrayList<Object>(this.myObjects);
    }

    public boolean containsObject(Object aObj) {
        return this.myObjects.contains(aObj);
    }

    @Override
    public boolean addListener(SrFilterRuleListener<T> aListener) {
        return this.myListeners.add(aListener);
    }

    @Override
    public boolean removeListener(SrFilterRuleListener<T> aListener) {
        return this.myListeners.remove(aListener);
    }

    private void notifyListeners() {
        for (SrFilterRuleListener<T> listener : this.myListeners) {
            listener.notifyRuleChanged(this);
        }
    }
}

