/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util.concurrent;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.util.concurrent.SrFuture;
import com.sanrad.util.concurrent.SrTaskPriority;
import java.math.BigInteger;

public abstract class SrTask<T>
implements Runnable {
    private static SrLogger theLogger = SrLogger.getLogger();
    private BigInteger myIndex = null;
    private static final SrTaskPriority theDefaultPriority = SrTaskPriority.NORMAL;
    private SrTaskPriority myPriority;
    private SrFuture<T> myCtrlFuture;
    private String myDescription;

    public SrTask(String aDescription, BigInteger aIndex) {
        this(aDescription, theDefaultPriority, aIndex);
    }

    public SrTask(String aDescription, SrTaskPriority aPriority, BigInteger aIndex) {
        this.myPriority = aPriority;
        this.myDescription = aDescription;
        this.myIndex = aIndex;
    }

    public long getExpectedExecutionTime() {
        return this.myCtrlFuture.getExpectedExecutionTime();
    }

    void setFuture(SrFuture<T> aFuture) {
        this.myCtrlFuture = aFuture;
    }

    SrFuture<T> getFuture() {
        return this.myCtrlFuture;
    }

    public SrTaskPriority getPriority() {
        return this.myPriority;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String aDescription) {
        this.myDescription = aDescription;
    }

    @Override
    public final void run() {
        try {
            theLogger.trace(SrLogCategories.INFORMATIVE, new Object[]{"Started task (", this.myCtrlFuture.getID(), "): ", this.getDescription()});
            this.myCtrlFuture.setStartTime();
            this.execute(this.myCtrlFuture);
            theLogger.trace(SrLogCategories.INFORMATIVE, new Object[]{"Finished task (", this.myCtrlFuture.getID(), ")"});
        }
        catch (Throwable th) {
            this.myCtrlFuture.setException(th);
        }
    }

    protected abstract void execute(SrFuture<T> var1) throws Exception;

    BigInteger getMyIndex() {
        return this.myIndex;
    }
}

