/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util.concurrent;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.util.concurrent.FutureListener;
import com.sanrad.util.concurrent.IFuture;
import com.sanrad.util.concurrent.SrExecutionException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class SrFuture<T>
extends FutureTask<T>
implements IFuture<T> {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static final Runnable theDummyTask = new Runnable(){

        @Override
        public void run() {
        }
    };
    private static long theFutureCounter = 0L;
    private List<FutureListener> myListenerList = new ArrayList<FutureListener>();
    private Future myExecutionFuture;
    private long myScheduleTime;
    private long myStartTime;
    private long myEndTime;
    private long myID = this.getNextID();
    private String myDescription;
    private Throwable myCallingThreadTrace;
    private boolean myIsFailed = false;

    public SrFuture(String aDescription) {
        super(theDummyTask, null);
        this.setDescription(aDescription);
        theLogger.trace(SrLogCategories.INFORMATIVE, new Object[]{"Created future (", this.myID, "): ", this.getDescription()});
        this.myCallingThreadTrace = new Throwable("The calling thread trace");
    }

    private synchronized long getNextID() {
        theFutureCounter = theFutureCounter < Long.MAX_VALUE ? ++theFutureCounter : 1L;
        return theFutureCounter;
    }

    void setExecutionFuture(Future aExecutionFuture) {
        this.myExecutionFuture = aExecutionFuture;
    }

    void initSchedulingTimeStamp(long delay) {
        long timestamp;
        theLogger.logAndAssert(SrLogCategories.ERROR, this.myScheduleTime == 0L, new Object[]{"future (" + this.myID + "), SchedulingTimeStamp is already initialized"});
        this.myScheduleTime = timestamp = System.currentTimeMillis() + delay;
    }

    private void setEndTime() {
        theLogger.logAndAssert(SrLogCategories.ERROR, this.myEndTime == 0L, new Object[]{"future (" + this.myID + "), shouldn't be called more then once"});
        this.myEndTime = System.currentTimeMillis();
    }

    @Override
    public long getEndTime() {
        return this.myEndTime;
    }

    @Override
    public long getExpectedExecutionTime() {
        return this.myScheduleTime;
    }

    void setStartTime() {
        theLogger.logAndAssert(SrLogCategories.ERROR, this.myStartTime == 0L, new Object[]{"future (" + this.myID + "), shouldn't be called more then once"});
        this.myStartTime = System.currentTimeMillis();
    }

    @Override
    public long getStartTime() {
        return this.myStartTime;
    }

    @Override
    public String getDescription() {
        return this.myDescription;
    }

    void setDescription(String aDescription) {
        this.myDescription = aDescription;
    }

    long getID() {
        return this.myID;
    }

    @Override
    public boolean cancel(boolean aMayInterruptIfRunning) {
        theLogger.error(SrLogCategories.EXCEPTION, this.myCallingThreadTrace, new Object[]{"Canceling future (" + this.myID + ":" + this.myDescription + "). May interrupt if running: ", aMayInterruptIfRunning});
        this.myExecutionFuture.cancel(aMayInterruptIfRunning);
        return super.cancel(aMayInterruptIfRunning);
    }

    @Override
    public void set(T aValue) {
        super.set(aValue);
    }

    @Override
    public void setException(Throwable aException) {
        theLogger.error(SrLogCategories.EXCEPTION, aException, new Object[]{"Setting exception for future (" + this.myID + "): "});
        theLogger.error(SrLogCategories.EXCEPTION, this.myCallingThreadTrace, new Object[]{"Calling trace: "});
        super.setException(aException);
        this.myIsFailed = true;
    }

    public boolean isFailed() {
        return this.myIsFailed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informFutureDone() {
        ArrayList<FutureListener> clonedList;
        List<FutureListener> list = this.myListenerList;
        synchronized (list) {
            clonedList = new ArrayList<FutureListener>(this.myListenerList);
        }
        Event event = new Event(this);
        for (FutureListener listener : clonedList) {
            try {
                listener.futureDone(event);
            }
            catch (RemoteException e) {
                theLogger.error(SrLogCategories.ERROR, (Throwable)e, new Object[]{"SrFuture (" + this.myID + ") " + this.myDescription + " failed to call FutureListener.futureDone() for " + listener});
            }
        }
        List<FutureListener> list2 = this.myListenerList;
        synchronized (list2) {
            for (FutureListener listener : clonedList) {
                this.myListenerList.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFutureListener(FutureListener aListener) throws RemoteException {
        if (this.isDone()) {
            aListener.futureDone(new Event(this));
            return;
        }
        List<FutureListener> list = this.myListenerList;
        synchronized (list) {
            if (!this.myListenerList.contains(aListener)) {
                this.myListenerList.add(aListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFutureListener(FutureListener aListener) {
        List<FutureListener> list = this.myListenerList;
        synchronized (list) {
            this.myListenerList.remove(aListener);
        }
    }

    @Override
    protected void done() {
        this.setEndTime();
        super.done();
        theLogger.trace(SrLogCategories.INFORMATIVE, new Object[]{"Future is done   (", this.myID, ")"});
        this.informFutureDone();
    }

    public IFuture<T> exportMe() throws RemoteException {
        return (IFuture)((Object)UnicastRemoteObject.exportObject(this));
    }

    @Override
    public T get() throws InterruptedException, SrExecutionException {
        try {
            return (T)super.get();
        }
        catch (ExecutionException e) {
            if (e instanceof SrExecutionException) {
                throw (SrExecutionException)e;
            }
            Throwable cause = e.getCause();
            if (cause instanceof SrExecutionException) {
                throw (SrExecutionException)cause;
            }
            SrExecutionException rethrown = new SrExecutionException(new Throwable[]{cause});
            rethrown.setStackTrace(e.getStackTrace());
            throw rethrown;
        }
    }

    @Override
    public String toString() {
        StringBuilder retStr = new StringBuilder("SrFuture (");
        retStr.append(this.myID).append("); isDone = ").append(this.isDone());
        retStr.append("; hasException = ").append(this.myIsFailed);
        return retStr.toString();
    }

    public String getStackTraceString() {
        return SrLogger.getThrowableOutput((Throwable)this.myCallingThreadTrace);
    }

    public static class Event<V>
    extends EventObject {
        private static final long serialVersionUID = 1L;
        private IFuture<V> myFuture;

        public Event(IFuture<V> aFuture) {
            super(aFuture);
            theLogger.logAndAssert(SrLogCategories.ERROR, aFuture != null, new Object[]{"aFuture argument cannot be null"});
            this.myFuture = aFuture;
        }

        public IFuture<V> getFuture() {
            return this.myFuture;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(1);
            out.writeObject(this.myFuture);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int version = in.readInt();
            if (version != 1) {
                throw new IOException("Unsupported object version");
            }
            this.myFuture = (IFuture)in.readObject();
        }
    }
}

