/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util.concurrent;

import com.sanrad.SrException;
import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public class SrExecutionException
extends ExecutionException {
    private static final long serialVersionUID = 1L;
    private static SrLogger theLogger = SrLogger.getLogger();
    private transient Set<Throwable> myCauses = new HashSet<Throwable>();
    private String myMessage;
    private boolean myIsContainsNonSrException;

    public SrExecutionException(Collection<Throwable> aCauses) {
        this.init(aCauses);
    }

    private void init(Collection<Throwable> aCauses) {
        theLogger.logAndAssert(SrLogCategories.ERROR, aCauses != null && !aCauses.isEmpty(), new Object[]{"Set<Throwable> parameter cannot be null or empty"});
        this.myCauses.addAll(aCauses);
        this.myIsContainsNonSrException = false;
        for (Throwable cause : aCauses) {
            boolean isRecursiveContainsNonSrException;
            if (cause instanceof RemoteException) {
                this.myCauses = Collections.singleton(cause);
                break;
            }
            while (cause instanceof ExecutionException && !(cause instanceof SrExecutionException)) {
                cause = cause.getCause();
            }
            boolean isNotSrException = !(cause instanceof SrException);
            boolean isSrExecutionException = cause instanceof SrExecutionException;
            boolean isNotRelevant = isNotSrException && !isSrExecutionException;
            boolean bl = isRecursiveContainsNonSrException = isSrExecutionException && ((SrExecutionException)cause).containsNonSrException();
            if (!isNotRelevant && !isRecursiveContainsNonSrException) continue;
            this.myIsContainsNonSrException = true;
        }
        this.myMessage = this.getMessage();
    }

    public SrExecutionException(Throwable ... aCauses) {
        this(Arrays.asList(aCauses));
    }

    public SrExecutionException(String message, Collection<Throwable> aCauses) {
        super(message);
        this.init(aCauses);
    }

    public SrExecutionException(String message, Throwable ... aCauses) {
        this(message, Arrays.asList(aCauses));
    }

    @Override
    @Deprecated
    public Throwable getCause() {
        theLogger.warn(SrLogCategories.INFORMATIVE, new Object[]{"This method should not be called, the getCauses() - the plural form - should be used instead."});
        return super.getCause();
    }

    public Set<Throwable> getCauses() {
        if (this.myCauses == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(this.myCauses);
    }

    @Override
    public String getMessage() {
        if (this.myCauses == null) {
            return this.myMessage;
        }
        StringBuffer sb = new StringBuffer();
        String sMsg = super.getMessage();
        if (sMsg != null) {
            sb.append(sMsg);
        }
        for (Throwable th : this.myCauses) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(th.getMessage());
        }
        return sb.toString();
    }

    @Override
    public void printStackTrace(PrintStream s) {
        if (this.myCauses == null) {
            super.printStackTrace(s);
            return;
        }
        this.printStackTrace(new PrintWriter(new OutputStreamWriter(s)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter s) {
        if (this.myCauses == null) {
            super.printStackTrace(s);
            return;
        }
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            s.println(this);
            StackTraceElement[] trace = this.getStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                s.println("\tat " + trace[i]);
            }
            int causeIndex = 0;
            int causesCount = this.myCauses.size();
            s.println("Causes [" + causesCount + "]:");
            for (Throwable thCause : this.myCauses) {
                s.print("Cause " + ++causeIndex + " of " + causesCount + ": ");
                thCause.printStackTrace(s);
            }
        }
    }

    public boolean containsNonSrException() {
        return this.myIsContainsNonSrException;
    }
}

