/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util.concurrent;

import com.sanrad.log.SrLogger;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.IFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class ErrorAssertingListener
extends DefaultFutureListener {
    public static ErrorAssertingListener listenTo(Collection<? extends IFuture<?>> aFuturesToWait) {
        return new ErrorAssertingListener(aFuturesToWait);
    }

    public static ErrorAssertingListener listenTo(IFuture<?> aFutureToWait) {
        ArrayList futList = new ArrayList();
        futList.add(aFutureToWait);
        return new ErrorAssertingListener(futList);
    }

    protected ErrorAssertingListener(Collection<? extends IFuture<?>> aFuturesToWait) {
        super(aFuturesToWait);
    }

    protected ErrorAssertingListener(SrFuture<?> ... aFuturesToWait) {
        super(Arrays.asList(aFuturesToWait));
    }

    @Override
    public void tasksFinished() {
        String assertMsg = "";
        for (IFuture curFuture : this.myFutures) {
            try {
                curFuture.get();
            }
            catch (Throwable exp) {
                assertMsg = assertMsg + "\n" + SrLogger.getThrowableOutput((Throwable)exp);
            }
        }
        assert (assertMsg.equals("")) : "The following exceptions were contained in the given futures: " + assertMsg;
    }
}

