/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util.concurrent;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.util.concurrent.FutureListener;
import com.sanrad.util.concurrent.IFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public abstract class DefaultFutureListener
implements FutureListener {
    private static SrLogger theLogger = SrLogger.getLogger();
    protected Set<IFuture<?>> myFutures = new HashSet();
    private Set<IFuture<?>> myWaitingFutures = new HashSet();

    protected DefaultFutureListener(Collection<? extends IFuture<?>> aFuturesToWait) {
        if (aFuturesToWait.isEmpty()) {
            this.tasksFinished();
        }
        try {
            this.setFutures(aFuturesToWait);
        }
        catch (RemoteException e) {
            theLogger.error(SrLogCategories.EXCEPTION, (Throwable)e, new Object[]{"During the DefaultFutureListener ctor"});
            this.tasksFinished();
        }
    }

    public static void listenTo(Runnable aRunnable, IFuture<?> ... aFuturesToWait) {
        DefaultFutureListener.listenTo(aRunnable, Arrays.asList(aFuturesToWait));
    }

    public static void listenTo(final Runnable aRunnable, Collection<? extends IFuture<?>> aFuturesToWait) {
        new DefaultFutureListener(aFuturesToWait){

            @Override
            public void tasksFinished() {
                aRunnable.run();
            }
        };
    }

    private void setFutures(Collection<? extends IFuture<?>> aFuturesToWait) throws RemoteException {
        theLogger.logAndAssert(SrLogCategories.ERROR, this.myFutures.isEmpty(), new Object[]{"The listener is already initialized"});
        for (IFuture<?> future : aFuturesToWait) {
            this.myFutures.add(future);
            this.myWaitingFutures.add(future);
        }
        FutureListener stub = (FutureListener)((Object)UnicastRemoteObject.exportObject(this));
        for (IFuture<?> future : aFuturesToWait) {
            future.addFutureListener(this);
        }
    }

    @Override
    public void futureDone(SrFuture.Event<?> aFutureEvent) {
        theLogger.logAndAssert(SrLogCategories.ERROR, aFutureEvent != null, new Object[]{"aFutureEvent argument cannot be null"});
        IFuture<?> future = aFutureEvent.getFuture();
        String description = "";
        try {
            description = future.getDescription();
        }
        catch (RemoteException e) {
            theLogger.error(SrLogCategories.EXCEPTION, (Throwable)e, new Object[]{"During DefaultFutureListener.futureDone()"});
        }
        theLogger.logAndAssert(SrLogCategories.ERROR, this.myFutures.contains(future), new Object[]{"The future " + description + " must be known by this listener. Know listeners are: " + this.myFutures});
        this.myWaitingFutures.remove(future);
        if (this.myWaitingFutures.isEmpty()) {
            this.tasksFinished();
        }
    }

    public abstract void tasksFinished();
}

