/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.SrSubstanceAquaTheme;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.rmi.Remote;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.theme.SubstanceMixTheme;
import org.jvnet.substance.theme.SubstanceTheme;

public class Util {
    private static final String URL_NOT_FOUND_ERR_MSG = "Failed to find url of ";
    private static final double JDK_1_1_VERSION = 45.3;
    private static final double JDK_1_2_VERSION = 46.0;
    private static final double JDK_1_3_VERSION = 47.0;
    private static final double JDK_1_4_VERSION = 48.0;
    private static final double JDK_1_5_VERSION = 49.0;
    private static final String CVS_DIR_NAME = "CVS/";
    private static final String CVS_TAG_FILE_NAME = "Tag";
    private static final String CVS_DEFAULT_TAG = "MAIN";
    private static final String LOGGER_NULL_MSG = "The given logger should not be null.";
    public static final String REMOTE_STUB_ADDRESS_START_STRING = "[endpoint:[";
    public static final String REMOTE_STUB_ADDRESS_END_STRING = "](remote)";
    public static final int BYTES_IN_MB = (int)Math.pow(2.0, 20.0);
    public static final long BYTES_IN_GB = (long)((double)BYTES_IN_MB * Math.pow(2.0, 10.0));
    public static final long BYTES_IN_TB = (long)((double)BYTES_IN_GB * Math.pow(2.0, 10.0));

    public URL getURL(String filename, SrLogger aLogger) {
        URLClassLoader cl = (URLClassLoader)this.getClass().getClassLoader();
        URL url = cl.findResource(filename);
        if (url == null) {
            if (aLogger != null) {
                aLogger.error(SrLogCategories.ERROR, new Object[]{URL_NOT_FOUND_ERR_MSG, filename});
            } else {
                System.err.println(URL_NOT_FOUND_ERR_MSG + filename);
            }
        }
        return url;
    }

    public URL getURL(String filename) {
        return this.getURL(filename, null);
    }

    public ImageIcon loadImage(String imagename) {
        URL url = this.getURL(imagename);
        if (url == null) {
            return null;
        }
        return new ImageIcon(url);
    }

    public static String getFileTextualContent(URL url) {
        try {
            StringBuffer buffer = new StringBuffer();
            char[] readBuffer = new char[8];
            InputStreamReader reader = new InputStreamReader(url.openStream());
            int charCount = 0;
            do {
                buffer.append(readBuffer, 0, charCount);
            } while ((charCount = reader.read(readBuffer)) >= 0);
            return buffer.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BigInteger bytesToBlocks(BigInteger size, int blockSize) {
        BigInteger blkSize = new BigInteger(Integer.toString(blockSize));
        return size.divide(blkSize);
    }

    public static BigDecimal bytesToTBs(BigInteger aSize) {
        BigDecimal retVal = new BigDecimal(aSize).divide(new BigDecimal(BYTES_IN_TB));
        return retVal;
    }

    public static BigDecimal bytesToGBs(BigInteger aSize) {
        BigDecimal retVal = new BigDecimal(aSize).divide(new BigDecimal(BYTES_IN_GB));
        return retVal;
    }

    public static BigDecimal bytesToMBs(BigInteger aSize) {
        BigDecimal retVal = new BigDecimal(aSize).divide(new BigDecimal(BYTES_IN_MB));
        return retVal;
    }

    public static String bytesToLargerUnits(BigInteger aSize) {
        double sizeInDouble = aSize.doubleValue();
        if (sizeInDouble >= (double)BYTES_IN_TB) {
            return Util.bytesToTBs(aSize).setScale(2, 4) + " TB";
        }
        if (sizeInDouble >= (double)BYTES_IN_GB) {
            return Util.bytesToGBs(aSize).setScale(2, 4) + " GB";
        }
        return Util.bytesToMBs(aSize).setScale(2, 4) + " MB";
    }

    public static BigInteger blocksToBytes(BigInteger numberOfBlocks, int blockSize) {
        if (numberOfBlocks != null) {
            BigInteger blkSize = new BigInteger(Integer.toString(blockSize));
            return numberOfBlocks.multiply(blkSize);
        }
        return null;
    }

    public static boolean isJavaVersion11Compatible() {
        return 45.3 <= Util.getJVMClassVersion();
    }

    public static boolean isJavaVersion12Compatible() {
        return 46.0 <= Util.getJVMClassVersion();
    }

    public static boolean isJavaVersion13Compatible() {
        return 47.0 <= Util.getJVMClassVersion();
    }

    public static boolean isJavaVersion14Compatible() {
        return 48.0 <= Util.getJVMClassVersion();
    }

    public static boolean isJavaVersion15Compatible() {
        return 49.0 <= Util.getJVMClassVersion();
    }

    public static boolean isJavaVersion14() {
        return 48.0 == Util.getJVMClassVersion();
    }

    public static double getJVMClassVersion() {
        return Double.parseDouble(System.getProperty("java.class.version"));
    }

    public static String getCurrentJavaVersion() {
        return System.getProperty("java.version");
    }

    public static String getCurrentJVMVersion() {
        return System.getProperty("java.vm.version");
    }

    public static int[] getCurrentJVMVersionTokens() {
        return Util.getJVMVersionTokens(Util.getCurrentJavaVersion());
    }

    public static int[] getJVMVersionTokens(String javaVersion) {
        int updateIndex = javaVersion.indexOf("_");
        if (updateIndex > -1) {
            javaVersion = javaVersion.substring(0, updateIndex);
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(javaVersion, ".");
        while (tokens.hasMoreTokens()) {
            list.add(tokens.nextToken());
        }
        int[] array = new int[list.size()];
        int i = 0;
        for (String token : list) {
            try {
                array[i++] = Integer.parseInt(token);
            }
            catch (NumberFormatException nfe) {
                System.err.println("Version " + javaVersion + " is non-GA (non-FCS) release");
                nfe.printStackTrace();
            }
        }
        return array;
    }

    public static int getCurrentJVMVersionUpdateNumber() {
        return Util.getJVMVersionUpdateNumber(Util.getCurrentJavaVersion());
    }

    public static int getJVMVersionUpdateNumber(String javaVersion) {
        int update = 0;
        int updateIndex = javaVersion.indexOf("_");
        if (updateIndex > -1) {
            String updateVersionStr = javaVersion.substring(updateIndex + 1);
            try {
                update = Integer.valueOf(updateVersionStr);
            }
            catch (NumberFormatException nfe) {
                System.err.println("Version " + javaVersion + " is non-GA (non-FCS) release");
                nfe.printStackTrace();
            }
        }
        return update;
    }

    public static String getOSName() {
        return System.getProperty("os.name");
    }

    public static String getOSVersion() {
        return System.getProperty("os.version");
    }

    public static String getLocalDir() {
        return System.getProperty("user.dir");
    }

    public static void initBundleKeys(Class bundleClass, ArrayList keySet) {
        Field[] fields = bundleClass.getFields();
        for (int i = 0; i < fields.length; ++i) {
            BundleKeysInterface object = (BundleKeysInterface)keySet.get(i);
            object.setKey(fields[i].getName());
        }
        keySet.clear();
        keySet = null;
    }

    public static void setLookAndFeel() {
        Util.setLookAndFeel(null, null);
    }

    public static void setLookAndFeel(String aAquaThemeName, String aAquaLightThemeName) {
        Util.setLookAndFeel(null, aAquaThemeName, aAquaLightThemeName);
    }

    public static void setLookAndFeel(SrLogger aLogger, String aAquaThemeName, String aAquaLightThemeName) {
        try {
            if (Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.dllName") != null && Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.resources.strings") == null) {
                System.setProperty("swing.noxp", "true");
            }
        }
        catch (AccessControlException ace) {
            if (aLogger != null) {
                aLogger.trace(SrLogCategories.LEGACY, new Object[]{ace});
            }
            System.err.println(ace);
        }
        try {
            UIManager.setLookAndFeel((LookAndFeel)new SubstanceLookAndFeel());
            UIManager.put("substancelaf.noExtraElements", Boolean.TRUE);
            if (aAquaThemeName != null && aAquaLightThemeName != null) {
                SubstanceTheme[] thems = new SubstanceTheme[]{SrSubstanceAquaTheme.getThemeByName(aAquaThemeName), SrSubstanceAquaTheme.getThemeByName(aAquaThemeName)};
                SubstanceLookAndFeel.setCurrentTheme((SubstanceTheme)new SubstanceMixTheme(thems));
            } else {
                SubstanceTheme[] thems = new SubstanceTheme[]{SrSubstanceAquaTheme.CYAN, SrSubstanceAquaTheme.CYAN_LIGHT};
                SubstanceLookAndFeel.setCurrentTheme((SubstanceTheme)new SubstanceMixTheme(thems));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isNumbersAndDotsSeries(String oid) {
        boolean prevCharWasDot = false;
        int i = oid.length();
        while (i-- > 0) {
            char c = oid.charAt(i);
            if (!Character.isDigit(c) && (c == '.' && prevCharWasDot || c != '.')) {
                return false;
            }
            prevCharWasDot = c == '.';
        }
        return true;
    }

    public static boolean isInteger(String s) {
        if (s == null) {
            return false;
        }
        if (s.isEmpty()) {
            return false;
        }
        if (s.length() > 1 && s.charAt(0) == '0') {
            return false;
        }
        if (s.length() == 1 && s.charAt(0) == '-') {
            return false;
        }
        boolean firstChar = true;
        for (char c : s.toCharArray()) {
            if (!(firstChar && c == '-' || Character.isDigit(c))) {
                return false;
            }
            firstChar = false;
        }
        return true;
    }

    public static boolean isUnsignedInt(String s) {
        return Util.isInteger(s) && s.charAt(0) != '-';
    }

    public static long[] stringToLongArray(String oid) {
        StringTokenizer tokens = new StringTokenizer(oid, ".");
        long[] comps = new long[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            comps[i++] = Long.parseLong(tokens.nextToken());
        }
        return comps;
    }

    public static String longArrayToString(long[] array) {
        if (array == null) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < array.length - 1; ++i) {
            buff.append(array[i]).append('.');
        }
        buff.append(array[array.length - 1]);
        return buff.toString();
    }

    public static boolean isElementInArray(Object[] array, Object obj) {
        if (obj != null && array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (!obj.equals(array[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static String toHexStringFormat(byte[] aBytes, String aDelimiter) {
        StringBuilder sb = new StringBuilder(aBytes.length);
        for (int i = 0; i < aBytes.length; ++i) {
            String hex = Integer.toHexString(aBytes[i] < 0 ? aBytes[i] + 256 : aBytes[i]);
            sb.append(hex.length() < 2 ? "0" : "").append(hex).append(aDelimiter);
        }
        String ret = null;
        ret = sb.length() > 0 ? sb.substring(0, sb.length() - aDelimiter.length()) : sb.toString();
        ret = ret.toUpperCase();
        return ret;
    }

    public static String getCVSTagVersionString() {
        String cvsTag = Util.getCVSTag();
        return cvsTag == null ? "unkown" : "CVS tag: " + Util.getCVSTag();
    }

    private static String getCVSTag() {
        String tag = null;
        String cvsDirPath = CVS_DIR_NAME;
        File cvsDir = new File(cvsDirPath);
        if (cvsDir.isDirectory()) {
            tag = CVS_DEFAULT_TAG;
            String cvsTagPath = cvsDirPath + CVS_TAG_FILE_NAME;
            File cvsTag = new File(cvsTagPath);
            if (cvsTag.isFile()) {
                try {
                    FileInputStream fis = new FileInputStream(cvsTag);
                    BufferedInputStream bis = new BufferedInputStream(fis);
                    InputStreamReader isr = new InputStreamReader(bis);
                    BufferedReader br = new BufferedReader(isr);
                    String line = br.readLine();
                    if (line != null) {
                        tag = line.substring(1);
                    }
                }
                catch (FileNotFoundException e) {
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            System.err.println("Version control directory not found in " + Util.getLocalDir());
        }
        return tag;
    }

    public static String getLocale() {
        Locale locale = Locale.getDefault();
        return locale.toString();
    }

    public static synchronized void printHashMap(Map map, int indentationLevel, PrintStream out) {
        StringBuffer indentation = new StringBuffer();
        int i = indentationLevel;
        while (i-- > 0) {
            indentation.append('\t');
        }
        if (map.isEmpty()) {
            System.out.println(indentation.toString() + "empty HashMap");
        }
        for (Object key : map.keySet()) {
            System.out.print(indentation.toString() + key + "=");
            Object value = map.get(key);
            if (value instanceof HashMap) {
                System.out.println();
                Util.printHashMap((HashMap)value, indentationLevel + 1, out);
                continue;
            }
            out.println(value);
        }
    }

    public static synchronized String getMapAsString(Map map, int indentationLevel, StringBuffer sb) {
        StringBuffer indentation = new StringBuffer();
        int i = indentationLevel;
        while (i-- > 0) {
            indentation.append('\t');
        }
        if (map.isEmpty()) {
            sb.append(indentation).append("empty Map");
            sb.append(SrLogger.LINE_SEPARATOR);
        }
        for (Object key : map.keySet()) {
            sb.append(indentation).append(key).append('=');
            Object value = map.get(key);
            if (value instanceof Map) {
                sb.append(SrLogger.LINE_SEPARATOR);
                Util.getMapAsString((Map)value, indentationLevel + 1, sb);
                continue;
            }
            sb.append(value);
            sb.append(SrLogger.LINE_SEPARATOR);
        }
        return sb.toString();
    }

    public static synchronized String getListAsString(List list) {
        if (list != null) {
            StringBuffer sb = new StringBuffer();
            sb.append('{');
            Iterator i = list.iterator();
            while (i.hasNext()) {
                sb.append('[');
                sb.append(i.next());
                sb.append(']');
                sb.append(',');
            }
            if (!list.isEmpty()) {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append('}');
            return sb.toString();
        }
        return "null";
    }

    public static String getListAsString(List aList, String aDelimiter, String aPrefix, String aPostfix) {
        if (aList == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        if (aPrefix != null) {
            sb.append(aPrefix);
        }
        for (Object element : aList) {
            sb.append(element).append(aDelimiter);
        }
        sb.delete(sb.length() - aDelimiter.length(), sb.length());
        if (aPostfix != null) {
            sb.append(aPostfix);
        }
        return sb.toString();
    }

    public static <T> String getArrayAsString(T[] aArray, String aDelimiter, String aPrefix, String aPostfix) {
        if (aArray == null) {
            return "null";
        }
        return Util.getListAsString(Arrays.asList(aArray), aDelimiter, aPrefix, aPostfix);
    }

    public static void openURL(String url) throws Exception {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Mac OS")) {
            Class<?> macUtils = Class.forName("com.apple.mrj.MRJFileUtils");
            Method openURL = macUtils.getDeclaredMethod("openURL", String.class);
            openURL.invoke(null, url);
        } else if (osName.startsWith("Windows")) {
            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
        } else {
            String[] browsers = new String[]{"firefox", "opera", "konqueror", "mozilla", "netscape"};
            String browser = null;
            for (int count = 0; count < browsers.length && browser == null; ++count) {
                if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                browser = browsers[count];
            }
            if (browser == null) {
                throw new Exception("Could not find web browser.");
            }
            Runtime.getRuntime().exec(new String[]{browser, url});
        }
    }

    public static boolean lockApplicationInstanceIfNotActive(String filaname) {
        FileChannel channel = null;
        FileLock lock = null;
        File file = new File(System.getProperty("user.dir"), filaname);
        file.deleteOnExit();
        try {
            channel = new RandomAccessFile(file, "rw").getChannel();
            lock = channel.tryLock();
        }
        catch (OverlappingFileLockException ofe) {
            Util.closeLock(lock, channel);
            return true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return true;
        }
        if (lock == null) {
            Util.closeLock(lock, channel);
            return true;
        }
        return false;
    }

    private static void closeLock(FileLock lock, FileChannel channel) {
        if (lock != null) {
            try {
                lock.release();
                lock = null;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        if (channel != null) {
            try {
                channel.close();
                channel = null;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public static Double round(Double aDouble, int digitsAfterDecimalPoint) {
        if (aDouble == null) {
            throw new NullPointerException("Null double parameter");
        }
        if (digitsAfterDecimalPoint < 0) {
            throw new IllegalArgumentException("Negative number of digits after the decimal point");
        }
        double multiplier = Math.pow(10.0, digitsAfterDecimalPoint);
        double multiplyDouble = aDouble * multiplier;
        double roundedMultiplyDouble = Math.round(multiplyDouble);
        double roundedDouble = roundedMultiplyDouble / multiplier;
        return new Double(roundedDouble);
    }

    public static boolean equalsWithNull(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public static boolean equals(Object obj1, Object obj2) {
        return obj1 != null ? obj1.equals(obj2) : false;
    }

    public static boolean equalsListNotOrdered(List<? extends Object> aL1, List<? extends Object> aL2) {
        return aL2.containsAll(aL1) && aL1.containsAll(aL2);
    }

    public static <K, V> Map<K, V> createConcatinatedMap(Map<K, V> aMap1, Map<? extends K, ? extends V> aMap2) {
        HashMap<? extends K, ? extends V> retVal = new HashMap<K, V>(aMap1);
        retVal.putAll(aMap2);
        return retVal;
    }

    public static <T> void ensureCapacityAndAdd(List<T> aList, int aPosition, T aElement) {
        int requestedSize = aPosition;
        for (int i = aList.size(); i < requestedSize; ++i) {
            aList.add(null);
        }
        aList.add(aPosition, aElement);
    }

    public static String getStubIpAndPort(Remote aStub) {
        if (aStub == null) {
            throw new IllegalArgumentException("The given stub should not be null");
        }
        int start = aStub.toString().indexOf(REMOTE_STUB_ADDRESS_START_STRING) + REMOTE_STUB_ADDRESS_START_STRING.length();
        int end = aStub.toString().indexOf(REMOTE_STUB_ADDRESS_END_STRING);
        if (end >= 0) {
            return aStub.toString().substring(start, end);
        }
        throw new IllegalStateException("The given stub has an unexpected string representation. We expect ...[endpoint:[IP:Port](remote)... but the actual string representation is: " + aStub.toString());
    }

    public static int getStubPort(Remote aStub) {
        if (aStub == null) {
            throw new IllegalArgumentException("The given stub should not be null");
        }
        String[] parts = Util.getSplitAddress(aStub);
        return Integer.parseInt(parts[1]);
    }

    public static String getStubIP(Remote aStub) {
        if (aStub == null) {
            throw new IllegalArgumentException("The given stub should not be null");
        }
        String[] parts = Util.getSplitAddress(aStub);
        return parts[0];
    }

    private static String[] getSplitAddress(Remote aStub) {
        if (aStub == null) {
            throw new IllegalArgumentException("The given stub should not be null");
        }
        String address = Util.getStubIpAndPort(aStub);
        String[] parts = address.split(":");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Could not get a proper address for the given argument.");
        }
        return parts;
    }

    public static void saveProperties(Properties aPropertiesToSave, String aFileName) throws IOException {
        if (aFileName == null || aPropertiesToSave == null) {
            throw new IllegalArgumentException("Parameters should not be null: propertiesToSave=" + aPropertiesToSave + "; fileName=" + aFileName);
        }
        FileOutputStream outFile = new FileOutputStream(aFileName);
        aPropertiesToSave.store(outFile, null);
        outFile.flush();
        outFile.close();
    }

    public static Properties loadProperties(String aFileName) throws IOException {
        if (aFileName == null) {
            throw new IllegalArgumentException("Parameter should not be null: fileName=" + aFileName);
        }
        Properties properties = new Properties();
        FileInputStream inFile = new FileInputStream(aFileName);
        properties.load(inFile);
        return properties;
    }

    public static <A, B> List<B> convertListType(List<A> aList) {
        ArrayList<A> retList = new ArrayList<A>();
        for (A object : aList) {
            retList.add(object);
        }
        return retList;
    }

    public static <A> List<A> convertToList(A ... aArray) {
        if (aArray == null) {
            return null;
        }
        ArrayList<A> list = new ArrayList<A>();
        for (A element : aArray) {
            if (element == null) continue;
            list.add(element);
        }
        return list;
    }

    public static boolean isSameTypeArray(Object[] aArray, Class<? extends Object> aClass) {
        if (aArray == null) {
            throw new IllegalArgumentException("Array in not specified");
        }
        if (aClass == null) {
            throw new IllegalArgumentException("No Class is specified");
        }
        for (Object obj : aArray) {
            if (aClass.isAssignableFrom(obj.getClass())) continue;
            return false;
        }
        return true;
    }

    public static boolean isSameTypeArray(Object[] aArray) {
        if (aArray == null) {
            throw new IllegalArgumentException("Array in not specified");
        }
        if (aArray.length == 0) {
            return true;
        }
        Class<?> arrayClass = aArray[0].getClass();
        for (Object obj : aArray) {
            if (arrayClass.equals(obj.getClass())) continue;
            return false;
        }
        return true;
    }

    public static void validateInputNotNull(Object aInput, String aInputDesc) {
        if (aInput == null) {
            throw new IllegalArgumentException(aInputDesc + " cannot be null");
        }
    }

    public static String replaceInvalidCharacters(String aAlias, String aInvalidCharsRegex) {
        Util.validateInputNotNull(aAlias, "Alias");
        Util.validateInputNotNull(aInvalidCharsRegex, "REGEX");
        String adaptedVolumeAlias = aAlias.replaceAll(aInvalidCharsRegex, ".");
        return adaptedVolumeAlias;
    }
}

