/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util;

import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.Util;
import java.awt.Color;
import java.awt.Font;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.StringTokenizer;

public class SrResourceBundle {
    private static final HashMap m_instanceMap = new HashMap();
    private static final String BUNDLE_PREFIX_PATH = "resources/";
    private static final String UNDERSCORE = "_";
    private static final String BUNDLE_FILE_SUFFIX = ".properties";
    public static final String DEFAULT_CLIENT_BUNDLE_NAME = "product_client";
    public static final String DEFAULT_SERVER_BUNDLE_NAME = "product_server";
    public static final String DEFAULT_VENDOR_SERVER_BUNDLE_NAME;
    public static final String DEFAULT_UI_BUNDLE_NAME;
    public static final String IMAGES_BUNDLE_NAME;
    public static final String CONSTANTS_BUNDLE_NAME = "constants";
    public static final String CLIENT_DATA_VALIDATION_BUNDLE_NAME = "client_data_validation";
    public static final String LOCALE_LANGUAGE;
    public static final String LOCALE_COUNTRY;
    public static final String COMPONENT_NAMES_BUNDLE = "component_names";
    private PropertyResourceBundle m_bundle;
    private SimpleDateFormat m_dateFromat;
    private GregorianCalendar m_calendar = new GregorianCalendar();
    private URL bundleURL;

    private SrResourceBundle(String bundleName, Locale loc) {
        this.m_dateFromat = new SimpleDateFormat("yy", loc);
        Util util = new Util();
        try {
            this.bundleURL = util.getURL(BUNDLE_PREFIX_PATH + bundleName + UNDERSCORE + loc.toString() + BUNDLE_FILE_SUFFIX);
            if (this.bundleURL == null) {
                this.bundleURL = util.getURL(BUNDLE_PREFIX_PATH + bundleName + BUNDLE_FILE_SUFFIX);
            }
            InputStream is = this.bundleURL.openStream();
            this.m_bundle = new PropertyResourceBundle(is);
        }
        catch (Exception e1) {
            this.m_bundle = null;
        }
    }

    public static SrResourceBundle getInstance(String bundleName, Locale loc) {
        SrResourceBundle instance = null;
        if (!m_instanceMap.containsKey(bundleName + loc)) {
            instance = new SrResourceBundle(bundleName, loc);
            m_instanceMap.put(bundleName + loc, instance);
        } else {
            instance = (SrResourceBundle)m_instanceMap.get(bundleName + loc);
        }
        return instance;
    }

    public static SrResourceBundle getInstance(String bundleName) {
        Locale loc = new Locale(LOCALE_LANGUAGE, LOCALE_COUNTRY);
        return SrResourceBundle.getInstance(bundleName, loc);
    }

    public String getString(BundleKeysInterface key) {
        try {
            return this.m_bundle.getString(key.getKey());
        }
        catch (MissingResourceException mre) {
            if (key.isMandatory()) {
                System.err.println(mre.getMessage() + " (Bundle URL is " + this.bundleURL + ")");
            }
            return null;
        }
    }

    public String getString(BundleKeysInterface key, Object ... args) {
        String pattern = this.m_bundle.getString(key.getKey());
        return MessageFormat.format(pattern, args);
    }

    public String getString(BundleKeysInterface key, String ... args) {
        String pattern = this.m_bundle.getString(key.getKey());
        return MessageFormat.format(pattern, args);
    }

    public String getDateFormatString(BundleKeysInterface key, Date date) {
        this.m_dateFromat.applyPattern(this.getString(key));
        return this.m_dateFromat.format(date);
    }

    public String getDateFormatString(BundleKeysInterface key, long timeMillis) {
        this.m_calendar.setTimeInMillis(timeMillis);
        this.m_dateFromat.applyPattern(this.getString(key));
        return this.m_dateFromat.format(this.m_calendar.getTime());
    }

    public Color getColorResource(BundleKeysInterface key) {
        String colorStr = this.getString(key);
        try {
            return new Color(Integer.parseInt(colorStr));
        }
        catch (NumberFormatException e) {
            try {
                StringTokenizer st = new StringTokenizer(colorStr, ",");
                int tokensCount = st.countTokens();
                if (tokensCount != 3 && tokensCount != 4) {
                    return null;
                }
                int[] rgb = new int[tokensCount];
                for (int i = 0; i < rgb.length; ++i) {
                    rgb[i] = Integer.parseInt(st.nextToken().trim());
                }
                if (rgb.length == 3) {
                    return new Color(rgb[0], rgb[1], rgb[2]);
                }
                if (rgb.length == 4) {
                    return new Color(rgb[0], rgb[1], rgb[2], rgb[3]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return null;
        }
    }

    public Font getFontResource(BundleKeysInterface key) {
        return Font.decode(this.getString(key));
    }

    public int getIntResource(BundleKeysInterface key) {
        return Integer.parseInt(this.getString(key));
    }

    public String[] getArrayResource(BundleKeysInterface key) {
        String str = this.getString(key);
        StringTokenizer tokens = new StringTokenizer(str, ",");
        String[] ret = new String[tokens.countTokens()];
        for (int i = 0; i < ret.length && tokens.hasMoreTokens(); ++i) {
            ret[i] = tokens.nextToken().trim();
        }
        return ret;
    }

    static {
        String vendorDir = SrResourceBundle.getInstance(CONSTANTS_BUNDLE_NAME, Locale.US).getString(SrConstantsBundleKeys.VENDOR_DIR_NAME);
        DEFAULT_UI_BUNDLE_NAME = vendorDir + "/defaultUI";
        DEFAULT_VENDOR_SERVER_BUNDLE_NAME = vendorDir + "/" + DEFAULT_SERVER_BUNDLE_NAME;
        IMAGES_BUNDLE_NAME = vendorDir + "/images";
        LOCALE_LANGUAGE = SrResourceBundle.getInstance(CONSTANTS_BUNDLE_NAME, Locale.US).getString(SrConstantsBundleKeys.LOCALE_LANGUAGE);
        LOCALE_COUNTRY = SrResourceBundle.getInstance(CONSTANTS_BUNDLE_NAME, Locale.US).getString(SrConstantsBundleKeys.LOCALE_COUNTRY);
    }
}

