/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util;

import java.util.Vector;

public class Queue<T> {
    protected Vector<T> queue;

    public Queue() {
        this.queue = new Vector();
    }

    public Queue(int initialCapacity) {
        this.queue = new Vector(initialCapacity);
    }

    public synchronized void addElement(T value) {
        this.queue.addElement(value);
        this.notifyAll();
    }

    public synchronized void addElementToHead(T value) {
        this.insertElementAt(value, 0);
    }

    public synchronized void clear() {
        this.queue.clear();
        this.notifyAll();
    }

    public synchronized void clearNoNotify() {
        this.queue.clear();
    }

    public synchronized void insertElementAt(T value, int index) {
        this.queue.insertElementAt(value, index);
        this.notifyAll();
    }

    public synchronized T removeHead() {
        while (this.queue.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
        T value = this.queue.remove(0);
        return value;
    }

    public synchronized T getHead() {
        while (this.queue.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
        T value = this.queue.elementAt(0);
        return value;
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public int size() {
        return this.queue.size();
    }
}

