/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class EditAsciiFile {
    private static final String APPLET_IE_TOKEN_DELIMITER = ">";
    private static final String APPLET_NS_TOKEN_DELIMITER = " ";

    private EditAsciiFile() {
    }

    private static boolean isIEValue(String valueToken) {
        return valueToken.indexOf(APPLET_IE_TOKEN_DELIMITER) > -1;
    }

    private static boolean isNSValue(String valueToken) {
        return valueToken.indexOf(APPLET_NS_TOKEN_DELIMITER) > -1;
    }

    private static String getSuffixWhenTokenHasDelimiter(String valueToken, String delimiter) {
        int valueEnd = (valueToken = valueToken.trim()).indexOf(delimiter);
        if (valueEnd == -1) {
            return "";
        }
        String value = valueToken.substring(valueEnd);
        return value;
    }

    private static String getLeadingSpaces(String valueToken) {
        StringBuffer leadingSpaces = new StringBuffer();
        char[] array = valueToken.toCharArray();
        for (int i = 0; i < array.length && Character.isSpaceChar(array[i]); ++i) {
            leadingSpaces.append(array[i]);
        }
        return leadingSpaces.toString();
    }

    private static String getTailingSpaces(String valueToken) {
        StringBuffer tailingSpaces = new StringBuffer();
        char[] array = valueToken.toCharArray();
        for (int i = array.length - 1; i >= 0 && Character.isSpaceChar(array[i]); --i) {
            tailingSpaces.append(array[i]);
        }
        return tailingSpaces.toString();
    }

    public static void changeAppletValues(Properties newValues, String appletFileName) {
        Enumeration<?> e = newValues.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            EditAsciiFile.changeAppletValue(name, newValues.getProperty(name), appletFileName);
        }
    }

    private static void changeAppletValue(String name, Object newValue, String appletFileName) {
        try {
            String line;
            FileInputStream fis = new FileInputStream(appletFileName);
            BufferedInputStream bis = new BufferedInputStream(fis);
            InputStreamReader isr = new InputStreamReader(bis);
            BufferedReader br = new BufferedReader(isr);
            FileOutputStream fos = new FileOutputStream(EditAsciiFile.getTempFileName(appletFileName));
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            OutputStreamWriter osw = new OutputStreamWriter(bos);
            BufferedWriter bw = new BufferedWriter(osw);
            while ((line = br.readLine()) != null) {
                int start = line.indexOf(name);
                if (start > -1) {
                    StringBuffer newLine = new StringBuffer(line.substring(0, start));
                    String relevantLine = line.substring(start);
                    String delimiter = "=";
                    StringTokenizer tokens = new StringTokenizer(relevantLine, delimiter);
                    while (tokens.hasMoreElements()) {
                        String valueToken = tokens.nextToken();
                        newLine.append(valueToken);
                        if (tokens.hasMoreElements()) {
                            newLine.append(delimiter);
                        }
                        if (valueToken.indexOf(name) <= -1) continue;
                        valueToken = tokens.nextToken();
                        String leadingSpaces = EditAsciiFile.getLeadingSpaces(valueToken);
                        newLine.append(leadingSpaces);
                        newLine.append(newValue);
                        if (EditAsciiFile.isIEValue(valueToken)) {
                            newLine.append(EditAsciiFile.getSuffixWhenTokenHasDelimiter(valueToken, APPLET_IE_TOKEN_DELIMITER));
                            continue;
                        }
                        if (!EditAsciiFile.isNSValue(valueToken)) continue;
                        newLine.append(EditAsciiFile.getSuffixWhenTokenHasDelimiter(valueToken, APPLET_NS_TOKEN_DELIMITER));
                        String tailingSpaces = EditAsciiFile.getTailingSpaces(valueToken);
                        newLine.append(tailingSpaces);
                    }
                    bw.write(newLine.toString());
                } else {
                    bw.write(line);
                }
                bw.newLine();
            }
            br.close();
            bw.flush();
            bw.close();
            File oldFile = new File(appletFileName);
            oldFile.delete();
            File newFile = new File(EditAsciiFile.getTempFileName(appletFileName));
            newFile.renameTo(oldFile);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static String getTempFileName(String originFileName) {
        return originFileName + "~";
    }
}

