/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util;

import com.sanrad.util.DoubleMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DoubleHashMap<K, V>
implements DoubleMap<K, V> {
    private Map<K, V> myStraightMap = new HashMap();
    private Map<V, K> myReverseMap = new HashMap<V, K>();

    @Override
    public boolean containsValue(Object aValue) {
        return this.myReverseMap.containsKey(aValue);
    }

    @Override
    public V get(Object aKey) {
        return this.myStraightMap.get(aKey);
    }

    @Override
    public K getKey(V aVal) {
        return this.myReverseMap.get(aVal);
    }

    @Override
    public V put(K aKey, V aValue) {
        V retVal = this.myStraightMap.put(aKey, aValue);
        K key = this.myReverseMap.put(aValue, aKey);
        assert (key.equals(aKey)) : "the mapping must have the same values.";
        return retVal;
    }

    @Override
    public V remove(Object aKey) {
        V retVal = this.myStraightMap.remove(aKey);
        K key = this.myReverseMap.remove(retVal);
        assert (key.equals(aKey)) : "the mapping must have the same values.";
        return retVal;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> aT) {
        this.myStraightMap.putAll(aT);
        for (Map.Entry<K, V> entry : aT.entrySet()) {
            this.myReverseMap.put(entry.getValue(), entry.getKey());
        }
    }

    @Override
    public void clear() {
        this.myStraightMap.clear();
        this.myReverseMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.myStraightMap.keySet());
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.myReverseMap.keySet());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(this.myStraightMap.entrySet());
    }

    @Override
    public int size() {
        return this.myStraightMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myStraightMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object aKey) {
        return this.myStraightMap.containsKey(aKey);
    }
}

