/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import java.lang.reflect.Method;
import javax.swing.JOptionPane;

public class BrowserLauncher {
    private static final String errMsg = "Error attempting to launch web browser";
    private static final String myOsName = System.getProperty("os.name");
    private static final String MACOS_NAME = "Mac OS";
    private static final String WINDOWS_NAME = "Windows";
    private static final String[] myBrowsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
    private static final SrLogger theLogger = SrLogger.getLogger();

    public static void openURL(String url) {
        try {
            if (myOsName.startsWith(MACOS_NAME)) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (myOsName.startsWith(WINDOWS_NAME)) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String browser = null;
                for (int count = 0; count < myBrowsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", myBrowsers[count]}).waitFor() != 0) continue;
                    browser = myBrowsers[count];
                }
                if (browser == null) {
                    theLogger.logAndThrow(SrLogCategories.EXCEPTION, (Throwable)new IllegalStateException("Couldn't find web browser to load the URL"), new Object[]{"Couldn't find web browser to load the URL"});
                } else {
                    Runtime.getRuntime().exec(new String[]{browser, url});
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error attempting to launch web browser:\n" + e.getLocalizedMessage());
        }
    }
}

