/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util.types.constants;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.util.types.SrBITS;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class SrBITSConstant
extends SrBITS {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static HashMap<Class<? extends SrBITSConstant>, ArrayList<? extends SrBITSConstant>> allBitsConstants = new HashMap();
    private int m_bitNumber;
    private int myNBits;
    private int[] myTurnedOnBits;
    private String[] myMibStrings;
    private String myDisplay;

    protected SrBITSConstant(int nBits, int turnedOnBit, String mibString, String display) {
        this(nBits, new int[]{turnedOnBit}, new String[]{mibString}, display);
    }

    protected SrBITSConstant(int nBits, int[] turnedOnBits, String[] mibStrings, String display) {
        super(nBits);
        if (turnedOnBits.length != mibStrings.length) {
            throw new IllegalArgumentException("Inconsistent input");
        }
        if (turnedOnBits.length == 0) {
            throw new IllegalArgumentException("Turned On Bits is not initialized");
        }
        for (int i = 0; i < turnedOnBits.length; ++i) {
            if (turnedOnBits[i] < 0) continue;
            ((BitSet)this.value).set(turnedOnBits[i]);
        }
        this.myNBits = nBits;
        this.myTurnedOnBits = turnedOnBits;
        this.myMibStrings = mibStrings;
        this.myDisplay = display;
        this.addToBitsConstantsHashMap(this.getClass());
    }

    public Object clone() {
        Constructor<?>[] constructors;
        for (Constructor<?> c : constructors = this.getClass().getDeclaredConstructors()) {
            c.setAccessible(true);
            Object[] parameters1 = new Class[]{Integer.TYPE, int[].class, String[].class, String.class};
            if (Arrays.equals(c.getParameterTypes(), parameters1)) {
                try {
                    return c.newInstance(this.myNBits, this.myTurnedOnBits, this.myMibStrings, this.myDisplay);
                }
                catch (Exception e) {
                    theLogger.error(SrLogCategories.EXCEPTION, (Throwable)e, new Object[0]);
                    return null;
                }
            }
            Object[] parameters2 = new Class[]{Integer.TYPE, Integer.TYPE, String[].class, String.class};
            if (Arrays.equals(c.getParameterTypes(), parameters2)) {
                try {
                    return c.newInstance(this.myNBits, this.myTurnedOnBits[0], this.myMibStrings, this.myDisplay);
                }
                catch (Exception e) {
                    theLogger.error(SrLogCategories.EXCEPTION, (Throwable)e, new Object[0]);
                    return null;
                }
            }
            Object[] parameters3 = new Class[]{Integer.TYPE, String.class, String.class};
            if (!Arrays.equals(c.getParameterTypes(), parameters3)) continue;
            try {
                return c.newInstance(this.myTurnedOnBits[0], this.myMibStrings[0], this.myDisplay);
            }
            catch (Exception e) {
                theLogger.error(SrLogCategories.EXCEPTION, (Throwable)e, new Object[0]);
                return null;
            }
        }
        return null;
    }

    public int getBitNumber() {
        return this.m_bitNumber;
    }

    protected static <T extends SrBITSConstant> T parseToBitsConstant(String formattedMibString, Class c) {
        List<String> mibStringsList = SrBITSConstant.parseMibStrings(formattedMibString);
        if (mibStringsList == null) {
            return null;
        }
        ArrayList<? extends SrBITSConstant> allBitsConstantList = allBitsConstants.get(c);
        ArrayList<SrBITSConstant> bitsConstantSet = new ArrayList<SrBITSConstant>();
        int nBits = 0;
        for (SrBITSConstant srBITSConstant : allBitsConstantList) {
            if (!srBITSConstant.containedIn(mibStringsList)) continue;
            bitsConstantSet.add(srBITSConstant);
            nBits = Math.max(nBits, ((BitSet)srBITSConstant.value).length());
        }
        if (!bitsConstantSet.isEmpty()) {
            if (bitsConstantSet.size() == 1) {
                return (T)((SrBITSConstant)bitsConstantSet.get(0));
            }
            SrBITSConstant created = (SrBITSConstant)((SrBITSConstant)bitsConstantSet.get(0)).clone();
            if (created == null) {
                return null;
            }
            created.myMibStrings = mibStringsList.toArray(new String[mibStringsList.size()]);
            created.myDisplay = formattedMibString;
            ((BitSet)created.value).clear();
            for (SrBITSConstant nextBit : bitsConstantSet) {
                ((BitSet)created.value).or((BitSet)nextBit.value);
            }
            return (T)created;
        }
        return null;
    }

    protected static <T extends SrBITSConstant> T valueOf(String monfoxFormattedString, Class<T> c) {
        ArrayList<? extends SrBITSConstant> list = allBitsConstants.get(c);
        if (list != null) {
            List<String> valMibStrings = SrBITSConstant.parseMibStrings(monfoxFormattedString);
            if (valMibStrings == null) {
                return null;
            }
            for (int i = 0; i < list.size(); ++i) {
                SrBITSConstant bitConstant = list.get(i);
                if (!bitConstant.equivalent(valMibStrings)) continue;
                return (T)bitConstant;
            }
        }
        return null;
    }

    protected static SrBITSConstant[] getValues(Class c) {
        ArrayList<? extends SrBITSConstant> list = allBitsConstants.get(c);
        if (list != null && list.size() != 0) {
            SrBITSConstant[] objs = new SrBITSConstant[list.size()];
            return list.toArray(objs);
        }
        return null;
    }

    private <T extends SrBITSConstant> void addToBitsConstantsHashMap(Class<T> aClass) {
        ArrayList<SrBITSConstant> values = allBitsConstants.get(aClass);
        if (values == null) {
            values = new ArrayList();
            allBitsConstants.put(aClass, values);
        }
        if (!values.contains(this)) {
            values.add(this);
        }
    }

    @Override
    public String toString() {
        return this.myDisplay;
    }

    private static List<String> parseMibStrings(String str) {
        StringBuffer buff = new StringBuffer(str);
        if (buff.indexOf("{") < 0 || buff.indexOf("}") < 0) {
            return null;
        }
        buff.deleteCharAt(buff.indexOf("{"));
        buff.deleteCharAt(buff.indexOf("}"));
        int i = buff.length();
        while (i-- > 0) {
            if (!Character.isWhitespace(buff.charAt(i))) continue;
            buff.deleteCharAt(i);
        }
        StringTokenizer tokens = new StringTokenizer(buff.toString(), ",");
        ArrayList<String> list = new ArrayList<String>();
        if (buff.length() == 0) {
            list.add("");
        } else {
            while (tokens.hasMoreElements()) {
                list.add(tokens.nextToken());
            }
        }
        return list;
    }

    private boolean equivalent(List<String> aOtherMibStrings) {
        if (aOtherMibStrings.size() == this.myMibStrings.length) {
            List<String> mibStringsList = Arrays.asList(this.myMibStrings);
            int i = aOtherMibStrings.size();
            while (i-- > 0) {
                if (mibStringsList.contains(aOtherMibStrings.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean containedIn(List<String> valMibStrings) {
        return valMibStrings.containsAll(Arrays.asList(this.myMibStrings));
    }

    public boolean contains(SrBITSConstant other) {
        return Arrays.asList(this.myMibStrings).containsAll(Arrays.asList(other.myMibStrings));
    }

    public <T extends SrBITSConstant> T turnOnBitConstant(T aOtherBitConstant) {
        if (aOtherBitConstant == null) {
            return (T)this;
        }
        SrBITSConstant cloned = (SrBITSConstant)this.clone();
        ArrayList<String> clonedMibStrings = new ArrayList<String>(Arrays.asList(cloned.myMibStrings));
        for (String str : aOtherBitConstant.myMibStrings) {
            if (clonedMibStrings.contains(str)) continue;
            clonedMibStrings.add(str);
        }
        cloned.myMibStrings = clonedMibStrings.toArray(new String[clonedMibStrings.size()]);
        ((BitSet)cloned.value).or((BitSet)aOtherBitConstant.value);
        cloned.makeCoherency();
        return (T)cloned;
    }

    public <T extends SrBITSConstant> T turnOffBitConstant(T aOtherBitConstant) {
        if (aOtherBitConstant == null) {
            return (T)this;
        }
        SrBITSConstant cloned = (SrBITSConstant)this.clone();
        ArrayList<String> clonedMibStrings = new ArrayList<String>(Arrays.asList(cloned.myMibStrings));
        clonedMibStrings.removeAll(Arrays.asList(aOtherBitConstant.myMibStrings));
        cloned.myMibStrings = clonedMibStrings.toArray(new String[clonedMibStrings.size()]);
        ((BitSet)cloned.value).andNot((BitSet)aOtherBitConstant.value);
        cloned.makeCoherency();
        return (T)cloned;
    }

    private void makeCoherency() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean hasBitsOn = false;
        for (String str : this.myMibStrings) {
            sb.append(str).append(',');
            if (str.isEmpty()) continue;
            hasBitsOn = true;
        }
        if (this.myMibStrings.length > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append('}');
        this.myDisplay = sb.toString();
        BitSet bitsetValue = (BitSet)this.value;
        ArrayList<Integer> turnedOnBitsList = new ArrayList<Integer>();
        for (i = 0; i < bitsetValue.size(); ++i) {
            if (!bitsetValue.get(i)) continue;
            turnedOnBitsList.add(i);
        }
        if (hasBitsOn) {
            this.myTurnedOnBits = new int[turnedOnBitsList.size()];
            for (i = 0; i < this.myTurnedOnBits.length; ++i) {
                this.myTurnedOnBits[i] = (Integer)turnedOnBitsList.get(i);
            }
        } else {
            this.myTurnedOnBits = new int[]{-1};
            this.myMibStrings = new String[]{""};
        }
    }
}

