/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util.types.constants;

import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public abstract class MibItemConstant
extends SrType
implements Comparable<MibItemConstant> {
    protected static HashMap<Class, HashMap<Integer, MibItemConstant>> allMibConst = new HashMap();
    private String descriptionName;
    private Object userValue;
    protected Integer constValue;

    protected MibItemConstant(int value, String description, Object userVal) {
        super("MibItemConstant");
        this.constValue = value;
        this.descriptionName = description;
        this.userValue = userVal;
        this.addValueToMibConstsHashMap();
    }

    protected MibItemConstant(String description, Object userVal) {
        super("MibItemConstant");
        this.descriptionName = description;
        this.userValue = userVal;
    }

    @Override
    public String toString() {
        return this.descriptionName;
    }

    @Override
    public String toDisplayString() {
        return this.descriptionName;
    }

    public Integer intValue() {
        return this.constValue;
    }

    public Object userVal() {
        return this.userValue;
    }

    @Override
    public Object value() {
        return this.constValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (this.getClass().equals(obj.getClass())) {
                return this.constValue.equals(((MibItemConstant)obj).intValue());
            }
            if (obj instanceof Integer) {
                return this.constValue.equals((Integer)obj);
            }
            if (obj instanceof SrInteger) {
                return this.constValue.equals((Integer)((SrInteger)obj).value());
            }
        }
        return false;
    }

    @Override
    public String errorDisplayString() {
        return ": " + this.toString();
    }

    public String getDescriptionName() {
        return this.descriptionName;
    }

    @Override
    public int getTypeNumber() {
        return 9;
    }

    public static Object[] getValues() {
        throw new UnsupportedOperationException("The getValues method is not implemented this MIB constant");
    }

    public static <T extends MibItemConstant> T valueOf(Class<T> c, int mibValue) {
        return (T)allMibConst.get(c).get(mibValue);
    }

    private void addValueToMibConstsHashMap() {
        Class<?> classKey = this.getClass();
        HashMap<Integer, MibItemConstant> values = allMibConst.get(classKey);
        if (values == null) {
            values = new HashMap();
            allMibConst.put(classKey, values);
        }
        values.put(this.constValue, this);
    }

    protected static MibItemConstant[] getValues(Class<? extends MibItemConstant> aClass) {
        List<? extends MibItemConstant> list = MibItemConstant.getValueList(aClass);
        return list.toArray(new MibItemConstant[list.size()]);
    }

    protected static <T extends MibItemConstant> List<T> getValueList(Class<T> aClass) {
        ArrayList<MibItemConstant> list = new ArrayList<MibItemConstant>(allMibConst.get(aClass).values());
        Collections.sort(list);
        return list;
    }

    @Override
    public int compareTo(MibItemConstant o) {
        if (o == null) {
            return 1;
        }
        return this.intValue() - o.intValue();
    }
}

