/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util.types;

import com.sanrad.nms.server.exception.TypeMismatchException;
import com.sanrad.nms.server.util.types.SrLong;
import java.math.BigInteger;

public class SrULong
extends SrLong {
    public SrULong() {
    }

    public SrULong(long i) {
        super(i);
        if (i < 0L) {
            // empty if block
        }
    }

    public SrULong(Long i) {
        super(i);
        if (i < 0L) {
            throw new TypeMismatchException();
        }
    }

    public SrULong(BigInteger i) {
        super(i, "SrULong");
        if (i.compareTo(BigInteger.ZERO) < 0) {
            throw new TypeMismatchException(i.toString());
        }
    }

    public SrULong(SrLong i) {
        super(i);
        if (i.longValue() < 0L) {
            throw new TypeMismatchException();
        }
    }

    public SrULong(SrULong i) {
        super(i);
    }

    @Override
    public void setVal(long i) {
        if (i < 0L) {
            throw new TypeMismatchException();
        }
        this.value = new Long(i);
    }

    @Override
    public void setVal(Long i) {
        if (i < 0L) {
            throw new TypeMismatchException();
        }
        this.value = i;
    }

    @Override
    public void setVal(SrLong i) {
        if (i.longValue() < 0L) {
            throw new TypeMismatchException();
        }
        this.value = (Long)i.value();
    }

    @Override
    public String errorDisplayString() {
        return "SrULong: " + this.value.toString();
    }
}

