/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util.types;

import com.sanrad.nms.server.util.types.SrUInteger;

public class SrTimeTicks
extends SrUInteger {
    public SrTimeTicks() {
    }

    public SrTimeTicks(int i) {
        super(i);
    }

    public SrTimeTicks(long i) {
        super(i);
    }

    public SrTimeTicks(Integer i) {
        super(i);
    }

    public SrTimeTicks(SrUInteger i) {
        super(i);
    }

    public SrTimeTicks(SrTimeTicks i) {
        super(i);
    }

    @Override
    public String errorDisplayString() {
        return "SrTimeticks: " + this.value.toString();
    }

    @Override
    public int getTypeNumber() {
        return 5;
    }

    public String toFormattedString() {
        return new FormattedTime(this).toString();
    }

    private static class FormattedTime {
        int myDays;
        int myHours;
        int myMinutes;
        int mySeconds;
        private final int DAYS_DIVIDER = 8640000;
        private final int HOURS_DIVIDER = 360000;
        private final int MINUTES_DIVIDER = 6000;
        private final int SECONDS_DIVIDER = 100;

        public FormattedTime(SrTimeTicks aTime) {
            this.updateTimeFields(aTime);
        }

        private void updateTimeFields(SrTimeTicks aTime) {
            long val = aTime.longValue();
            this.myDays = Math.max(0, (int)(val / 8640000L));
            this.myHours = Math.max(0, (int)((val -= (long)(8640000 * this.myDays)) / 360000L));
            this.myMinutes = Math.max(0, (int)((val -= (long)(360000 * this.myHours)) / 6000L));
            this.mySeconds = Math.max(0, (int)((val -= (long)(6000 * this.myMinutes)) / 100L));
        }

        public String toString() {
            return this.myDays + " Days, " + this.myHours + " Hours, " + this.myMinutes + " Mins " + this.mySeconds + " Secs";
        }
    }
}

