/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util.types;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.exception.TypeMismatchException;
import com.sanrad.nms.server.util.types.SrType;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SrIpAddress
extends SrType {
    static final int IP_ADDRESS_LEN = 4;
    private static SrLogger theLogger = SrLogger.getLogger();
    private static final String _255_REG_EX = "(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)";
    private static final String IP_BASE_REG_EX = "(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)";
    private static final String IP_URL_REG_EX = "http://(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)($|/)";
    private static final String IP_REG_EX = "^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$";
    private Pattern myIpRegExPattern = Pattern.compile("^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");

    public SrIpAddress() {
        super("SrIpAddress");
        try {
            this.value = InetAddress.getByName("0.0.0.0");
        }
        catch (UnknownHostException e) {
            throw new TypeMismatchException();
        }
    }

    public SrIpAddress(URL aUrl) {
        super("SrIpAddress");
        String urlStr = aUrl.toString();
        Pattern IpUrlRegExPattern = Pattern.compile(IP_URL_REG_EX);
        Matcher ipMatcher = IpUrlRegExPattern.matcher(urlStr);
        try {
            if (ipMatcher.find()) {
                String urlIp = ipMatcher.group();
                if ((urlIp = urlIp.substring(new String("http://").length())).endsWith("/")) {
                    urlIp = urlIp.substring(0, urlIp.length() - 1);
                }
                this.value = InetAddress.getByName(urlIp);
            }
        }
        catch (UnknownHostException e) {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{e});
            throw new TypeMismatchException();
        }
    }

    public SrIpAddress(String ip) {
        super("SrIpAddress");
        if (ip.indexOf(".") > 0) {
            try {
                this.value = InetAddress.getByName(ip);
            }
            catch (UnknownHostException e) {
                try {
                    URL url = new URL(ip);
                    this.value = InetAddress.getByName(url.getHost());
                }
                catch (MalformedURLException e1) {
                    throw new TypeMismatchException(ip);
                }
                catch (UnknownHostException e2) {
                    throw new TypeMismatchException(ip);
                }
            }
        } else {
            String dotIp = "";
            if (ip.indexOf("'") == 0) {
                for (int i = 0; i < 4; ++i) {
                    dotIp = dotIp + Integer.parseInt(ip.substring(2 * i + 1, 2 * i + 3), 16);
                    if (i >= 3) continue;
                    dotIp = dotIp + ".";
                }
            } else {
                throw new TypeMismatchException(ip);
            }
            try {
                this.value = InetAddress.getByName(dotIp);
            }
            catch (UnknownHostException e) {
                theLogger.error(SrLogCategories.EXCEPTION, (Throwable)e, new Object[0]);
                throw new TypeMismatchException("ip=" + ip + "; dotIp=" + dotIp);
            }
        }
    }

    public SrIpAddress(Byte[] ip) {
        super("SrIpAddress");
        try {
            this.value = InetAddress.getByName(this.byteArrayToString(ip));
        }
        catch (UnknownHostException e) {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{e});
            throw new TypeMismatchException();
        }
    }

    public SrIpAddress(byte[] ip) {
        super("SrIpAddress");
        try {
            this.value = InetAddress.getByName(this.byteArrayToString(ip));
        }
        catch (UnknownHostException e) {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{e});
            throw new TypeMismatchException();
        }
    }

    public SrIpAddress(SrIpAddress ip) {
        super("SrIpAddress");
        try {
            this.value = InetAddress.getByName(ip.toString());
        }
        catch (UnknownHostException e) {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{e});
            throw new TypeMismatchException();
        }
    }

    public SrIpAddress(InetAddress ip) {
        super("SrIpAddress");
        try {
            this.value = InetAddress.getByName(ip.getHostAddress());
        }
        catch (UnknownHostException e) {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{e});
            throw new TypeMismatchException();
        }
    }

    @Override
    public String toString() {
        return ((InetAddress)this.value).getHostAddress();
    }

    private String byteArrayToString(byte[] ip) {
        if (ip.length != 4) {
            throw new TypeMismatchException();
        }
        int[] intVal = new int[ip.length];
        for (int i = 0; i < ip.length; ++i) {
            byte b = ip[i];
            int j = b << 24;
            intVal[i] = j >>> 24;
        }
        return String.valueOf(intVal[0]) + "." + String.valueOf(intVal[1]) + "." + String.valueOf(intVal[2]) + "." + String.valueOf(intVal[3]);
    }

    private String byteArrayToString(Byte[] ip) {
        if (ip.length != 4) {
            throw new TypeMismatchException();
        }
        return ip[0].toString() + "." + ip[1].toString() + "." + ip[2].toString() + "." + ip[3].toString();
    }

    public Object clone() {
        return new SrIpAddress(((InetAddress)this.value).getHostAddress());
    }

    public void setVal(String ip) {
        try {
            this.value = InetAddress.getByName(ip);
        }
        catch (UnknownHostException e) {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{e});
            throw new TypeMismatchException();
        }
    }

    public void setVal(Byte[] ip) {
        try {
            this.value = InetAddress.getByName(this.byteArrayToString(ip));
        }
        catch (UnknownHostException e) {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{e});
            throw new TypeMismatchException();
        }
    }

    public void setVal(SrIpAddress ip) {
        try {
            this.value = InetAddress.getByName(ip.toString());
        }
        catch (UnknownHostException e) {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{e});
            throw new TypeMismatchException();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SrIpAddress) {
            return ((InetAddress)this.value).equals(((SrIpAddress)obj).value());
        }
        if (obj instanceof InetAddress) {
            return this.value.equals(obj);
        }
        if (obj instanceof Byte[]) {
            SrIpAddress ip = new SrIpAddress((Byte[])obj);
            return this.equals(ip);
        }
        if (obj instanceof String) {
            SrIpAddress ip = new SrIpAddress((String)obj);
            return this.equals(ip);
        }
        return false;
    }

    @Override
    public String toDisplayString() {
        return this.toString();
    }

    @Override
    public String errorDisplayString() {
        return "SrIpAddress: " + this.toDisplayString();
    }

    public String toInetAddressSnmpString() {
        String ip = ((InetAddress)this.value).getHostAddress();
        String hexIp = "'";
        String hexVal = null;
        String tmpStr = ip;
        while (tmpStr.indexOf(".") >= 0) {
            hexVal = Integer.toHexString(Integer.parseInt(tmpStr.substring(0, tmpStr.indexOf("."))));
            if (hexVal.length() == 1) {
                hexVal = "0" + hexVal;
            }
            hexIp = hexIp + hexVal;
            tmpStr = tmpStr.substring(tmpStr.indexOf(".") + 1);
        }
        hexVal = Integer.toHexString(Integer.parseInt(tmpStr));
        if (hexVal.length() == 1) {
            hexVal = "0" + hexVal;
        }
        hexIp = hexIp + hexVal + "'H";
        return hexIp;
    }

    public String getIntValAsString() {
        byte[] bVal = ((InetAddress)this.value).getAddress();
        long lVal = 0L;
        for (int i = 0; i < 4; ++i) {
            lVal = bVal[i] >= 0 ? 256L * lVal + (long)bVal[i] : 256L * lVal + 256L + (long)bVal[i];
        }
        return String.valueOf(lVal);
    }

    @Override
    public int getTypeNumber() {
        return 7;
    }
}

