/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util;

import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyFetcher;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.DataBaseCommKey;

public class SnmpCommKey
extends CommKey
implements CommKeyFetcher {
    char mySnmpAgentIndex;

    public SnmpCommKey(char snmpAgentIndex) {
        this.mySnmpAgentIndex = snmpAgentIndex;
    }

    public SnmpCommKey(String key, char snmpAgentIndex) {
        super(key);
        this.mySnmpAgentIndex = snmpAgentIndex;
    }

    public SnmpCommKey(CommKey key, char snmpAgentIndex) {
        super(key);
        this.mySnmpAgentIndex = snmpAgentIndex;
    }

    @Override
    public Object clone() {
        return new SnmpCommKey(this.myKey, this.mySnmpAgentIndex);
    }

    @Override
    public SnmpCommKey getSnmpCommKey() {
        return this;
    }

    @Override
    public DataBaseCommKey getDBCommKey() {
        return null;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof SnmpCommKey) {
            return this.myKey.equals(((SnmpCommKey)other).getKey()) && this.mySnmpAgentIndex == ((SnmpCommKey)other).getSnmpAgentIndex();
        }
        return false;
    }

    public char getSnmpAgentIndex() {
        return this.mySnmpAgentIndex;
    }

    public void setSnmpAgentIndex(char snmpAgentIndex) {
        this.mySnmpAgentIndex = snmpAgentIndex;
    }

    @Override
    public String toDisplayString() {
        return this.myKey + " SNMP agent: " + CommKeyUtil.getIpFromIndex(this.mySnmpAgentIndex);
    }

    public int hashCode() {
        String forHash = this.myKey + this.mySnmpAgentIndex;
        return forHash.hashCode();
    }
}

