/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util;

import com.sanrad.nms.server.util.MasterParameter;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.Parameters;
import java.util.HashMap;
import java.util.Vector;

public class ParameterList {
    private MasterParameter[] m_params;

    public ParameterList(Vector vec) {
        this.m_params = new MasterParameter[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            if (vec.get(i).getClass().equals(Parameter.class)) continue;
            throw new IllegalArgumentException("Value (" + vec.get(i).getClass() + ") should be of type " + Parameter.class);
        }
        vec.copyInto(this.m_params);
    }

    public ParameterList(HashMap hash) {
        this.m_params = new MasterParameter[hash.size()];
        int index = 0;
        for (ParameterCode code : hash.keySet()) {
            MasterParameter param;
            this.m_params[index] = param = new MasterParameter(code, hash.get(code));
            ++index;
        }
    }

    public ParameterList(MasterParameter[] array) {
        this.m_params = array;
    }

    public ParameterList(ParameterCodes[] array) {
        int length = array.length;
        this.m_params = new MasterParameter[length];
        for (int i = 0; i < length; ++i) {
            this.m_params[i] = new MasterParameter(array[i], null);
        }
    }

    public boolean equals(Object obj) {
        ParameterList params = (ParameterList)obj;
        for (int i = 0; i < this.m_params.length; ++i) {
            if (this.m_params[i].equals(params.getParameter(i))) continue;
            return false;
        }
        return true;
    }

    public ParameterList(ParameterList list) {
        System.arraycopy(this.m_params, this.m_params.length, list.m_params, this.m_params.length, this.m_params.length);
    }

    public ParameterList(MasterParameter param) {
        this.m_params = new MasterParameter[1];
        this.m_params[0] = param;
    }

    public ParameterList(ParameterCodes code, Object value) {
        MasterParameter param = new MasterParameter(code, value);
        this.m_params = new MasterParameter[1];
        this.m_params[0] = param;
    }

    public Parameters getParameter(int index) {
        return this.m_params[index];
    }

    public ParameterList setParameter(int index, MasterParameter param) {
        this.m_params[index] = param;
        return this;
    }

    public int getLength() {
        return this.m_params.length;
    }

    public int hashCode() {
        int accumaltor = 0;
        for (int i = 0; i < this.m_params.length; ++i) {
            accumaltor += this.m_params[i].hashCode();
        }
        return accumaltor;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.m_params.length; ++i) {
            buffer.append(this.m_params[i]);
            buffer.append("; ");
        }
        return buffer.toString();
    }

    public HashMap<ParameterCodes, Object> getParamerListToHashMap() {
        HashMap<ParameterCodes, Object> hash = new HashMap<ParameterCodes, Object>();
        for (int i = 0; i < this.m_params.length; ++i) {
            hash.put(this.m_params[i].getCode(), this.m_params[i].getValue());
        }
        return hash;
    }
}

