/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.exception.TypeMismatchException;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyFetcher;
import com.sanrad.nms.server.util.DataBaseCommKey;
import com.sanrad.nms.server.util.SnmpCommKey;
import java.util.Iterator;
import java.util.Vector;

public class CommKeyUtil {
    private static CommKeyClassId[] vSwitchList = new CommKeyClassId[0];
    private static SrLogger theLogger = SrLogger.getLogger();

    private CommKeyUtil() {
    }

    public static synchronized void addVSwitch(CommKeyClassId vSwitchData) {
        if (!vSwitchData.getClassID().equals(ClassID.VSWITCH)) {
            throw new TypeMismatchException("Not " + ClassID.VSWITCH + " element");
        }
        char indexToAdd = vSwitchData.getMyFirstSnmpAgentIndex();
        if (indexToAdd <= vSwitchList.length - 1) {
            if (vSwitchList[indexToAdd] != null) {
                throw new TypeMismatchException("The index of the Snmp Agent already added");
            }
        } else {
            CommKeyClassId[] newArray = new CommKeyClassId[indexToAdd + '\u0001'];
            System.arraycopy(vSwitchList, 0, newArray, 0, vSwitchList.length);
            vSwitchList = newArray;
        }
        CommKeyUtil.vSwitchList[indexToAdd] = new CommKeyClassId(vSwitchData);
    }

    public static synchronized void removeVSwitch(char SnmpAgentIndex) {
        CommKeyUtil.vSwitchList[SnmpAgentIndex] = null;
    }

    public static synchronized SnmpCommKey[] getSnmpCommKeys(CommKey[] keys) {
        Vector<SnmpCommKey> snmpKeys = new Vector<SnmpCommKey>();
        for (int i = 0; i < keys.length; ++i) {
            if (((CommKeyFetcher)((Object)keys[i])).getSnmpCommKey() == null) continue;
            snmpKeys.add(((CommKeyFetcher)((Object)keys[i])).getSnmpCommKey());
        }
        SnmpCommKey[] arrayVal = new SnmpCommKey[snmpKeys.size()];
        for (int i = 0; i < snmpKeys.size(); ++i) {
            arrayVal[i] = (SnmpCommKey)snmpKeys.get(i);
        }
        return arrayVal;
    }

    public static synchronized SnmpCommKey getSnmpCommKey(CommKey[] keys) {
        for (int i = 0; i < keys.length; ++i) {
            if (((CommKeyFetcher)((Object)keys[i])).getSnmpCommKey() == null) continue;
            return ((CommKeyFetcher)((Object)keys[i])).getSnmpCommKey();
        }
        return null;
    }

    public static synchronized SnmpCommKey getSnmpCommKey(CommKeyClassId data) {
        return CommKeyUtil.getSnmpCommKey(data.getCommKeys());
    }

    public static synchronized DataBaseCommKey[] geDbCommKeys(CommKey[] keys) {
        Vector<DataBaseCommKey> dbKeys = new Vector<DataBaseCommKey>();
        for (int i = 0; i < keys.length; ++i) {
            if (((CommKeyFetcher)((Object)keys[i])).getDBCommKey() == null) continue;
            dbKeys.add(((CommKeyFetcher)((Object)keys[i])).getDBCommKey());
        }
        DataBaseCommKey[] arrayVal = new DataBaseCommKey[dbKeys.size()];
        for (int i = 0; i < dbKeys.size(); ++i) {
            arrayVal[i] = (DataBaseCommKey)dbKeys.get(i);
        }
        return arrayVal;
    }

    public static synchronized DataBaseCommKey getDbCommKey(CommKey[] keys) {
        for (int i = 0; i < keys.length; ++i) {
            if (((CommKeyFetcher)((Object)keys[i])).getDBCommKey() == null) continue;
            return ((CommKeyFetcher)((Object)keys[i])).getDBCommKey();
        }
        return null;
    }

    public static synchronized CommKey[] mergerCommKeyLists(CommKey[] list1, CommKey[] list2) {
        int i;
        Vector<CommKey> keys = new Vector<CommKey>();
        if (list1 != null) {
            for (i = 0; i < list1.length; ++i) {
                keys.add(list1[i]);
            }
        }
        if (list2 != null) {
            for (i = 0; i < list2.length; ++i) {
                if (keys.contains(list2[i])) continue;
                keys.add(list2[i]);
            }
        }
        CommKey[] arrayVal = new CommKey[keys.size()];
        return keys.toArray(arrayVal);
    }

    public static synchronized CommKeyClassId mergeCommKeyClassIDs(CommKeyClassId key1, CommKeyClassId key2) {
        CommKey[] comkeys1 = key1 != null ? key1.getCommKeys() : null;
        CommKey[] comkeys2 = key2 != null ? key2.getCommKeys() : null;
        ClassID classId = null;
        if (key1 != null) {
            comkeys1 = key1.getCommKeys();
            classId = key1.getClassID();
        }
        if (key2 != null) {
            comkeys2 = key2.getCommKeys();
            if (classId == null) {
                classId = key2.getClassID();
            }
        }
        if (key1 == null && key2 == null) {
            return null;
        }
        return new CommKeyClassId(CommKeyUtil.mergerCommKeyLists(comkeys1, comkeys2), classId);
    }

    public static synchronized CommKey[] createOneCommKeyList(CommKey key1, CommKey key2) {
        CommKey[] keys = new CommKey[]{key1, key2};
        return keys;
    }

    public static synchronized CommKey[] createOneCommKeyList(CommKey[] list, CommKey key) {
        CommKey[] keys = new CommKey[list.length + 1];
        System.arraycopy(list, 0, keys, 0, list.length);
        keys[keys.length - 1] = key;
        return keys;
    }

    public static synchronized String getKeyForMessage(CommKey[] keys) {
        String key = "unknown";
        if (keys == null) {
            return key;
        }
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == null) continue;
            if (((CommKeyFetcher)((Object)keys[i])).getSnmpCommKey() != null) {
                key = ((CommKeyFetcher)((Object)keys[i])).getSnmpCommKey().toDisplayString();
                break;
            }
            key = keys[i].toString();
        }
        return key;
    }

    public static synchronized SnmpCommKey getSpecificSnmpKey(CommKey[] keys, char snmpAgentIndex) {
        for (int i = 0; i < keys.length; ++i) {
            if (((CommKeyFetcher)((Object)keys[i])).getSnmpCommKey() == null || ((SnmpCommKey)keys[i]).getSnmpAgentIndex() != snmpAgentIndex) continue;
            return (SnmpCommKey)keys[i];
        }
        return null;
    }

    public static synchronized SnmpCommKey getSpecificSnmpKey(CommKeyClassId data, char snmpAgentIndex) {
        return CommKeyUtil.getSpecificSnmpKey(data.getCommKeys(), snmpAgentIndex);
    }

    public static synchronized CommKey getSpecificCommKey(CommKeyClassId data, char snmpAgentIndex) {
        return CommKeyUtil.getSpecificSnmpKey(data.getCommKeys(), snmpAgentIndex);
    }

    public static synchronized CommKeyClassId getSpecificCommKeyClassId(CommKeyClassId data, char snmpAgentIndex) {
        SnmpCommKey snmpKey = CommKeyUtil.getSpecificSnmpKey(data.getCommKeys(), snmpAgentIndex);
        if (snmpKey == null) {
            return null;
        }
        return new CommKeyClassId(snmpKey, data.getClassID());
    }

    public static synchronized CommKeyClassId getSpecificCommKeyClassId(CommKeyClassId data, CommKeyClassId vSwitch) {
        return CommKeyUtil.getSpecificCommKeyClassId(data, vSwitch.getMyFirstSnmpAgentIndex());
    }

    public static synchronized CommKeyClassId getSpecificCommKeyClassId(CommKeyClassId[] data, char snmpAgentIndex) {
        for (int i = 0; i < data.length; ++i) {
            if (data[i].getMyFirstSnmpAgentIndex() != snmpAgentIndex) continue;
            return data[i];
        }
        return null;
    }

    public static synchronized boolean removeSpecificCommKeys(Vector allKeys, CommKey[] vSwitchToRemove) {
        return CommKeyUtil.removeSpecificCommKeys(allKeys, CommKeyUtil.getSnmpAgentIndex(vSwitchToRemove));
    }

    public static synchronized boolean removeSpecificCommKeys(Vector allKeys, char vSwitchToRemove) {
        Iterator keys = allKeys.iterator();
        boolean wasChanged = false;
        while (keys.hasNext()) {
            CommKey key = (CommKey)keys.next();
            if (((CommKeyFetcher)((Object)key)).getSnmpCommKey() == null || ((SnmpCommKey)key).getSnmpAgentIndex() != vSwitchToRemove) continue;
            keys.remove();
            wasChanged = true;
        }
        return wasChanged;
    }

    public static synchronized CommKey[] getAllButThisCommKey(CommKey[] allKeys, CommKey[] toKeep) {
        Vector<CommKey> vec = new Vector<CommKey>();
        if (allKeys != null) {
            int i;
            for (i = 0; i < allKeys.length; ++i) {
                vec.add(allKeys[i]);
            }
            for (i = 0; i < toKeep.length; ++i) {
                if (!vec.contains(toKeep[i])) continue;
                vec.remove(toKeep[i]);
            }
        }
        CommKey[] result = new CommKey[vec.size()];
        return vec.toArray(result);
    }

    public static synchronized char getSnmpAgentIndex(CommKey[] keys) {
        return CommKeyUtil.getSnmpCommKey(keys).getSnmpAgentIndex();
    }

    public static synchronized CommKeyClassId[] getVSwitchCommKeyClassIDs(CommKey[] commKeys) {
        SnmpCommKey[] snmpKeys = CommKeyUtil.getSnmpCommKeys(commKeys);
        CommKeyClassId[] vSwitches = new CommKeyClassId[snmpKeys.length];
        for (int i = 0; i < snmpKeys.length; ++i) {
            char index = snmpKeys[i].getSnmpAgentIndex();
            if (vSwitchList[index] == null) continue;
            vSwitches[i] = (CommKeyClassId)vSwitchList[index].clone();
        }
        return vSwitches;
    }

    public static synchronized CommKeyClassId getVSwitchData(char snmpAgentIndex) {
        if ((short)snmpAgentIndex < vSwitchList.length) {
            return vSwitchList[snmpAgentIndex];
        }
        theLogger.warn(SrLogCategories.LEGACY, new Object[]{ClassID.VSWITCH, " index ", (short)snmpAgentIndex, " not found"});
        return null;
    }

    public static synchronized CommKeyClassId getVSwitchData(CommKeyClassId object) {
        return vSwitchList[object.getMyFirstSnmpAgentIndex()];
    }

    public static synchronized boolean isNullKeys(CommKey[] keys) {
        if (keys == null) {
            return true;
        }
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == null) continue;
            return false;
        }
        return true;
    }

    public static synchronized String getIpFromIndex(char agentIndex) {
        return CommKeyUtil.getDbCommKey(vSwitchList[agentIndex].getCommKeys()).getKey();
    }

    public static synchronized boolean isEqual(CommKey[] list1, CommKey[] list2) {
        for (int i = 0; i < list1.length; ++i) {
            for (int j = 0; j < list2.length; ++j) {
                if (!list1[i].equals(list2[j])) continue;
                return true;
            }
        }
        return false;
    }

    public static SnmpCommKey getParentCommKey(SnmpCommKey key) {
        String myKey = key.getKey();
        int lastIndex = myKey.lastIndexOf(46);
        if (lastIndex > 0) {
            myKey = myKey.substring(0, lastIndex);
        }
        return new SnmpCommKey(myKey, key.getSnmpAgentIndex());
    }

    public static CommKeyClassId createCommKeyClassId(ClassID aType, String aIndex, char aAgentIndex) {
        SnmpCommKey snmpKey = new SnmpCommKey(aIndex, aAgentIndex);
        return new CommKeyClassId(snmpKey, aType);
    }
}

