/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ConfigOperation;
import com.sanrad.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClientConfigElementData
implements Serializable {
    private ConfigOperation myConfigOperation = ConfigOperation.NO_OPERATION;
    private static final long serialVersionUID = -8491527507010422448L;
    private ClassID myClassId;
    private CommKeyClassId myId;
    private CommKeyClassId myClusterId;
    private ClientConfigElementData[] myPreConfigurationElements = null;
    private ClientConfigElementData[] myPostConfigurationElements = null;
    private HashMap<ClientParameterCode, ConfigOperation> myNestedArraysCodeToOperation = new HashMap();
    private HashSet<ClientParameterCode> myNestedCedCodeList = new HashSet();
    private HashMap<ClientParameterCode, Object> myParams = new HashMap();

    public ClientConfigElementData(ClassID aClassId, CommKeyClassId aClusterId, ConfigOperation aConfigOper) {
        Util.validateInputNotNull(aClassId, "Class ID");
        Util.validateInputNotNull(aClusterId, "Cluster ID");
        this.myClassId = aClassId;
        this.myClusterId = aClusterId;
        this.setConfigOperation(aConfigOper);
    }

    public ClientConfigElementData(CommKeyClassId aId, CommKeyClassId aClusterId, ConfigOperation aConfigOper) {
        this(aId.getClassID(), aClusterId, aConfigOper);
        this.myId = aId;
    }

    public void putNestedElementData(ClientParameterCode aCode, ClientConfigElementData aSubElement) {
        if (ConfigOperation.CREATE.equals((Object)aSubElement.getConfigOperation()) && aSubElement.isCreated()) {
            throw new IllegalArgumentException("Nested CED is designated for creation but it is already created, use putValue(ClientParameterCode,Object) with the CKCI of the SubElement which already exists.");
        }
        this.myParams.put(aCode, aSubElement);
        this.myNestedCedCodeList.add(aCode);
        this.myNestedArraysCodeToOperation.remove(aCode);
    }

    public void putNestedElementDataArray(ClientParameterCode aCode, ClientConfigElementData[] aSubElementArray, ConfigOperation aConfigOperation) {
        this.myParams.put(aCode, aSubElementArray);
        this.myNestedArraysCodeToOperation.put(aCode, aConfigOperation);
        this.myNestedCedCodeList.remove(aCode);
    }

    public void putValue(ClientParameterCode aCode, Object aValue) {
        this.myParams.put(aCode, aValue);
        this.myNestedCedCodeList.remove(aCode);
        this.myNestedArraysCodeToOperation.remove(aCode);
    }

    public <V> V getValue(ClientParameterCode aCode) {
        return (V)this.myParams.get(aCode);
    }

    public <V> V removeValue(ClientParameterCode aCode) {
        return (V)this.myParams.remove(aCode);
    }

    public ClassID getClassId() {
        return this.myClassId;
    }

    public CommKeyClassId getCommKeyClassId() {
        return this.myId;
    }

    public CommKeyClassId getClusterId() {
        return this.myClusterId;
    }

    public Map<ClientParameterCode, Object> getValues() {
        HashMap<ClientParameterCode, Object> values = new HashMap<ClientParameterCode, Object>();
        for (ClientParameterCode key : this.myParams.keySet()) {
            Object value = this.myParams.get(key);
            if (this.myNestedCedCodeList.contains(key) || this.myNestedArraysCodeToOperation.containsKey(key)) continue;
            values.put(key, value);
        }
        return values;
    }

    public Map<ClientParameterCode, ClientConfigElementData> getAllNestedClientCeds() {
        HashMap<ClientParameterCode, ClientConfigElementData> nestedCeds = new HashMap<ClientParameterCode, ClientConfigElementData>();
        for (ClientParameterCode key : this.myNestedCedCodeList) {
            Object value = this.myParams.get(key);
            nestedCeds.put(key, (ClientConfigElementData)value);
        }
        return nestedCeds;
    }

    public Map<ClientParameterCode, ClientConfigElementData[]> getAllNestedClientCedArrays() {
        HashMap<ClientParameterCode, ClientConfigElementData[]> nestedCeds = new HashMap<ClientParameterCode, ClientConfigElementData[]>();
        for (ClientParameterCode key : this.myNestedArraysCodeToOperation.keySet()) {
            Object value = this.myParams.get(key);
            nestedCeds.put(key, (ClientConfigElementData[])value);
        }
        return nestedCeds;
    }

    public ConfigOperation getNestedConfigOperation(ClientParameterCode aCode) {
        if (this.myNestedArraysCodeToOperation.containsKey(aCode)) {
            return this.myNestedArraysCodeToOperation.get(aCode);
        }
        if (this.myNestedCedCodeList.contains(aCode)) {
            ClientConfigElementData ced = (ClientConfigElementData)this.myParams.get(aCode);
            return ced.getConfigOperation();
        }
        return null;
    }

    public void setPostConfigurationElement(ClientConfigElementData ... aPostConfigElements) {
        this.myPostConfigurationElements = aPostConfigElements;
    }

    public void setPostConfigurationElement(List<ClientConfigElementData> aPostConfigElements) {
        if (aPostConfigElements.isEmpty()) {
            return;
        }
        this.myPostConfigurationElements = aPostConfigElements.toArray(new ClientConfigElementData[aPostConfigElements.size()]);
    }

    public void setPreConfigurationElement(ClientConfigElementData ... aPreConfigElements) {
        this.myPreConfigurationElements = aPreConfigElements;
    }

    public void setPreConfigurationElement(List<ClientConfigElementData> aPreConfigElements) {
        if (aPreConfigElements.isEmpty()) {
            return;
        }
        this.myPreConfigurationElements = aPreConfigElements.toArray(new ClientConfigElementData[aPreConfigElements.size()]);
    }

    public List<ClientConfigElementData> getPostConfigurationElements() {
        if (this.myPostConfigurationElements != null) {
            return new ArrayList<ClientConfigElementData>(Arrays.asList(this.myPostConfigurationElements));
        }
        return Collections.emptyList();
    }

    public List<ClientConfigElementData> getPreConfigurationElements() {
        if (this.myPreConfigurationElements != null) {
            return new ArrayList<ClientConfigElementData>(Arrays.asList(this.myPreConfigurationElements));
        }
        return new ArrayList<ClientConfigElementData>();
    }

    private void setConfigOperation(ConfigOperation aConfigOper) {
        this.myConfigOperation = aConfigOper != null ? aConfigOper : ConfigOperation.NO_OPERATION;
    }

    public ConfigOperation getConfigOperation() {
        return this.myConfigOperation;
    }

    public boolean isNested(ClientParameterCode aCode) {
        return this.myNestedArraysCodeToOperation.containsKey(aCode) || this.myNestedCedCodeList.contains(aCode);
    }

    public boolean isCreated() {
        return this.getCommKeyClassId() != null;
    }

    public Set<ClientParameterCode> keySet() {
        return this.myParams.keySet();
    }

    public boolean containsKey(ClientParameterCode aCode) {
        return this.myParams.containsKey(aCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append('-');
        sb.append((Object)this.getConfigOperation());
        sb.append(':');
        sb.append(this.getClassId());
        sb.append('[');
        sb.append(this.myParams);
        sb.append(']');
        return sb.toString();
    }
}

