/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util.virtualization;

import java.util.List;

public class ResourceAliasUtil {
    private ResourceAliasUtil() {
    }

    public static String getRecommendedAlias(String aCandidateAlias, List<String> aAllAliasesList) {
        int index = ResourceAliasUtil.getLastAliasIndex(aCandidateAlias, aAllAliasesList);
        if (index < 0) {
            return aCandidateAlias;
        }
        return aCandidateAlias + '.' + ++index;
    }

    public static String getIndexedAlias(String aAliasPrefix, List<String> aAllAliasesList) {
        int index = ResourceAliasUtil.getLastAliasIndex(aAliasPrefix, aAllAliasesList);
        if (index <= 0) {
            index = 0;
        }
        return aAliasPrefix + '.' + ++index;
    }

    public static int getLastAliasIndex(String aAliasPrefix, List<String> aAllAliasesList) {
        int maxIndex = -1;
        for (String deviceAlias : aAllAliasesList) {
            maxIndex = Math.max(maxIndex, ResourceAliasUtil.getAutoAliasIndex(deviceAlias, aAliasPrefix));
        }
        return maxIndex;
    }

    private static int getAutoAliasIndex(String aAlias, String aAliasPrefix) {
        if (aAlias == null) {
            return -1;
        }
        if (!aAlias.startsWith(aAliasPrefix)) {
            return -1;
        }
        String indexStr = aAlias.substring(aAliasPrefix.length());
        int indexOfDot = indexStr.indexOf(46);
        if (indexStr.length() == 0) {
            return 0;
        }
        if (indexOfDot != 0 || indexOfDot == indexStr.length() - 1) {
            return -1;
        }
        indexStr = indexStr.substring(1);
        for (char c : indexStr.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return -1;
        }
        return Integer.parseInt(indexStr);
    }
}

