/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util.virtualization;

import com.sanrad.util.filter.SortKeyProvider;
import com.sanrad.util.filter.SrSortingMap;
import com.sanrad.util.virtualization.Allocable;
import com.sanrad.util.virtualization.CombinationGenerator;
import com.sanrad.util.virtualization.PermutationGenerator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AllocationUtil {
    private static final int NO_LIMITATION = -1;

    private AllocationUtil() {
    }

    public static <T extends Allocable> Map<T, BigInteger> getBiggestFirstAllocation(BigInteger aAlocationSize, List<T> aResources) {
        return AllocationUtil.getBiggestFirstAllocation(aAlocationSize, aResources, -1);
    }

    public static <T extends Allocable> Map<T, BigInteger> getBiggestFirstAllocation(BigInteger aAlocationSize, List<T> aResources, int aMaxResourcesToUse) {
        HashMap<Allocable, BigInteger> result = new HashMap<Allocable, BigInteger>();
        Comparator comparator = new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.getAllocationSpace().compareTo(o2.getAllocationSpace());
            }
        };
        ArrayList<T> resources = new ArrayList<T>(aResources);
        Collections.sort(resources, comparator);
        Collections.reverse(resources);
        BigInteger sizeLeftToAlloc = aAlocationSize;
        int remainingResourcesCount = aMaxResourcesToUse;
        for (Allocable biggestResourceLeft : resources) {
            if (sizeLeftToAlloc.longValue() <= 0L || BigInteger.ZERO.equals(biggestResourceLeft.getAllocationSpace())) break;
            BigInteger sizeToAlloc = sizeLeftToAlloc.min(biggestResourceLeft.getAllocationSpace());
            result.put(biggestResourceLeft, sizeToAlloc);
            if (aMaxResourcesToUse != -1) {
                --remainingResourcesCount;
            }
            sizeLeftToAlloc = sizeLeftToAlloc.subtract(sizeToAlloc);
        }
        if (sizeLeftToAlloc.longValue() > 0L) {
            return null;
        }
        return result;
    }

    public static <T extends Allocable> Map<T, BigInteger> getSimpleAllocation(BigInteger aAlocationSize, List<T> aResources) {
        return AllocationUtil.getSimpleAllocation(aAlocationSize, aResources, -1);
    }

    public static <T extends Allocable> Map<T, BigInteger> getSimpleAllocation(BigInteger aAlocationSize, List<T> aResources, int aMaxResourcesToUse) {
        HashMap<Allocable, BigInteger> result = new HashMap<Allocable, BigInteger>();
        BigInteger sizeLeftToAlloc = aAlocationSize;
        int remainingResourcesCount = aMaxResourcesToUse;
        for (Allocable allocable : aResources) {
            BigInteger resourceSize = allocable.getAllocationSpace();
            BigInteger sizeToAlloc = sizeLeftToAlloc.min(resourceSize);
            result.put(allocable, sizeToAlloc);
            if (aMaxResourcesToUse != -1) {
                --remainingResourcesCount;
            }
            if (!(sizeLeftToAlloc = sizeLeftToAlloc.subtract(sizeToAlloc)).equals(BigInteger.ZERO)) continue;
            break;
        }
        if (sizeLeftToAlloc.longValue() > 0L) {
            return null;
        }
        return result;
    }

    public static Map<Allocable, BigInteger> getBestFitAllocation(BigInteger aAlocationSize, List<? extends Allocable> aResources) {
        return AllocationUtil.getBestFitAllocation(aAlocationSize, aResources, -1);
    }

    public static Map<Allocable, BigInteger> getBestFitAllocation(BigInteger aAllocationSize, List<? extends Allocable> aResources, int aMaxResourcesToUse) {
        int maxResources = aMaxResourcesToUse == -1 ? aResources.size() : aMaxResourcesToUse;
        AllocationParams bestAllocParams = null;
        for (int numOfResources = 1; numOfResources <= maxResources; ++numOfResources) {
            CombinationGenerator combinations = new CombinationGenerator(maxResources, numOfResources);
            while (combinations.hasMore()) {
                int[] combinationIndices = combinations.getNext();
                ArrayList<Allocable> resourcesComb = new ArrayList<Allocable>();
                for (int combInx = 0; combInx < combinationIndices.length; ++combInx) {
                    resourcesComb.add(aResources.get(combinationIndices[combInx]));
                }
                if (AllocationUtil.getMaxSize(resourcesComb, aMaxResourcesToUse).compareTo(aAllocationSize) < 0) continue;
                PermutationGenerator permutations = new PermutationGenerator(numOfResources);
                while (permutations.hasMore()) {
                    int[] permutationIndices = permutations.getNext();
                    ArrayList<Allocable> resourcesPerm = new ArrayList<Allocable>();
                    for (int permInx = 0; permInx < permutationIndices.length; ++permInx) {
                        resourcesPerm.add(aResources.get(permutationIndices[permInx]));
                    }
                    Map<Allocable, BigInteger> alloc = AllocationUtil.getSimpleAllocation(aAllocationSize, resourcesPerm, aMaxResourcesToUse);
                    Allocable lastUsedResource = (Allocable)resourcesPerm.get(alloc.size() - 1);
                    BigInteger lastResourceAlloc = alloc.get(lastUsedResource);
                    BigInteger lastResourceSize = lastUsedResource.getAllocationSpace();
                    BigInteger currResidue = lastResourceSize.subtract(lastResourceAlloc);
                    AllocationParams currAllocParams = new AllocationParams(alloc, currResidue);
                    if (bestAllocParams == null || AllocationUtil.compareAllocation(currAllocParams, bestAllocParams) > 0) {
                        bestAllocParams = currAllocParams;
                    }
                    if (!BigInteger.ZERO.equals(bestAllocParams.getResidue()) || bestAllocParams.getResourcesCount() != 1) continue;
                    return bestAllocParams.getAllocation();
                }
            }
        }
        if (bestAllocParams == null) {
            return null;
        }
        return bestAllocParams.getAllocation();
    }

    private static int compareAllocation(AllocationParams aAlloc1, AllocationParams aAlloc2) {
        BigInteger alloc1Residue = aAlloc1.getResidue();
        BigInteger alloc2Residue = aAlloc2.getResidue();
        int residueComparison = alloc2Residue.compareTo(alloc1Residue);
        int resourceCountComparison = aAlloc2.getResourcesCount() - aAlloc1.getResourcesCount();
        if (residueComparison != 0) {
            return residueComparison;
        }
        if (resourceCountComparison != 0) {
            return resourceCountComparison;
        }
        return 0;
    }

    public static List<Map<Allocable, BigInteger>> getBestFitMultiAllocations(int aNumOfAllocations, BigInteger aSizeForAlocation, List<? extends Allocable> aResources) {
        return AllocationUtil.getBestFitMultiAllocations(aNumOfAllocations, aSizeForAlocation, aResources, -1);
    }

    public static List<Map<Allocable, BigInteger>> getBestFitMultiAllocations(int aNumOfAllocations, BigInteger aSizeForAlocation, List<? extends Allocable> aResources, int aMaxResourcesToUseForAllocation) {
        ArrayList<? extends Allocable> remainingResources = new ArrayList<Allocable>(aResources);
        ArrayList<Map<Allocable, BigInteger>> result = new ArrayList<Map<Allocable, BigInteger>>();
        for (int i = 0; i < aNumOfAllocations; ++i) {
            Map<Allocable, BigInteger> alloc = AllocationUtil.getBestFitAllocation(aSizeForAlocation, remainingResources, aMaxResourcesToUseForAllocation);
            if (alloc == null) {
                return null;
            }
            remainingResources.removeAll(alloc.keySet());
            result.add(alloc);
        }
        return result;
    }

    public static BigInteger getMaxSize(List<? extends Allocable> aResources) {
        return AllocationUtil.getMaxSize(aResources, -1);
    }

    public static BigInteger getMaxSize(List<? extends Allocable> aResources, int aMaxResourcesToUse) {
        if (aResources == null || aResources.size() == 0) {
            return BigInteger.ZERO;
        }
        BigInteger result = BigInteger.ZERO;
        List<AllocableResource> comparableResources = AllocationUtil.buildComparableList(aResources);
        Collections.sort(comparableResources);
        int remainingResourcesCount = aMaxResourcesToUse;
        int i = comparableResources.size();
        while (i-- > 0) {
            Allocable allocable = comparableResources.get(i);
            result = result.add(allocable.getAllocationSpace());
            if (aMaxResourcesToUse != -1) {
                --remainingResourcesCount;
            }
            if (remainingResourcesCount != 0) continue;
            break;
        }
        return result;
    }

    public static List<List<Allocable>> getMaxMirrorSizeSplitting(List<? extends Allocable> aResources) {
        BigInteger maxAlloc = null;
        ArrayList<Allocable> maxAllocResourcesList1 = null;
        ArrayList<? extends Allocable> maxAllocResourcesList2 = null;
        int halfOfCombinations = aResources.size() / 2;
        for (int numOfResources = 1; numOfResources <= halfOfCombinations; ++numOfResources) {
            CombinationGenerator combinations = new CombinationGenerator(aResources.size(), numOfResources);
            while (combinations.hasMore()) {
                int[] combinationIndices = combinations.getNext();
                ArrayList<Allocable> resourcesComb = new ArrayList<Allocable>();
                for (int combInx = 0; combInx < combinationIndices.length; ++combInx) {
                    resourcesComb.add(aResources.get(combinationIndices[combInx]));
                }
                ArrayList<? extends Allocable> complementaryComb = new ArrayList<Allocable>(aResources);
                complementaryComb.removeAll(resourcesComb);
                long combMaxAlloc = AllocationUtil.getMaxSize(resourcesComb).longValue();
                long complementaryMaxAlloc = AllocationUtil.getMaxSize(complementaryComb).longValue();
                long minOfMaxSizes = Math.min(combMaxAlloc, complementaryMaxAlloc);
                BigInteger currMaxAllocation = BigInteger.valueOf(minOfMaxSizes);
                if (maxAlloc != null && maxAlloc.compareTo(currMaxAllocation) >= 0) continue;
                maxAlloc = currMaxAllocation;
                maxAllocResourcesList1 = resourcesComb;
                maxAllocResourcesList2 = complementaryComb;
            }
        }
        if (maxAlloc != null) {
            ArrayList<List<Allocable>> result = new ArrayList<List<Allocable>>();
            result.add(maxAllocResourcesList1);
            result.add(maxAllocResourcesList2);
            return result;
        }
        return new ArrayList<List<Allocable>>();
    }

    public static BigInteger getMaxMirrorSize(List<? extends Allocable> aResources) {
        List<List<Allocable>> splits = AllocationUtil.getMaxMirrorSizeSplitting(aResources);
        BigInteger maxAlloc = null;
        for (List<Allocable> resources : splits) {
            BigInteger currMaxAllocation = AllocationUtil.getMaxSize(resources);
            if (maxAlloc != null && currMaxAllocation.compareTo(maxAlloc) >= 0) continue;
            maxAlloc = currMaxAllocation;
        }
        return maxAlloc != null ? maxAlloc : BigInteger.ZERO;
    }

    public static BigInteger getMaxMirrorSize(List<Allocable> aResources, SortKeyProvider<Object, Allocable> aSortBy) {
        SrSortingMap<Object, Allocable> map = new SrSortingMap<Object, Allocable>(aSortBy);
        map.putAll(aResources);
        BigInteger maxAlloc = null;
        for (Object key : map.keySet()) {
            List<Allocable> resourcesGroup = map.getGroup(key);
            BigInteger currMaxAlloc = AllocationUtil.getMaxMirrorSize(resourcesGroup);
            if (maxAlloc == null) {
                maxAlloc = currMaxAlloc;
                continue;
            }
            if (maxAlloc.compareTo(currMaxAlloc) >= 0) continue;
            maxAlloc = currMaxAlloc;
        }
        return maxAlloc != null ? maxAlloc : BigInteger.ZERO;
    }

    private static List<AllocableResource> buildComparableList(List<? extends Allocable> aAllocableList) {
        if (aAllocableList == null) {
            return null;
        }
        ArrayList<AllocableResource> listToReturn = new ArrayList<AllocableResource>();
        for (Allocable allocable : aAllocableList) {
            listToReturn.add(new AllocableResource(allocable));
        }
        return listToReturn;
    }

    public static <T extends Allocable> Map<T, BigInteger> filterAllocationBySize(Map<T, BigInteger> aMap, BigInteger aMinSize) {
        HashMap<T, BigInteger> retVal = new HashMap<T, BigInteger>();
        assert (aMap != null) : "The given map should not be null.";
        for (Map.Entry<T, BigInteger> entry : aMap.entrySet()) {
            if (entry.getValue().compareTo(aMinSize) < 0) continue;
            retVal.put(entry.getKey(), entry.getValue());
        }
        return retVal;
    }

    private static class AllocationParams {
        private Map<Allocable, BigInteger> allocation;
        private BigInteger residue;

        AllocationParams(Map<Allocable, BigInteger> aAllocation, BigInteger aResidue) {
            this.allocation = aAllocation;
            this.residue = aResidue;
        }

        public Map<Allocable, BigInteger> getAllocation() {
            return this.allocation;
        }

        public void setAllocation(Map<Allocable, BigInteger> allocation) {
            this.allocation = allocation;
        }

        public BigInteger getResidue() {
            return this.residue;
        }

        public void setResidue(BigInteger residue) {
            this.residue = residue;
        }

        public int getResourcesCount() {
            return this.allocation.size();
        }
    }

    private static class AllocableResource
    implements Comparable<AllocableResource>,
    Allocable {
        private Allocable myAllocable;
        private BigInteger myRemainingSize;

        AllocableResource(Allocable aAllocable) {
            this.myAllocable = aAllocable;
            this.myRemainingSize = aAllocable.getAllocationSpace();
        }

        void setSize(BigInteger aSize) {
            this.myRemainingSize = aSize;
        }

        @Override
        public int compareTo(AllocableResource aOther) {
            BigInteger otherSize = aOther.myRemainingSize;
            return this.myRemainingSize.compareTo(otherSize);
        }

        @Override
        public BigInteger getAllocationSpace() {
            return this.myRemainingSize;
        }

        public void subtract(BigInteger aSize) {
            this.myRemainingSize = this.myRemainingSize.subtract(aSize);
        }

        public Allocable getAllocable() {
            return this.myAllocable;
        }
    }
}

