/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util.virtualization;

import com.sanrad.util.virtualization.Allocable;
import com.sanrad.util.virtualization.AllocationUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AllocableGroup
implements Allocable {
    private ArrayList<Allocable> myResources = new ArrayList();

    public AllocableGroup() {
    }

    public AllocableGroup(Collection<? extends Allocable> aDisks) {
        this();
        if (aDisks == null) {
            throw new IllegalArgumentException("Disks collection must be supplied");
        }
        this.addAll(aDisks);
    }

    public void add(Allocable aAlloc) {
        if (aAlloc != null) {
            this.myResources.add(aAlloc);
        }
    }

    public void addAll(Collection<? extends Allocable> aAllocs) {
        for (Allocable allocable : aAllocs) {
            this.add(allocable);
        }
    }

    public List<Allocable> getResources() {
        return new ArrayList<Allocable>(this.myResources);
    }

    @Override
    public BigInteger getAllocationSpace() {
        return AllocationUtil.getMaxSize(this.myResources);
    }

    public <T extends Allocable> List<T> getAllDisks() {
        ArrayList result = new ArrayList();
        this.getAllDisksRecursive(this, result);
        return result;
    }

    private <T extends Allocable> void getAllDisksRecursive(AllocableGroup aGroup, List<T> aResult) {
        for (Allocable alloc : aGroup.getResources()) {
            if (alloc instanceof AllocableGroup) {
                this.getAllDisksRecursive((AllocableGroup)alloc, aResult);
                continue;
            }
            aResult.add(alloc);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AllocableGroup[");
        sb.append(this.myResources.toString());
        sb.append(']');
        return sb.toString();
    }

    public static <T extends Allocable> List<AllocableGroup> convertToGroupList(Collection<List<T>> aData) {
        ArrayList<AllocableGroup> list = new ArrayList<AllocableGroup>();
        for (List<T> allocList : aData) {
            list.add(new AllocableGroup(allocList));
        }
        return list;
    }
}

