/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util.filter;

import com.sanrad.util.filter.SrFilterRule;
import com.sanrad.util.filter.SrFilteredList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class SrFilteredArrayList<T>
implements SrFilteredList<T> {
    private List<T> myOriginalList;
    private List<T> myMatchedList = new ArrayList<T>();
    private List<T> myUnmatchedList = new ArrayList<T>();
    private static final long serialVersionUID = 8519469545742617307L;
    private List<SrFilterRule<T>> myFilterRules = new ArrayList<SrFilterRule<T>>();

    public SrFilteredArrayList() {
        this.myOriginalList = new ArrayList<T>();
    }

    public SrFilteredArrayList(List<T> aList) {
        this();
        if (aList != null) {
            this.addAll((Collection<T>)aList);
        }
    }

    public SrFilteredArrayList(List<T> aList, List<SrFilterRule<T>> aRules) {
        this(aList);
        if (aRules != null) {
            this.addRules(aRules);
        }
    }

    public SrFilteredArrayList(List<T> aList, SrFilterRule<T> ... aRules) {
        this(aList, Arrays.asList(aRules));
    }

    @Override
    public final boolean applyFilter(T t) {
        for (SrFilterRule currentRule : this.getAllRules()) {
            if (currentRule.isValid(t, this)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addRule(SrFilterRule<T> aRule) {
        if (aRule == null) {
            assert (false) : "The given rule should not be null";
            return false;
        }
        if (this.myFilterRules.contains(aRule)) {
            return false;
        }
        if (!this.myFilterRules.add(aRule)) {
            return false;
        }
        ArrayList<T> tmpList = new ArrayList<T>(this.myMatchedList);
        for (T obj : tmpList) {
            if (this.applyFilter(obj)) continue;
            this.moveObject(this.myMatchedList, this.myUnmatchedList, obj, aRule);
        }
        this.registerToRule(aRule);
        return true;
    }

    public boolean addRules(List<SrFilterRule<T>> aRules) {
        if (aRules == null) {
            assert (false) : "The given rules should not be null";
            return false;
        }
        boolean retVal = true;
        for (SrFilterRule<T> currentRule : aRules) {
            if (this.addRule(currentRule)) continue;
            retVal = false;
        }
        return retVal;
    }

    @Override
    public boolean removeRule(SrFilterRule<T> aRule) {
        if (aRule == null) {
            assert (false) : "The given rule should not be null";
            return false;
        }
        if (!this.myFilterRules.contains(aRule)) {
            return false;
        }
        if (!this.myFilterRules.remove(aRule)) {
            return false;
        }
        ArrayList<T> tmpList = new ArrayList<T>(this.myUnmatchedList);
        for (T obj : tmpList) {
            if (!this.applyFilter(obj)) continue;
            this.moveObject(this.myUnmatchedList, this.myMatchedList, obj, aRule);
        }
        this.unregisterFromRule(aRule);
        return true;
    }

    private void moveObject(List<T> aSrc, List<T> aDst, T aObj, SrFilterRule<T> aRule) {
        if (!aSrc.remove(aObj)) {
            throw new IllegalStateException("Could not remove the object " + aObj + " from the source list: " + aSrc + " after the rule " + aRule + " has been added.");
        }
        if (!aDst.add(aObj)) {
            throw new IllegalStateException("Could not add the object " + aObj + " to the destination list: " + aDst + ", after the rule " + aRule + " has been removed.");
        }
    }

    public boolean removeRules(List<SrFilterRule<T>> aRules) {
        if (aRules == null) {
            assert (false) : "The given rules should not be null";
            return false;
        }
        boolean retVal = true;
        for (SrFilterRule<T> currentRule : aRules) {
            if (this.removeRule(currentRule)) continue;
            retVal = false;
        }
        return retVal;
    }

    @Override
    public boolean removeAllRules() {
        return this.removeRules(this.myFilterRules);
    }

    @Override
    public boolean add(T aObj) {
        boolean retVal = true;
        boolean filterResult = this.applyFilter(aObj);
        if (filterResult) {
            if (!this.myMatchedList.add(aObj)) {
                throw new IllegalStateException("The new Object " + aObj + "failed to added to matched list");
            }
            retVal = true;
        } else {
            if (!this.myUnmatchedList.add(aObj)) {
                throw new IllegalStateException("The new Object " + aObj + "failed to added to unmatched list");
            }
            retVal = false;
        }
        if (!this.myOriginalList.add(aObj)) {
            String listName = filterResult ? "matched" : "unmatched";
            throw new IllegalStateException("The object " + aObj + " was added to the " + listName + " list, but could not be added to the original list.");
        }
        return retVal;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (c == null) {
            assert (false) : "The given collection should not be null";
            return false;
        }
        boolean isChanged = false;
        ArrayList<T> newCollection = new ArrayList<T>(c);
        for (Object t : newCollection) {
            if (!this.add((T)t)) continue;
            isChanged = true;
        }
        return isChanged;
    }

    @Override
    public void add(int index, T element) {
        boolean filter = this.applyFilter(element);
        if (filter ? !this.myMatchedList.add(element) : !this.myUnmatchedList.add(element)) {
            return;
        }
        this.myOriginalList.add(index, element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        if (c == null) {
            assert (false) : "The given collection should not be null";
            return false;
        }
        int originalSize = this.size();
        int curIndex = index;
        ArrayList<T> newCollection = new ArrayList<T>(c);
        for (Object t : newCollection) {
            this.add(curIndex++, (T)t);
        }
        return originalSize == this.size();
    }

    @Override
    public void clear() {
        this.clearOfMatched();
        this.clearOfUnmatched();
        this.myOriginalList.clear();
    }

    @Override
    public void clearOfMatched() {
        this.removeAll(new ArrayList<T>(this.myMatchedList));
    }

    @Override
    public void clearOfUnmatched() {
        this.removeAll(new ArrayList<T>(this.myUnmatchedList));
    }

    @Override
    public boolean contains(Object o) {
        if (!this.myMatchedList.contains(o) && !this.myUnmatchedList.contains(o)) {
            if (this.myOriginalList.contains(o)) {
                throw new IllegalStateException("The object " + o + " is not contained in the matched and " + "the unmatched lists, but is contained in the original list.");
            }
            return false;
        }
        if (!this.myOriginalList.contains(o)) {
            throw new IllegalStateException("The object " + o + " is not contained in the original list, but is contained " + "in one of the matched or unmatched lists.");
        }
        return true;
    }

    @Override
    public boolean containsOfMatched(Object o) {
        if (!this.contains(o)) {
            return false;
        }
        return this.myMatchedList.contains(o);
    }

    @Override
    public boolean containsOfUnmatched(Object o) {
        if (!this.contains(o)) {
            return false;
        }
        return this.myUnmatchedList.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c == null) {
            assert (false) : "The given collection should not be null";
            return false;
        }
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public T get(int index) {
        return this.myOriginalList.get(index);
    }

    @Override
    public T getOfMatched(int index) {
        return this.myMatchedList.get(index);
    }

    @Override
    public T getOfUnmatched(int index) {
        return this.myUnmatchedList.get(index);
    }

    public List<T> getAll() {
        return new ArrayList<T>(this.myOriginalList);
    }

    public List<T> getAllOfMatched() {
        return new ArrayList<T>(this.myMatchedList);
    }

    public List<T> getAllOfUnMatched() {
        return new ArrayList<T>(this.myUnmatchedList);
    }

    @Override
    public int indexOf(Object o) {
        return this.myOriginalList.indexOf(o);
    }

    @Override
    public int indexOfMatched(Object o) {
        return this.myMatchedList.indexOf(o);
    }

    @Override
    public int indexOfUnmatched(Object o) {
        return this.myUnmatchedList.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.myOriginalList.isEmpty();
    }

    @Override
    public boolean isEmptyOfMatched() {
        return this.myMatchedList.isEmpty();
    }

    @Override
    public boolean isEmptyOfUnmatched() {
        return this.myUnmatchedList.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.myOriginalList.iterator();
    }

    @Override
    public Iterator<T> iteratorOfMatched() {
        return this.myMatchedList.iterator();
    }

    @Override
    public Iterator<T> iteratorOfUnmatched() {
        return this.myUnmatchedList.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.myOriginalList.lastIndexOf(o);
    }

    @Override
    public int lastIndexOfMatched(Object o) {
        return this.myMatchedList.lastIndexOf(o);
    }

    @Override
    public int lastIndexOfUnmatched(Object o) {
        return this.myUnmatchedList.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.myOriginalList.listIterator();
    }

    @Override
    public ListIterator<T> listIteratorOfMatched() {
        return this.myMatchedList.listIterator();
    }

    @Override
    public ListIterator<T> listIteratorOfUnmatched() {
        return this.myUnmatchedList.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.myOriginalList.listIterator(index);
    }

    @Override
    public ListIterator<T> listIteratorOfMatched(int index) {
        return this.myMatchedList.listIterator(index);
    }

    @Override
    public ListIterator<T> listIteratorOfUnmatched(int index) {
        return this.myUnmatchedList.listIterator(index);
    }

    @Override
    public boolean remove(Object o) {
        if (!this.myMatchedList.remove(o) && !this.myUnmatchedList.remove(o)) {
            return false;
        }
        if (!this.myOriginalList.remove(o)) {
            throw new IllegalStateException("Could not remove the object " + o + " from the original list, even though it was removed from the " + "matched/unmatched list");
        }
        return true;
    }

    @Override
    public T remove(int index) {
        T theObj = this.myOriginalList.remove(index);
        if (!this.myMatchedList.remove(theObj) && !this.myUnmatchedList.remove(theObj)) {
            throw new IllegalStateException("Could not remove the index " + index + " from the matched/unmatched list, even though it was removed " + "from the original list");
        }
        return theObj;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c == null) {
            assert (false) : "The given collection should not be null";
            return false;
        }
        boolean isChanged = false;
        ArrayList newCollection = new ArrayList(c);
        for (Object obj : newCollection) {
            if (!this.remove(obj)) continue;
            isChanged = true;
        }
        return isChanged;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c == null) {
            assert (false) : "The given collection should not be null";
            return false;
        }
        boolean isChanged = false;
        ArrayList newCollection = new ArrayList(c);
        for (Object obj : newCollection) {
            if (!this.myOriginalList.contains(obj) || !this.remove(obj)) continue;
            isChanged = true;
        }
        return isChanged;
    }

    @Override
    public T set(int index, T element) {
        T t = this.remove(index);
        this.add(index, element);
        return t;
    }

    @Override
    public int size() {
        return this.myOriginalList.size();
    }

    @Override
    public int sizeOfMatched() {
        return this.myMatchedList.size();
    }

    @Override
    public int sizeOfUnmatched() {
        return this.myUnmatchedList.size();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.myOriginalList.subList(fromIndex, toIndex);
    }

    @Override
    public List<T> subListOfMatched(int fromIndex, int toIndex) {
        return this.myMatchedList.subList(fromIndex, toIndex);
    }

    @Override
    public List<T> subListOfUnmatched(int fromIndex, int toIndex) {
        return this.myUnmatchedList.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.myOriginalList.toArray();
    }

    @Override
    public Object[] toArrayOfMatched() {
        return this.myMatchedList.toArray();
    }

    @Override
    public Object[] toArrayOfUnmatched() {
        return this.myUnmatchedList.toArray();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return this.myOriginalList.toArray(a);
    }

    @Override
    public <E> E[] toArrayOfMatched(E[] a) {
        return this.myMatchedList.toArray(a);
    }

    @Override
    public <E> E[] toArrayOfUnmatched(E[] a) {
        return this.myUnmatchedList.toArray(a);
    }

    public String toString() {
        return "[Matched] " + this.toStringOfMatched() + "; [Unmatched] " + this.toStringOfUnmatched();
    }

    public String toStringOfMatched() {
        return this.myMatchedList.toString();
    }

    public String toStringOfUnmatched() {
        return this.myUnmatchedList.toString();
    }

    @Override
    public List<SrFilterRule<T>> getAllRules() {
        return new ArrayList<SrFilterRule<T>>(this.myFilterRules);
    }

    public void refresh() {
        ArrayList<T> oldElements = new ArrayList<T>(this.getAll());
        this.clear();
        this.addAll((Collection<? extends T>)oldElements);
    }

    public SrFilteredArrayList<T> clone() {
        SrFilteredArrayList<T> retList = new SrFilteredArrayList<T>();
        retList.myOriginalList.addAll(this.getAll());
        retList.myMatchedList.addAll(this.getAllOfMatched());
        retList.myUnmatchedList.addAll(this.getAllOfUnMatched());
        retList.myFilterRules.addAll(this.getAllRules());
        return retList;
    }

    @Override
    public void notifyRuleChanged(SrFilterRule<T> rule) {
        this.refresh();
    }

    private boolean registerToRule(SrFilterRule<T> rule) {
        return rule.addListener(this);
    }

    private boolean unregisterFromRule(SrFilterRule<T> rule) {
        return rule.removeListener(this);
    }
}

