/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util.filter;

import com.sanrad.util.filter.SortKeyProvider;
import java.util.ArrayList;
import java.util.List;

public class CompoundSortAttribute<K, T>
implements SortKeyProvider<List<K>, T> {
    private SortKeyProvider<K, T>[] mySorters;

    public CompoundSortAttribute(SortKeyProvider<K, T> ... aSorters) {
        if (aSorters == null) {
            throw new IllegalArgumentException("Sorters must be supplied");
        }
        this.mySorters = aSorters;
    }

    @Override
    public List<K> getSortBy(T aValue) {
        ArrayList<K> sortObjs = new ArrayList<K>();
        for (SortKeyProvider<K, T> sorter : this.mySorters) {
            sortObjs.add(sorter.getSortBy(aValue));
        }
        return sortObjs;
    }
}

