/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util.concurrent;

import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.SrResourceBundle;
import com.sanrad.util.concurrent.SrTask;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Locale;

public class SrScheduleComparator
implements Comparator<Runnable> {
    private static final long theDefaultTimeToPriorityParameter;
    private long myTimeToPriorityParameter;

    public SrScheduleComparator() {
        this.myTimeToPriorityParameter = theDefaultTimeToPriorityParameter;
    }

    public SrScheduleComparator(long aTimeToPriorityParameter) {
        this.myTimeToPriorityParameter = aTimeToPriorityParameter;
    }

    @Override
    public int compare(Runnable aTask1, Runnable aTask2) {
        long priority2;
        if (aTask1 == null) {
            throw new IllegalArgumentException("aTask1 cannot be null");
        }
        if (aTask2 == null) {
            throw new IllegalArgumentException("aTask2 cannot be null");
        }
        if (!(aTask1 instanceof SrTask) || !(aTask2 instanceof SrTask)) {
            if (!(aTask1 instanceof SrTask) && aTask2 instanceof SrTask) {
                return -1;
            }
            if (!(aTask2 instanceof SrTask) && aTask1 instanceof SrTask) {
                return 1;
            }
            return aTask1.toString().compareTo(aTask2.toString());
        }
        SrTask task1 = (SrTask)aTask1;
        SrTask task2 = (SrTask)aTask2;
        long priority1 = task1.getPriority().getValue();
        if (priority1 > (priority2 = (long)task2.getPriority().getValue())) {
            return -1;
        }
        if (priority1 < priority2) {
            return 1;
        }
        BigInteger index1 = task1.getMyIndex();
        BigInteger index2 = task2.getMyIndex();
        return index1.compareTo(index2);
    }

    static {
        SrResourceBundle consts = SrResourceBundle.getInstance("constants", Locale.US);
        theDefaultTimeToPriorityParameter = consts.getIntResource(SrConstantsBundleKeys.STARVATION_PRIORITY_RATE_MILLIS);
    }
}

