/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util.concurrent;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.SrExecutionException;
import com.sanrad.util.concurrent.SrFuture;
import com.sanrad.util.concurrent.SrScheduleComparator;
import com.sanrad.util.concurrent.SrTask;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SrActiveObject {
    private BigInteger myNextTaskIndex = BigInteger.ONE;
    private static final long EXECUTION_START_MAX_DELAY = 120000L;
    private static final long EXECUTION_END_LOW_DELAY = 60000L;
    private static final long EXECUTION_END_MAX_DELAY = 240000L;
    private static final long FUTURE_COMPLETEION_CHECK_DELAY = 60000L;
    private static final int theExecutorCoreSize = 1;
    private static final int theExecutorMaxCoreSize = 1;
    private static final TimeUnit theTimeUnit = TimeUnit.MILLISECONDS;
    private static final int theSchedulerCoreSize = 1;
    private ScheduledThreadPoolExecutor myScheduler;
    private ThreadPoolExecutor myExecutor;
    private Set<SrFuture> myFutures = new HashSet<SrFuture>();
    private static SrLogger theLogger = null;

    public static <T> Void updateFutureByGivenFuture(SrFuture<T> aSourceFuture, SrFuture<T> aTargetFuture) {
        if (aSourceFuture == null || aTargetFuture == null) {
            String msg = "The given parameters should not be null. aSourceFuture = " + aSourceFuture + "; aTargetFuture = )" + aTargetFuture;
            theLogger.logAndAssert(SrLogCategories.ERROR, msg);
            throw new IllegalArgumentException(msg);
        }
        try {
            if (!aSourceFuture.isDone()) {
                theLogger.fatal(SrLogCategories.SYSTEM, "The future ", aSourceFuture, ", which has the stack trace: ", aSourceFuture.getStackTraceString(), " has been given to the update future by given future before ", "it has been updated. The stack trace is: ", Thread.currentThread().getStackTrace());
            }
            T val = aSourceFuture.get();
            aTargetFuture.set(val);
        }
        catch (ExecutionException e) {
            aTargetFuture.setException(e);
        }
        catch (InterruptedException e) {
            aTargetFuture.setException(e);
        }
        return null;
    }

    public static Void updateFutureByGivenFutures(List<SrFuture<Void>> aSourceFuture, SrFuture<Void> aTargetFuture) {
        SrActiveObject.updateFutureByGivenFutures(aSourceFuture, aTargetFuture, null);
        return null;
    }

    public static <T> Void updateFutureByGivenFutures(List<SrFuture<T>> aSourceFuture, SrFuture<T> aTargetFuture, T aDefaultVal) {
        if (aSourceFuture == null || aTargetFuture == null) {
            String msg = "The given parameters should not be null. aSourceFuture = " + aSourceFuture + "; aTargetFuture = )" + aTargetFuture;
            theLogger.logAndAssert(SrLogCategories.ERROR, msg);
            throw new IllegalArgumentException(msg);
        }
        if (aSourceFuture.isEmpty()) {
            aTargetFuture.set(aDefaultVal);
            return null;
        }
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        for (SrFuture<T> curFuture : aSourceFuture) {
            try {
                curFuture.get();
            }
            catch (ExecutionException exp) {
                exceptions.add(exp);
            }
            catch (InterruptedException exp) {
                exceptions.add(exp);
            }
        }
        if (exceptions.size() > 0) {
            SrExecutionException expt = new SrExecutionException(exceptions);
            aTargetFuture.setException(expt);
        } else {
            try {
                SrFuture<T> retFuture = aSourceFuture.get(0);
                if (retFuture == null) {
                    aTargetFuture.set(aDefaultVal);
                } else {
                    aTargetFuture.set(retFuture.get());
                }
            }
            catch (InterruptedException exp) {
                theLogger.logAndAssert(SrLogCategories.ERROR, "An exception was returned from the get although it was not returned from a previous get call.");
            }
            catch (ExecutionException exp) {
                theLogger.logAndAssert(SrLogCategories.ERROR, "An exception was returned from the get although it was not returned from a previous get call.");
            }
        }
        return null;
    }

    public SrActiveObject(String aName) {
        this(aName, new SrScheduleComparator());
    }

    public SrActiveObject(String aName, Comparator<? super Runnable> aComparator) {
        if (aComparator == null) {
            throw new IllegalArgumentException("aComparator argument is null");
        }
        this.myScheduler = new ScheduledThreadPoolExecutor(1);
        this.myScheduler.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this.myScheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
        this.myExecutor = new ThreadPoolExecutor(1, 1, this.myScheduler.getKeepAliveTime(theTimeUnit), theTimeUnit, queue);
        this.setName(aName);
    }

    public <T> SrFuture<T> submit(SrTask<T> aTask) {
        if (aTask == null) {
            throw new IllegalArgumentException("aTask argument is null");
        }
        SrFuture retFuture = new SrFuture(aTask.getDescription());
        retFuture.initSchedulingTimeStamp(0L);
        aTask.setFuture(retFuture);
        Future<?> future = this.myExecutor.submit(aTask);
        retFuture.setExecutionFuture(future);
        return retFuture;
    }

    public <T> SrFuture<T> schedule(SrTask<T> aTask, long aDelay) {
        if (aTask == null) {
            throw new IllegalArgumentException("aTask argument is null");
        }
        SrFuture retFuture = new SrFuture(aTask.getDescription());
        retFuture.initSchedulingTimeStamp(aDelay);
        aTask.setFuture(retFuture);
        SchedulingTask<T> sTask = new SchedulingTask<T>(aTask);
        ScheduledFuture<?> future = this.myScheduler.schedule(sTask, aDelay, theTimeUnit);
        retFuture.setExecutionFuture(future);
        this.addToWaitingFutureList(retFuture);
        return retFuture;
    }

    public void setName(final String aName) {
        this.myExecutor.submit(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName(aName + "Executor");
            }
        });
        this.myScheduler.submit(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName(aName + "Scheduler");
            }
        });
    }

    private void scheduleFutureCompletionCheck() {
        this.schedule(new ScheduleFutureCompletionCheckTask(), 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToWaitingFutureList(final SrFuture<?> aFuture) {
        Set<SrFuture> set = this.myFutures;
        synchronized (set) {
            this.myFutures.add(aFuture);
        }
        Runnable run = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Set set = SrActiveObject.this.myFutures;
                synchronized (set) {
                    SrActiveObject.this.myFutures.remove(aFuture);
                }
            }
        };
        DefaultFutureListener.listenTo(run, aFuture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow() {
        HashSet<SrFuture> clonedSet;
        this.myExecutor.shutdownNow();
        this.myScheduler.shutdownNow();
        Set<SrFuture> set = this.myFutures;
        synchronized (set) {
            clonedSet = new HashSet<SrFuture>(this.myFutures);
        }
        for (SrFuture future : clonedSet) {
            future.cancel(false);
        }
    }

    public boolean isShutdown() {
        return this.myExecutor.isShutdown() || this.myScheduler.isShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigInteger getAndIncrementNextTaskIndex() {
        BigInteger retVal = null;
        BigInteger bigInteger = this.myNextTaskIndex;
        synchronized (bigInteger) {
            retVal = this.myNextTaskIndex;
            this.myNextTaskIndex = this.myNextTaskIndex.add(BigInteger.ONE);
        }
        return retVal;
    }

    static {
        theLogger = SrLogger.getLogger();
    }

    private class SchedulingTask<T>
    implements Runnable {
        private SrTask<T> myTask;

        SchedulingTask(SrTask<T> aTask) {
            this.myTask = aTask;
        }

        @Override
        public void run() {
            SrActiveObject.this.myExecutor.execute(this.myTask);
        }
    }

    private class ScheduleFutureCompletionCheckTask
    extends SrTask<Void> {
        ScheduleFutureCompletionCheckTask() {
            super("scheduleFutureCompletionCheckTask", SrActiveObject.this.getAndIncrementNextTaskIndex());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void execute(SrFuture<Void> aFuture) throws Exception {
            HashSet clonedSet;
            Set set = SrActiveObject.this.myFutures;
            synchronized (set) {
                clonedSet = new HashSet(SrActiveObject.this.myFutures);
            }
            for (SrFuture future : clonedSet) {
                if (future.getStartTime() == 0L && System.currentTimeMillis() - future.getExpectedExecutionTime() > 120000L) {
                    theLogger.warn(SrLogCategories.INFORMATIVE, "the Future (" + future.getID() + ")'" + future.getDescription() + "' hasn't started for " + 120000L + ".");
                }
                if (!future.isDone() && future.getStartTime() != 0L && System.currentTimeMillis() - future.getStartTime() > 240000L) {
                    theLogger.error(SrLogCategories.ERROR, "FUTURE NOT DONE. The Future (" + future.getID() + ")'" + future.getDescription() + "' is not done for " + 240000L + ".");
                    continue;
                }
                if (future.isDone() || future.getStartTime() == 0L || System.currentTimeMillis() - future.getStartTime() <= 60000L) continue;
                theLogger.warn(SrLogCategories.INFORMATIVE, "FUTURE NOT DONE. The Future (" + future.getID() + ")'" + future.getDescription() + "' is not done for " + 60000L + ".");
            }
            SrActiveObject.this.scheduleFutureCompletionCheck();
            aFuture.set(null);
        }
    }
}

