/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.database.exception.SrDatabaseException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class XmlFileUtil {
    private static SrLogger theLogger = SrLogger.getLogger();

    public static Document readXMLFile(String aFileName) throws FileNotFoundException, JDOMException {
        File namedFile = new File(aFileName);
        if (!namedFile.exists()) {
            return null;
        }
        FileInputStream fileInStream = null;
        fileInStream = new FileInputStream(aFileName);
        SAXBuilder builder = new SAXBuilder();
        return builder.build((InputStream)fileInStream);
    }

    public static void writeXMLFile(String aFileName, Document aDoc) throws SrDatabaseException {
        if (aFileName == null || aDoc == null) {
            throw new IllegalArgumentException("The given arguments can not be null. aFileName = " + aFileName + "; aDoc = " + aDoc);
        }
        FileOutputStream fileOutStream = null;
        try {
            fileOutStream = new FileOutputStream(aFileName);
        }
        catch (FileNotFoundException exp1) {
            theLogger.error(SrLogCategories.EXCEPTION, exp1, "Could not create the file ", aFileName);
            throw new SrDatabaseException("Failed to open file " + aFileName, exp1);
        }
        XMLOutputter xmlFile = new XMLOutputter("\t", true);
        try {
            xmlFile.output(aDoc, (OutputStream)fileOutStream);
        }
        catch (IOException exp1) {
            theLogger.error(SrLogCategories.EXCEPTION, exp1, "Could not write to the file ", aFileName);
            throw new SrDatabaseException("Failed to write to file " + aFileName, exp1);
        }
        try {
            fileOutStream.flush();
            fileOutStream.close();
        }
        catch (IOException exp) {
            theLogger.error(SrLogCategories.EXCEPTION, exp, "Could not close the file ", aFileName);
        }
    }
}

