/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util;

import com.sanrad.util.Constants;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;

public class StorageSize {
    private String myValue;
    private String myExtension;
    public static final StorageSize MEGA = new StorageSize(Constants.MEGA_BYTES, "MB");
    public static final StorageSize GIGA = new StorageSize(Constants.GIGA_BYTES, "GB");
    public static final StorageSize TERA = new StorageSize(Constants.TERA_BYTES, "TB");
    public static final StorageSize KILO = new StorageSize(Constants.KILO_BYTES, "KB");
    public static final StorageSize BYTE = new StorageSize(1.0, "Bytes");

    private StorageSize(double aValue, String aExtension) {
        Double doubleValue = new Double(aValue);
        this.myValue = Long.toString(doubleValue.longValue());
        this.myExtension = aExtension;
    }

    public BigInteger getValue() {
        return new BigInteger(this.myValue);
    }

    public BigDecimal getDecimalValue() {
        return new BigDecimal(this.myValue);
    }

    public static String getSizeAsString(BigInteger aSize) {
        if (aSize == null) {
            return "0";
        }
        return StorageSize.getSizeAsString(new BigDecimal(aSize));
    }

    public static String getSizeAsString(BigDecimal aDecimalSize) {
        if (aDecimalSize == null || aDecimalSize.compareTo(BigDecimal.ZERO) == 0) {
            return "0";
        }
        StorageSize[] arr = new StorageSize[]{TERA, GIGA, MEGA, KILO, BYTE};
        for (int i = 0; i < arr.length; ++i) {
            BigDecimal temp = new BigDecimal(arr[i].getValue());
            if ((temp = aDecimalSize.divide(temp, 200, 7)).longValue() <= 0L) continue;
            try {
                StringBuffer sb = new StringBuffer();
                DecimalFormat format = new DecimalFormat("###.##");
                double doubleValue = new Double(temp.toString());
                sb.append(format.format(doubleValue));
                sb.append(" ");
                sb.append(arr[i].toString());
                return sb.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                return temp.toString();
            }
        }
        return null;
    }

    public String toString() {
        return this.myExtension;
    }
}

