/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util;

import com.sanrad.util.Queue;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class SrThreadPool {
    private static final int DEFAULT_POOL_SIZE = 10;
    private static final String DEFAULT_POOL_NAME = "SrThreadPool";
    private QueueThread[] m_workers;
    private DelayedTasksManager m_delayedTasksManager = new DelayedTasksManager();

    public SrThreadPool(int poolSize, String poolName) {
        if (poolSize <= 0) {
            throw new IllegalArgumentException("Non-positive pool size value");
        }
        if (poolName == null) {
            throw new IllegalArgumentException("No pool name value");
        }
        this.m_workers = new QueueThread[poolSize];
        int i = this.m_workers.length;
        while (i-- > 0) {
            this.m_workers[i] = new QueueThread(poolName + String.valueOf(i));
            this.m_workers[i].start();
        }
        this.m_delayedTasksManager.start();
    }

    public SrThreadPool() {
        this(10, DEFAULT_POOL_NAME);
    }

    public void addTask(Runnable task) {
        this.getLeastOccupied().addTask(task);
    }

    public void addTask(Runnable task, int delay) {
        if (delay < 0) {
            throw new IllegalArgumentException("Non-positive delay value");
        }
        if (delay > 0) {
            this.m_delayedTasksManager.addDelayedTask(System.currentTimeMillis() + (long)delay, task);
        } else {
            this.getLeastOccupied().addTask(task);
        }
    }

    private QueueThread getLeastOccupied() {
        QueueThread minTaskThread = this.m_workers[0];
        for (int i = 1; i < this.m_workers.length; ++i) {
            if (this.m_workers[i].taskCount() >= minTaskThread.taskCount()) continue;
            minTaskThread = this.m_workers[i];
        }
        return minTaskThread;
    }

    public static void main(String[] args) throws InterruptedException {
        SrThreadPool ao = new SrThreadPool();
        ao.addTask(new PrintTask(2), 2000);
        ao.addTask(new PrintTask(7), 7000);
        Thread.sleep(10L);
        ao.addTask(new PrintTask(10), 10000);
        ao.addTask(new PrintTask(4), 4000);
        Thread.sleep(10L);
        ao.addTask(new PrintTask(5), 5000);
        ao.addTask(new PrintTask(6), 6000);
        ao.addTask(new PrintTask(3), 3000);
        ao.addTask(new PrintTask(1), 1000);
        Thread.sleep(10L);
        ao.addTask(new PrintTask(7), 7000);
        ao.addTask(new PrintTask(1), 1000);
    }

    static class PrintTask
    implements Runnable {
        int delay;

        public PrintTask(int delay) {
            this.delay = delay;
        }

        @Override
        public void run() {
            System.out.println("Delay is " + this.delay + " sec.");
        }
    }

    private class DelayedTasksManager
    extends Thread {
        Object qLock = new Object();
        TreeMap<Long, List<Runnable>> taskSortedMap = new TreeMap();

        private DelayedTasksManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addDelayedTask(long executeTime, Runnable task) {
            Object object = this.qLock;
            synchronized (object) {
                Long exeKey = new Long(executeTime);
                List<Runnable> listOfSameTimeTasks = this.taskSortedMap.get(exeKey);
                if (listOfSameTimeTasks == null) {
                    listOfSameTimeTasks = new ArrayList<Runnable>();
                    this.taskSortedMap.put(exeKey, listOfSameTimeTasks);
                }
                listOfSameTimeTasks.add(task);
                this.qLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            long timeToWait = 0L;
            while (true) {
                try {
                    while (true) {
                        Object object = this.qLock;
                        synchronized (object) {
                            long currTime = System.currentTimeMillis();
                            if (!this.taskSortedMap.isEmpty()) {
                                Long nextExecutionTime = this.taskSortedMap.firstKey();
                                timeToWait = nextExecutionTime - currTime;
                                if (timeToWait > 0L) {
                                    this.qLock.wait(timeToWait);
                                } else {
                                    List<Runnable> listOfSameTimeTasks = this.taskSortedMap.remove(nextExecutionTime);
                                    for (Runnable task : listOfSameTimeTasks) {
                                        SrThreadPool.this.addTask(task);
                                    }
                                }
                            } else {
                                this.qLock.wait();
                            }
                        }
                    }
                }
                catch (Throwable th) {
                    th.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    private class QueueThread
    extends Thread {
        Queue<Runnable> taskQueue;

        public QueueThread(String name) {
            super(name);
            this.taskQueue = new Queue();
        }

        @Override
        public void run() {
            while (true) {
                Runnable task = this.taskQueue.removeHead();
                try {
                    task.run();
                    continue;
                }
                catch (Throwable th) {
                    th.printStackTrace();
                    continue;
                }
                break;
            }
        }

        public int taskCount() {
            return this.taskQueue.size();
        }

        public void addTask(Runnable task) {
            this.taskQueue.addElement(task);
        }
    }
}

