/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util;

import com.sanrad.log.SrLogger;
import com.sanrad.util.filter.SrFilterDynamicRule;
import com.sanrad.util.filter.SrFilterSimpleRule;
import com.sanrad.util.filter.SrFilteredArrayList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.Semaphore;
import junit.framework.Assert;
import junit.framework.TestCase;

public class SrFilteredArrayListTest
extends TestCase {
    private static final Semaphore theLock = new Semaphore(1);
    private static SrLogger theLogger = null;
    private static final String CONF_FILE = "config" + File.separator + "log.properties";
    private static Properties logProps = new Properties();
    private final int MAX_NUMBERS_IN_LIST = 10;
    private List<Integer> mySrcList = new ArrayList<Integer>();
    private static Random myGenerator = new Random();

    protected void setUp() throws Exception {
        super.setUp();
        for (int i = 0; i < 10; ++i) {
            this.mySrcList.add(i);
        }
        try {
            theLock.acquire();
        }
        catch (InterruptedException exp) {
            SrFilteredArrayListTest.fail((String)"Could not acquire the lock in order to run the test.");
        }
    }

    protected void tearDown() throws Exception {
        this.mySrcList.clear();
        theLock.release();
        super.tearDown();
    }

    public void testListCreation() {
        SrFilteredArrayList<Object> fltList = new SrFilteredArrayList();
        SrFilteredArrayListTest.assertTrue((String)"The Original Filtered List suppose to be Empty but it is not", (boolean)fltList.getAll().isEmpty());
        SrFilteredArrayListTest.assertTrue((String)"The Matched Filtered List suppose to be Empty but it is not", (boolean)fltList.getAllOfMatched().isEmpty());
        SrFilteredArrayListTest.assertTrue((String)"The Unmatched Filtered List suppose to be Empty but it is not", (boolean)fltList.getAllOfUnMatched().isEmpty());
        fltList = new SrFilteredArrayList<Integer>(this.mySrcList);
        SrFilteredArrayListTest.assertTrue((String)"The Original Filtered List is different from the Source List", (boolean)((Object)fltList.getAll()).equals(this.mySrcList));
        SrFilteredArrayListTest.assertTrue((String)"The Matched Filtered List is different from the Source List", (boolean)((Object)fltList.getAllOfMatched()).equals(this.mySrcList));
        SrFilteredArrayListTest.assertTrue((String)"The Unmatch Filtered List is not empty as it suppose to be", (boolean)fltList.getAllOfUnMatched().isEmpty());
        SrFilterSimpleRule<Integer> defaultRule1 = new SrFilterSimpleRule<Integer>(){

            @Override
            public boolean isValid(Integer newObject, Object ... aParams) {
                return false;
            }
        };
        SrFilterSimpleRule<Integer> defaultRule2 = new SrFilterSimpleRule<Integer>(){

            @Override
            public boolean isValid(Integer newObject, Object ... aParams) {
                return false;
            }
        };
        fltList = new SrFilteredArrayList<Integer>(this.mySrcList, defaultRule1, defaultRule2);
        SrFilteredArrayListTest.assertTrue((String)"The Original Filtered List is different from the Source List", (boolean)((Object)fltList.getAll()).equals(this.mySrcList));
        SrFilteredArrayListTest.assertTrue((String)"The Matched Filtered List is not Empty as expected", (boolean)fltList.getAllOfMatched().isEmpty());
        SrFilteredArrayListTest.assertTrue((String)"The Unmatch Filtered List is different from the Source List", (boolean)((Object)fltList.getAllOfUnMatched()).equals(this.mySrcList));
        SrFilteredArrayListTest.assertEquals((String)"The number of Rules is not as expected", (int)2, (int)fltList.getAllRules().size());
        ArrayList listOfRules = new ArrayList();
        listOfRules.add(defaultRule1);
        listOfRules.add(defaultRule2);
        fltList = new SrFilteredArrayList<Integer>(this.mySrcList, listOfRules);
        SrFilteredArrayListTest.assertTrue((String)"The Original Filtered List is different from the Source List", (boolean)((Object)fltList.getAll()).equals(this.mySrcList));
        SrFilteredArrayListTest.assertTrue((String)"The Matched Filtered List is not Empty as expected", (boolean)fltList.getAllOfMatched().isEmpty());
        SrFilteredArrayListTest.assertTrue((String)"The Unmatch Filtered List is different from the Source List", (boolean)((Object)fltList.getAllOfUnMatched()).equals(this.mySrcList));
        SrFilteredArrayListTest.assertEquals((String)"The number of Rules is not as expected", (int)listOfRules.size(), (int)fltList.getAllRules().size());
    }

    public void testSimpleRulesAddonAndRemoval() {
        keepNumberIfEvenRule keepNumberIfEven = new keepNumberIfEvenRule();
        keepNumberIfProductOf2Rule keepNumberIfProductOf2 = new keepNumberIfProductOf2Rule();
        SrFilteredArrayList<Integer> fltList = new SrFilteredArrayList<Integer>(this.mySrcList, keepNumberIfEven, keepNumberIfProductOf2);
        ArrayList<Integer> tmpList = new ArrayList<Integer>(this.mySrcList);
        for (Integer curNum : this.mySrcList) {
            if (keepNumberIfEven.isValid(curNum, new Object[]{fltList}) && keepNumberIfProductOf2.isValid(curNum, new Object[]{fltList})) continue;
            tmpList.remove(curNum);
        }
        SrFilteredArrayListTest.assertTrue((String)"The Original Filtered List is different from the Source List", (boolean)((Object)fltList.getAll()).equals(this.mySrcList));
        SrFilteredArrayListTest.assertTrue((String)"The Matched Filtered List is different from the expected List", (boolean)((Object)fltList.getAllOfMatched()).equals(tmpList));
        SrFilteredArrayListTest.assertEquals((String)"The Size of the Original List is different from the total matched and unmatched together", (int)fltList.size(), (int)(fltList.sizeOfMatched() + fltList.sizeOfUnmatched()));
        tmpList = new ArrayList<Integer>(this.mySrcList);
        for (Integer curNum : this.mySrcList) {
            if (keepNumberIfProductOf2.isValid(curNum, new Object[]{fltList})) continue;
            tmpList.remove(curNum);
        }
        fltList.removeRule(keepNumberIfEven);
        SrFilteredArrayListTest.assertEquals((String)"The Size of the Original List is different from the total matched and unmatched together", (int)fltList.size(), (int)(fltList.sizeOfMatched() + fltList.sizeOfUnmatched()));
        SrFilteredArrayListTest.assertTrue((String)"The Matched Filtered List is different from the expected List", (boolean)fltList.getAllOfMatched().containsAll(tmpList));
        SrFilteredArrayListTest.assertTrue((String)"The Matched Filtered List is different from the expected List", (boolean)tmpList.containsAll(fltList.getAllOfMatched()));
        fltList.removeRule(keepNumberIfProductOf2);
        SrFilteredArrayListTest.assertEquals((String)"The Size of the Original List is different from the total matched and unmatched together", (int)fltList.size(), (int)(fltList.sizeOfMatched() + fltList.sizeOfUnmatched()));
        SrFilteredArrayListTest.assertTrue((String)"The Matched Filtered List is different from the expected List", (boolean)fltList.getAllOfMatched().containsAll(this.mySrcList));
        SrFilteredArrayListTest.assertTrue((String)"The Matched Filtered List is different from the expected List", (boolean)this.mySrcList.containsAll(fltList.getAllOfMatched()));
        SrFilteredArrayListTest.assertEquals((String)"The unmatched list should be empty", (int)0, (int)fltList.sizeOfUnmatched());
    }

    public void testDynamicRulesAddonAndRemoval() {
        keepNumberIfSmallerThan_DynamicRule highBoundryRule = new keepNumberIfSmallerThan_DynamicRule();
        keepNumberIfLargerThan_DynamicRule lowBoundryRule = new keepNumberIfLargerThan_DynamicRule();
        SrFilteredArrayList<Integer> fltList = new SrFilteredArrayList<Integer>(this.mySrcList, highBoundryRule, lowBoundryRule);
        SrFilteredArrayListTest.assertEquals((String)"The Size of the Original List is different from the total matched and unmatched together", (int)fltList.size(), (int)(fltList.sizeOfMatched() + fltList.sizeOfUnmatched()));
        SrFilteredArrayListTest.assertTrue((String)"The Matched Filtered List is different from the expected List", (boolean)fltList.getAllOfMatched().containsAll(this.mySrcList));
        SrFilteredArrayListTest.assertTrue((String)"The Matched Filtered List is different from the expected List", (boolean)this.mySrcList.containsAll(fltList.getAllOfMatched()));
        Integer lowBoundry = new Integer(3);
        Integer highBoundry = new Integer(7);
        if (!lowBoundryRule.addObject(lowBoundry)) {
            SrFilteredArrayListTest.fail((String)"Failed to add Object to the dynamic rule");
        }
        if (!highBoundryRule.addObject(highBoundry)) {
            SrFilteredArrayListTest.fail((String)"Failed to add Object to the dynamic rule");
        }
        ArrayList<Integer> expectedList = new ArrayList<Integer>(this.mySrcList);
        for (Integer num : this.mySrcList) {
            if (lowBoundryRule.isValid(num, (Object[])null) && highBoundryRule.isValid(num, (Object[])null)) continue;
            expectedList.remove(num);
        }
        SrFilteredArrayListTest.assertEquals((String)"The Size of the Original List is different from the total matched and unmatched together", (int)fltList.size(), (int)(fltList.sizeOfMatched() + fltList.sizeOfUnmatched()));
        SrFilteredArrayListTest.assertTrue((String)"The Matched Filtered List is different from the expected List", (boolean)fltList.getAllOfMatched().containsAll(expectedList));
        SrFilteredArrayListTest.assertTrue((String)"The Matched Filtered List is different from the expected List", (boolean)expectedList.containsAll(fltList.getAllOfMatched()));
        lowBoundry = new Integer(5);
        highBoundry = new Integer(4);
        lowBoundryRule.clearObjects();
        highBoundryRule.clearObjects();
        SrFilteredArrayListTest.assertTrue((String)"The Matched Filtered List is different from the filtered List", (boolean)fltList.getAllOfMatched().containsAll(this.mySrcList));
        SrFilteredArrayListTest.assertTrue((String)"The Matched Filtered List is different from the filtered List", (boolean)this.mySrcList.containsAll(fltList.getAllOfMatched()));
        if (!lowBoundryRule.addObject(lowBoundry)) {
            SrFilteredArrayListTest.fail((String)"Failed to add Object to the dynamic rule");
        }
        if (!highBoundryRule.addObject(highBoundry)) {
            SrFilteredArrayListTest.fail((String)"Failed to add Object to the dynamic rule");
        }
        SrFilteredArrayListTest.assertTrue((String)"The Matched list should be empty", (boolean)fltList.isEmptyOfMatched());
    }

    public void testIntegratingListeners() {
        keepNumberIfSmallerThan_DynamicRule newHighBoundryRule = new keepNumberIfSmallerThan_DynamicRule(){
            public boolean myIsNotifiedListenersCalled = false;

            public void notifyListeners() {
                this.myIsNotifiedListenersCalled = true;
            }
        };
        SrFilteredArrayList<Integer> fltList = new SrFilteredArrayList<Integer>(this.mySrcList, newHighBoundryRule);
        Integer highBoundry = new Integer(5);
        newHighBoundryRule.addObject(highBoundry);
        Class<?> c = newHighBoundryRule.getClass();
        try {
            Field fld = c.getField("myIsNotifiedListenersCalled");
            SrFilteredArrayListTest.assertEquals((String)"The field myIsNotifiedListenersCalled should be true", (Object)true, (Object)fld.get(newHighBoundryRule));
        }
        catch (SecurityException e) {
            SrFilteredArrayListTest.fail((String)("Got exception while trying to get the field myIsNotifiedListenersCalled " + e));
        }
        catch (NoSuchFieldException e) {
            SrFilteredArrayListTest.fail((String)("Got exception while trying to get the field myIsNotifiedListenersCalled " + e));
        }
        catch (IllegalArgumentException e) {
            SrFilteredArrayListTest.fail((String)("Got exception while trying to get the field myIsNotifiedListenersCalled " + e));
        }
        catch (IllegalAccessException e) {
            SrFilteredArrayListTest.fail((String)("Got exception while trying to get the field myIsNotifiedListenersCalled " + e));
        }
    }

    public void testAddingSingleElements() {
        SrFilteredArrayList<Integer> fltList = new SrFilteredArrayList<Integer>();
        keepNumberIfProductOf2Rule keepNumberIfProductOf2 = new keepNumberIfProductOf2Rule();
        removeNumberBiggerThanMaxRule removeNumberBiggerThanMax = new removeNumberBiggerThanMaxRule();
        fltList.addRule(keepNumberIfProductOf2);
        fltList.addRule(removeNumberBiggerThanMax);
        ArrayList<Integer> tmpList = new ArrayList<Integer>(this.mySrcList);
        for (Integer element : this.mySrcList) {
            if (!keepNumberIfProductOf2.isValid(element, new Object[0]) || !removeNumberBiggerThanMax.isValid(element, new Object[0])) {
                tmpList.remove(element);
            }
            fltList.add(element);
        }
        SrFilteredArrayListTest.assertEquals((String)"The Size of Matched and Unmatched Lists is different from the Source List", (int)this.mySrcList.size(), (int)(fltList.sizeOfMatched() + fltList.sizeOfUnmatched()));
        SrFilteredArrayListTest.assertTrue((String)"The Matched Filtered List is different from the expected List", (boolean)tmpList.containsAll(fltList.getAllOfMatched()));
        SrFilteredArrayListTest.assertTrue((String)"The Matched Filtered List is different from the expected List", (boolean)fltList.getAllOfMatched().containsAll(tmpList));
    }

    public void testFilterClearingAndClone() {
        SrFilteredArrayList<Integer> fltList1 = new SrFilteredArrayList<Integer>(this.mySrcList);
        removeNumberBiggerThanMaxRule removeNumberBiggerThanMax = new removeNumberBiggerThanMaxRule();
        fltList1.addRule(removeNumberBiggerThanMax);
        SrFilteredArrayListTest.assertFalse((String)"The Original Filter List1 should not be Empty", (boolean)fltList1.getAll().isEmpty());
        SrFilteredArrayListTest.assertFalse((String)"The Matched Filter List1 should not be Empty", (boolean)fltList1.getAllOfMatched().isEmpty());
        SrFilteredArrayListTest.assertFalse((String)"The Unmatched Filter List1 should not be Empty", (boolean)fltList1.getAllOfUnMatched().isEmpty());
        Object fltList2 = fltList1.clone();
        SrFilteredArrayListTest.assertTrue((String)"The Two Cloned Filter's Match Lists 1 & 2 are not the same", (boolean)((Object)fltList1.getAllOfMatched()).equals(((SrFilteredArrayList)fltList2).getAllOfMatched()));
        SrFilteredArrayListTest.assertTrue((String)"The Two Cloned Filter's Unmatch Lists 1 & 2 are not the same", (boolean)((Object)fltList1.getAllOfUnMatched()).equals(((SrFilteredArrayList)fltList2).getAllOfUnMatched()));
        SrFilteredArrayListTest.assertTrue((String)"The Two Cloned Filter's Original Lists 1 & 2 are not the same", (boolean)((Object)fltList1.getAll()).equals(((SrFilteredArrayList)fltList2).getAll()));
        fltList1.clearOfMatched();
        SrFilteredArrayListTest.assertTrue((String)"The Matched Filter List1 should be Empty", (boolean)fltList1.getAllOfMatched().isEmpty());
        SrFilteredArrayListTest.assertTrue((String)"The Size of Original List1 should be less than what was before", (fltList1.getAll().size() < ((SrFilteredArrayList)fltList2).getAll().size() ? 1 : 0) != 0);
        fltList1.clearOfUnmatched();
        SrFilteredArrayListTest.assertTrue((String)"The Unmatched Filter List1 should be Empty", (boolean)fltList1.getAllOfUnMatched().isEmpty());
        SrFilteredArrayListTest.assertTrue((String)"The Size of Original List1 should be empty", (boolean)fltList1.getAll().isEmpty());
        ((SrFilteredArrayList)fltList2).clear();
        SrFilteredArrayListTest.assertTrue((String)"The Matched Filter List2 should be Empty", (boolean)((SrFilteredArrayList)fltList2).getAllOfMatched().isEmpty());
        SrFilteredArrayListTest.assertTrue((String)"The Unmatched Filter List2 should be Empty", (boolean)((SrFilteredArrayList)fltList2).getAllOfUnMatched().isEmpty());
        SrFilteredArrayListTest.assertTrue((String)"The Size of Original List2 should be empty", (boolean)((SrFilteredArrayList)fltList2).getAll().isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        FileInputStream inFile = null;
        try {
            inFile = new FileInputStream(CONF_FILE);
            logProps.load(inFile);
            SrLogger.init(logProps);
            theLogger = SrLogger.getLogger();
        }
        catch (FileNotFoundException e1) {
            SrLogger.init(null);
            theLogger = SrLogger.getLogger();
        }
        catch (IOException e) {
            SrLogger.init(null);
            theLogger = SrLogger.getLogger();
        }
        finally {
            try {
                if (inFile != null) {
                    inFile.close();
                }
            }
            catch (IOException e) {
                System.err.println("Can not close the logger configuration file.");
            }
        }
    }

    private class keepNumberIfLargerThan_DynamicRule
    extends SrFilterDynamicRule<Integer> {
        private keepNumberIfLargerThan_DynamicRule() {
        }

        @Override
        public boolean isValid(Integer newObject, Object ... params) {
            if (newObject == null) {
                return false;
            }
            List<Object> objs = this.getObjects();
            if (objs == null) {
                Assert.fail((String)"The Inner objects if Dynamic rule should not be null");
            }
            if (objs.isEmpty()) {
                return true;
            }
            Integer lowBoundry = (Integer)objs.get(0);
            return newObject.compareTo(lowBoundry) >= 0;
        }
    }

    private class keepNumberIfSmallerThan_DynamicRule
    extends SrFilterDynamicRule<Integer> {
        private keepNumberIfSmallerThan_DynamicRule() {
        }

        @Override
        public boolean isValid(Integer newObject, Object ... params) {
            if (newObject == null) {
                return false;
            }
            List<Object> objs = this.getObjects();
            if (objs == null) {
                Assert.fail((String)"The Inner objects if Dynamic rule should not be null");
            }
            if (objs.isEmpty()) {
                return true;
            }
            Integer highBoundry = (Integer)objs.get(0);
            return newObject.compareTo(highBoundry) <= 0;
        }
    }

    private class keepNumberIfEvenRule
    extends SrFilterSimpleRule<Integer> {
        private keepNumberIfEvenRule() {
        }

        @Override
        public boolean isValid(Integer newObject, Object ... params) {
            if (newObject == null) {
                return false;
            }
            return newObject % 2 == 0;
        }
    }

    private class removeNumberBiggerThanMaxRule
    extends SrFilterSimpleRule<Integer> {
        private removeNumberBiggerThanMaxRule() {
        }

        @Override
        public boolean isValid(Integer newObject, Object ... params) {
            return newObject.compareTo(new Integer(Math.round(5.0f))) <= 0;
        }
    }

    private class keepNumberIfProductOf2Rule
    extends SrFilterSimpleRule<Integer> {
        private keepNumberIfProductOf2Rule() {
        }

        @Override
        public boolean isValid(Integer newObject, Object ... params) {
            int logNbase2Integer;
            if (newObject == null) {
                return false;
            }
            int n = newObject;
            double logNbase2 = Math.log(n) / Math.log(2.0);
            return logNbase2 - (double)(logNbase2Integer = (int)Math.floor(logNbase2)) == 0.0;
        }
    }
}

