/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.RemoteEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class SrEventListenerManager {
    private static final long serialVersionUID = 1L;
    private static final SrLogger theLogger = SrLogger.getLogger();
    private Map<Class<? extends EventListener>, Map<EventListener, Object>> m_listeners = Collections.synchronizedMap(new HashMap());
    private final Object m_dummy = new Object();

    public <T extends EventListener> void addAll(Collection<T> listeners) {
        for (EventListener t : listeners) {
            this.add(t);
        }
    }

    public <T extends EventListener> void add(T listener) {
        if (listener == null) {
            throw new IllegalArgumentException("passed a null listener!");
        }
        Class<?> aClass = listener.getClass();
        Map<EventListener, Object> classListeners = this.m_listeners.get(aClass);
        if (classListeners == null) {
            classListeners = Collections.synchronizedMap(new WeakHashMap());
            this.m_listeners.put(aClass, classListeners);
        }
        classListeners.put(listener, this.m_dummy);
    }

    public <T extends EventListener> void remove(T listener) {
        Class<?> aClass = listener.getClass();
        Map<EventListener, Object> classListeners = this.m_listeners.get(aClass);
        if (classListeners == null) {
            return;
        }
        classListeners.remove(listener);
        if (classListeners.isEmpty()) {
            this.m_listeners.remove(aClass);
        }
    }

    public int getListenerCount(Class<? extends EventListener> aClass) {
        int retVal = 0;
        Collection<EventListener> classListeners = this.getListeners(aClass);
        if (classListeners != null) {
            retVal = classListeners.size();
        }
        return retVal;
    }

    protected Collection<EventListener> getListeners(Class<? extends EventListener> aClass) {
        HashSet<EventListener> retVal = new HashSet<EventListener>();
        for (Map.Entry<Class<? extends EventListener>, Map<EventListener, Object>> entry : this.m_listeners.entrySet()) {
            Class<? extends EventListener> theClass = entry.getKey();
            if (!aClass.isAssignableFrom(theClass)) continue;
            Map<EventListener, Object> classListeners = entry.getValue();
            retVal.addAll(classListeners.keySet());
        }
        return Collections.unmodifiableSet(retVal);
    }

    public String toString() {
        int totalListenersCount = 0;
        String retVal = "";
        for (Map.Entry<Class<? extends EventListener>, Map<EventListener, Object>> entry : this.m_listeners.entrySet()) {
            Class<? extends EventListener> tClass = entry.getKey();
            Map<EventListener, Object> classListeners = entry.getValue();
            retVal = retVal + classListeners.size() + " " + tClass.getName() + " m_listeners:";
            totalListenersCount += classListeners.size();
            Iterator<EventListener> listenersItr = classListeners.keySet().iterator();
            while (listenersItr.hasNext()) {
                retVal = retVal + "\t" + listenersItr.next().toString();
            }
        }
        return "SrEventListenerManager: \n" + totalListenersCount + " m_listeners: \n" + retVal;
    }

    public <T extends EventListener, E extends EventObject> void fireEvent(Class<? extends EventListener> aClass, E event, Informer<T, E> informer) {
        HashSet<EventListener> listenersSet = new HashSet<EventListener>(this.getListeners(aClass));
        for (EventListener listener : listenersSet) {
            try {
                informer.inform(listener, event);
            }
            catch (Exception e) {
                theLogger.logAndAssert(SrLogCategories.EXCEPTION, e);
            }
        }
    }

    public <T extends EventListener, E extends RemoteEvent> void fireEvent(Class<? extends EventListener> aClass, E event, RemoteInformer<T, E> informer) {
        HashSet<EventListener> listenersSet = new HashSet<EventListener>(this.getListeners(aClass));
        for (EventListener listener : listenersSet) {
            try {
                informer.inform(listener, event);
            }
            catch (Exception e) {
                theLogger.logAndAssert(SrLogCategories.EXCEPTION, e);
            }
        }
    }

    public static interface RemoteInformer<T extends EventListener, E extends RemoteEvent> {
        public void inform(T var1, E var2);
    }

    public static interface Informer<T extends EventListener, E extends EventObject> {
        public void inform(T var1, E var2);
    }
}

