/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util;

import com.sanrad.util.DoubleMultiMap;
import com.sanrad.util.MultiHashMap;
import com.sanrad.util.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class DoubleMultiHashMap<K, V>
implements DoubleMultiMap<K, V> {
    private MultiMap<K, V> myStraightMap = new MultiHashMap();
    private MultiMap<V, K> myReverseMap = new MultiHashMap<V, K>();

    @Override
    public int size() {
        return this.myStraightMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myStraightMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object aKey) {
        return this.myStraightMap.containsKey(aKey);
    }

    @Override
    public boolean containsValue(Object aValue) {
        return this.myReverseMap.containsKey(aValue);
    }

    @Override
    public Set<V> get(Object aKey) {
        return (Set)this.myStraightMap.get(aKey);
    }

    @Override
    public Set<K> getKey(V aVal) {
        return (Set)this.myReverseMap.get(aVal);
    }

    @Override
    public K getKey(Set<V> aVal) {
        throw new UnsupportedOperationException("Don't use this method, instead use: Set<K> getKey(V aVal)");
    }

    @Override
    public Set<V> put(K aKey, V aValue) {
        return this.put(aKey, Collections.singleton(aValue));
    }

    @Override
    public Set<V> put(K aKey, Set<V> aValues) {
        Set<V> retVal = this.myStraightMap.put(aKey, aValues);
        for (V v : aValues) {
            this.myReverseMap.put(v, aKey);
        }
        return retVal;
    }

    @Override
    public Set<V> remove(Object aKey) {
        Set retVal = (Set)this.myStraightMap.remove(aKey);
        if (retVal != null) {
            for (Object v : retVal) {
                Set keys = (Set)this.myReverseMap.get(v);
                keys.remove(aKey);
                if (!keys.isEmpty()) continue;
                this.myReverseMap.remove(v);
            }
        }
        return retVal;
    }

    @Override
    public Set<K> removeValue(Object aVal) {
        Set retVal = (Set)this.myReverseMap.remove(aVal);
        if (retVal != null) {
            for (Object k : retVal) {
                Set values = (Set)this.myStraightMap.get(k);
                values.remove(aVal);
                if (!values.isEmpty()) continue;
                this.myStraightMap.remove(k);
            }
        }
        return retVal;
    }

    @Override
    public void putAll(Map<? extends K, ? extends Set<V>> aT) {
        throw new UnsupportedOperationException("This operation is not allowed.");
    }

    @Override
    public void clear() {
        this.myStraightMap.clear();
        this.myReverseMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.myStraightMap.keySet();
    }

    @Override
    public Collection<Set<V>> values() {
        return this.myStraightMap.values();
    }

    @Override
    public Set<Map.Entry<K, Set<V>>> entrySet() {
        return Collections.unmodifiableSet(this.myStraightMap.entrySet());
    }

    @Override
    public Set<Map.Entry<V, Set<K>>> entrySetReverse() {
        return Collections.unmodifiableSet(this.myReverseMap.entrySet());
    }

    @Override
    public boolean equals(Object aO) {
        if (!(aO instanceof DoubleMultiHashMap)) {
            return false;
        }
        DoubleMultiHashMap other = (DoubleMultiHashMap)aO;
        return this.myStraightMap.equals(other.myStraightMap) && this.myReverseMap.equals(other.myReverseMap);
    }

    @Override
    public int hashCode() {
        return this.myStraightMap.hashCode() ^ this.myReverseMap.hashCode();
    }
}

