/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.util;

import java.util.Comparator;

public class CompoundComparator<T>
implements Comparator<T> {
    private Mode myMode;
    private Comparator<T>[] myComparators;

    public CompoundComparator(Mode aMode, Comparator<T> ... aComparators) {
        if (aMode == null) {
            throw new IllegalArgumentException("Mode must be supplied");
        }
        if (aComparators == null) {
            throw new IllegalArgumentException("Comparators must be supplied");
        }
        this.myMode = aMode;
        this.myComparators = aComparators;
    }

    @Override
    public int compare(T o1, T o2) {
        switch (this.myMode) {
            case SIMPLE: {
                return this.performSimpleComparison(o1, o2);
            }
            case WEIGHTING: {
                return this.performWeightingComparison(o1, o2);
            }
        }
        throw new IllegalStateException("The mode " + (Object)((Object)this.myMode) + " is not supported");
    }

    private int performSimpleComparison(T o1, T o2) {
        for (Comparator<T> com : this.myComparators) {
            int result = com.compare(o1, o2);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    private int performWeightingComparison(T o1, T o2) {
        int sum = 0;
        for (Comparator<T> com : this.myComparators) {
            sum += com.compare(o1, o2);
        }
        return sum;
    }

    public static enum Mode {
        SIMPLE,
        WEIGHTING;

    }
}

