/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util.types.constants;

import com.sanrad.nms.server.util.types.constants.MibItemConstant;
import java.util.Vector;

public class VolumeOperationType
extends MibItemConstant {
    private static Vector valuesList;
    public static final VolumeOperationType VOL_OPER_REPLACE_VOLUME;
    public static final VolumeOperationType VOL_OPER_ADD_MIRROR;
    public static final VolumeOperationType VOL_OPER_OFFLINE_COPY;
    public static final VolumeOperationType VOL_OPER_ABORT_MIRROR_SYNC;
    public static final VolumeOperationType VOL_OPER_ABORT_COPY;
    public static final VolumeOperationType VOL_OPER_BREAK_MIRROR;
    public static final VolumeOperationType VOL_OPER_MIRROR_SYNC;
    public static final VolumeOperationType VOL_OPER_EXPAND;
    public static final VolumeOperationType VOL_OPER_RESIZE;
    public static final VolumeOperationType VOL_OPER_RETRACT;
    public static final VolumeOperationType VOL_OPER_NONE;
    public static final VolumeOperationType VOL_OPER_ADD_CHILD;
    public static final VolumeOperationType VOL_OPER_RESTORE;
    public static final VolumeOperationType VOL_OPER_ABORT_RESTORE;

    private VolumeOperationType(int value, String descriptionName, Object userVal) {
        super(value, descriptionName, userVal);
        if (valuesList == null) {
            valuesList = new Vector();
        }
        valuesList.add(this);
    }

    public VolumeOperationType[] getAllOperTypes() {
        VolumeOperationType[] types = new VolumeOperationType[valuesList.size()];
        return valuesList.toArray(types);
    }

    public boolean isMirrSyncOper() {
        return this.equals(VOL_OPER_ABORT_MIRROR_SYNC) || this.equals(VOL_OPER_MIRROR_SYNC);
    }

    public boolean isOfflineCopy() {
        return this.equals(VOL_OPER_OFFLINE_COPY) || this.equals(VOL_OPER_ABORT_COPY);
    }

    public boolean isRestore() {
        return this.equals(VOL_OPER_RESTORE) || this.isAbortRestore();
    }

    public boolean isAbortRestore() {
        return this.equals(VOL_OPER_ABORT_RESTORE);
    }

    public static VolumeOperationType getVolumeOperationTypeName(Integer typeName) {
        for (VolumeOperationType currnt : valuesList) {
            if (!currnt.intValue().equals(typeName)) continue;
            return currnt;
        }
        return null;
    }

    static {
        VOL_OPER_REPLACE_VOLUME = new VolumeOperationType(1, "replaceVolume", "Replace the volume");
        VOL_OPER_ADD_MIRROR = new VolumeOperationType(2, "addMirror", "Add a child to Mirror Volume");
        VOL_OPER_OFFLINE_COPY = new VolumeOperationType(3, "offlineCopy", "Perform Offline Copy for the volume");
        VOL_OPER_ABORT_MIRROR_SYNC = new VolumeOperationType(4, "abortMirrSync", "Abort Mirror Sync operation");
        VOL_OPER_ABORT_COPY = new VolumeOperationType(5, "abortCopy", "Abort Copy operation");
        VOL_OPER_BREAK_MIRROR = new VolumeOperationType(6, "removeMirror", "Remove a child of Mirror Volume");
        VOL_OPER_MIRROR_SYNC = new VolumeOperationType(7, "mirrorSync", "Synchronize Mirror Volume");
        VOL_OPER_EXPAND = new VolumeOperationType(9, "expandVolume", "Expand volume capacity");
        VOL_OPER_RESIZE = new VolumeOperationType(10, "resizeVolume", "Resize the Volume");
        VOL_OPER_RETRACT = new VolumeOperationType(11, "retractVolume", "Retract the Volume");
        VOL_OPER_NONE = new VolumeOperationType(12, "none", "none");
        VOL_OPER_ADD_CHILD = new VolumeOperationType(13, "addCild", "Add Child");
        VOL_OPER_RESTORE = new VolumeOperationType(14, "restore", "Rollback");
        VOL_OPER_ABORT_RESTORE = new VolumeOperationType(15, "abortRestore", "Abort rollback");
    }
}

