/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util.types.constants;

import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.types.SrOidType;
import com.sanrad.nms.server.util.types.constants.FcAdminSpeedConstant;
import com.sanrad.nms.server.util.types.constants.MibItemConstant;
import java.util.HashMap;

public class VSwitchSysOID
extends MibItemConstant {
    private static HashMap<SrOidType, VSwitchSysOID> theOidToVSwitchOID = new HashMap();
    private static final long[] VSWITCH_UNKNOWN_OID = new long[]{1L, 3L, 6L, 1L, 4L, 1L, 10059L, 1L, 1L, 1L};
    private static final long[] VSWITCH_3000_OID = new long[]{1L, 3L, 6L, 1L, 4L, 1L, 10059L, 1L, 1L, 2L};
    private static final long[] VSWITCH_2000_OID = new long[]{1L, 3L, 6L, 1L, 4L, 1L, 10059L, 1L, 1L, 3L};
    private static final long[] VSWITCH_3800_OID = new long[]{1L, 3L, 6L, 1L, 4L, 1L, 10059L, 1L, 1L, 4L};
    private static final long[] VSWITCH_3400_OID = new long[]{1L, 3L, 6L, 1L, 4L, 1L, 10059L, 1L, 1L, 5L};
    private static final long[] VSTOR_3400_OID = new long[]{1L, 3L, 6L, 1L, 4L, 1L, 10059L, 1L, 1L, 6L};
    private static final long[] VSWITCH_3440_OID = new long[]{1L, 3L, 6L, 1L, 4L, 1L, 10059L, 1L, 1L, 7L};
    private static final long[] VSWITCH_3840_OID = new long[]{1L, 3L, 6L, 1L, 4L, 1L, 10059L, 1L, 1L, 8L};
    private static final long[] VSTOR_3000_OID = new long[]{1L, 3L, 6L, 1L, 4L, 1L, 10059L, 1L, 1L, 9L};
    private static final long[] VSTOR_2000_OID = new long[]{1L, 3L, 6L, 1L, 4L, 1L, 10059L, 1L, 1L, 10L};
    private static final long[] VSTOR_3800_OID = new long[]{1L, 3L, 6L, 1L, 4L, 1L, 10059L, 1L, 1L, 11L};
    private static final long[] VSTOR_3440_OID = new long[]{1L, 3L, 6L, 1L, 4L, 1L, 10059L, 1L, 1L, 12L};
    private static final long[] VSTOR_3840_OID = new long[]{1L, 3L, 6L, 1L, 4L, 1L, 10059L, 1L, 1L, 13L};
    private static final long[] NEXSAN_OID = new long[]{1L, 3L, 6L, 1L, 4L, 1L, 10059L, 1L, 1L, 14L};
    private static final long[] NEXSAN_200_OID = new long[]{1L, 3L, 6L, 1L, 4L, 1L, 10059L, 1L, 1L, 15L};
    private static final long[] NEXSAN_400_OID = new long[]{1L, 3L, 6L, 1L, 4L, 1L, 10059L, 1L, 1L, 16L};
    private static final long[] NEXSAN_600_OID = new long[]{1L, 3L, 6L, 1L, 4L, 1L, 10059L, 1L, 1L, 17L};
    private static final long[] NEXSAN_800_OID = new long[]{1L, 3L, 6L, 1L, 4L, 1L, 10059L, 1L, 1L, 18L};
    public static final VSwitchSysOID VSWITCH_SYS_OID_UNKNOWN = new VSwitchSysOID(1, "Unknown", new SrOidType(VSWITCH_UNKNOWN_OID), FcAdminSpeedConstant.FC_PORT_SPEED_AUTO);
    public static final VSwitchSysOID VSWITCH_SYS_OID_3000 = new VSwitchSysOID(2, ClassID.VSWITCH + " 3000", new SrOidType(VSWITCH_3000_OID), FcAdminSpeedConstant.FC_PORT_SPEED_TWO);
    public static final VSwitchSysOID VSWITCH_SYS_OID_2000 = new VSwitchSysOID(3, ClassID.VSWITCH + " 2000", new SrOidType(VSWITCH_2000_OID), FcAdminSpeedConstant.FC_PORT_SPEED_TWO);
    public static final VSwitchSysOID VSWITCH_SYS_OID_3800 = new VSwitchSysOID(4, ClassID.VSWITCH + " 3800", new SrOidType(VSWITCH_3800_OID), FcAdminSpeedConstant.FC_PORT_SPEED_TWO);
    public static final VSwitchSysOID VSWITCH_SYS_OID_3400 = new VSwitchSysOID(5, ClassID.VSWITCH + " 3400", new SrOidType(VSWITCH_3400_OID), FcAdminSpeedConstant.FC_PORT_SPEED_TWO);
    public static final VSwitchSysOID VSTOR_SYS_OID_3400 = new VSwitchSysOID(6, "V-STOR 3400", new SrOidType(VSTOR_3400_OID), FcAdminSpeedConstant.FC_PORT_SPEED_TWO);
    public static final VSwitchSysOID VSWITCH_SYS_OID_3440 = new VSwitchSysOID(7, ClassID.VSWITCH + " 3440", new SrOidType(VSWITCH_3440_OID), FcAdminSpeedConstant.FC_PORT_SPEED_FOUR);
    public static final VSwitchSysOID VSWITCH_SYS_OID_3840 = new VSwitchSysOID(8, ClassID.VSWITCH + " 3840", new SrOidType(VSWITCH_3840_OID), FcAdminSpeedConstant.FC_PORT_SPEED_FOUR);
    public static final VSwitchSysOID VSTOR_SYS_OID = new VSwitchSysOID(9, "V-STOR 3000", new SrOidType(VSTOR_3000_OID), FcAdminSpeedConstant.FC_PORT_SPEED_TWO);
    public static final VSwitchSysOID VSTOR_SYS_OID_2000 = new VSwitchSysOID(10, "V-STOR 2000", new SrOidType(VSTOR_2000_OID), FcAdminSpeedConstant.FC_PORT_SPEED_TWO);
    public static final VSwitchSysOID VSTOR_SYS_OID_3800 = new VSwitchSysOID(11, "V-STOR 3800", new SrOidType(VSTOR_3800_OID), FcAdminSpeedConstant.FC_PORT_SPEED_TWO);
    public static final VSwitchSysOID VSTOR_SYS_OID_3440 = new VSwitchSysOID(12, "V-STOR 3440", new SrOidType(VSTOR_3440_OID), FcAdminSpeedConstant.FC_PORT_SPEED_FOUR);
    public static final VSwitchSysOID VSTOR_SYS_OID_3840 = new VSwitchSysOID(13, "V-STOR 3840", new SrOidType(VSTOR_3840_OID), FcAdminSpeedConstant.FC_PORT_SPEED_FOUR);
    public static final VSwitchSysOID NEXSAN_SYS_OID = new VSwitchSysOID(14, "i series", new SrOidType(NEXSAN_OID), FcAdminSpeedConstant.FC_PORT_SPEED_TWO);
    public static final VSwitchSysOID NEXSAN_SYS_OID_200 = new VSwitchSysOID(15, "i series 200i", new SrOidType(NEXSAN_200_OID), FcAdminSpeedConstant.FC_PORT_SPEED_TWO);
    public static final VSwitchSysOID NEXSAN_SYS_OID_400 = new VSwitchSysOID(16, "i series 400i", new SrOidType(NEXSAN_400_OID), FcAdminSpeedConstant.FC_PORT_SPEED_FOUR);
    public static final VSwitchSysOID NEXSAN_SYS_OID_600 = new VSwitchSysOID(17, "i series 600i", new SrOidType(NEXSAN_600_OID), FcAdminSpeedConstant.FC_PORT_SPEED_FOUR);
    public static final VSwitchSysOID NEXSAN_SYS_OID_800 = new VSwitchSysOID(18, "i series 800i", new SrOidType(NEXSAN_800_OID), FcAdminSpeedConstant.FC_PORT_SPEED_FOUR);
    private SrOidType mySrOidType;
    private FcAdminSpeedConstant myFcSpeed;

    private VSwitchSysOID(int value, String descriptionName, Object userVal, FcAdminSpeedConstant aFcSpeed) {
        super(value, descriptionName, userVal);
        this.mySrOidType = (SrOidType)userVal;
        this.myFcSpeed = aFcSpeed;
        theOidToVSwitchOID.put(this.mySrOidType, this);
    }

    public FcAdminSpeedConstant getFCSpeed() {
        return this.myFcSpeed;
    }

    public static VSwitchSysOID valueOf(SrOidType source) {
        VSwitchSysOID retOid = theOidToVSwitchOID.get(source);
        return retOid != null ? retOid : VSWITCH_SYS_OID_UNKNOWN;
    }

    public int hashCode() {
        String oidString = this.mySrOidType.toString();
        return oidString.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof VSwitchSysOID) {
            return ((VSwitchSysOID)obj).mySrOidType.equals(this.mySrOidType);
        }
        return false;
    }

    public boolean isVStor() {
        return this.mySrOidType.equals(VSwitchSysOID.VSTOR_SYS_OID_3400.mySrOidType) || this.mySrOidType.equals(VSwitchSysOID.VSTOR_SYS_OID.mySrOidType) || this.mySrOidType.equals(VSwitchSysOID.VSTOR_SYS_OID_2000.mySrOidType) || this.mySrOidType.equals(VSwitchSysOID.VSTOR_SYS_OID_3800.mySrOidType) || this.mySrOidType.equals(VSwitchSysOID.VSTOR_SYS_OID_3440.mySrOidType) || this.mySrOidType.equals(VSwitchSysOID.VSTOR_SYS_OID_3840.mySrOidType);
    }

    public boolean isNexsan() {
        return this.mySrOidType.equals(VSwitchSysOID.NEXSAN_SYS_OID.mySrOidType) || this.mySrOidType.equals(VSwitchSysOID.NEXSAN_SYS_OID_200.mySrOidType) || this.mySrOidType.equals(VSwitchSysOID.NEXSAN_SYS_OID_400.mySrOidType) || this.mySrOidType.equals(VSwitchSysOID.NEXSAN_SYS_OID_600.mySrOidType) || this.mySrOidType.equals(VSwitchSysOID.NEXSAN_SYS_OID_800.mySrOidType);
    }

    public boolean isVSwitch() {
        return !this.isNexsan() && !this.isVStor();
    }
}

