/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util.types;

import com.sanrad.nms.server.util.types.SrType;
import java.math.BigInteger;

public class SrUInteger
extends SrType
implements Comparable {
    public SrUInteger() {
        this("0");
    }

    public SrUInteger(int i) {
        this(Integer.toString(i));
    }

    public SrUInteger(long i) {
        this(Long.toString(i));
    }

    public SrUInteger(String val) {
        super(new BigInteger(val), "SrUInteger");
        if (((BigInteger)this.value).signum() < 0) {
            // empty if block
        }
    }

    public SrUInteger(BigInteger i) {
        super(i, "SrUInteger");
        if (i.longValue() < 0L) {
            // empty if block
        }
    }

    public SrUInteger(Integer i) {
        this(i.toString());
    }

    public SrUInteger(SrUInteger i) {
        this(i.toString());
    }

    @Override
    public String errorDisplayString() {
        return this.value.toString();
    }

    public long longValue() {
        return ((BigInteger)this.value).longValue();
    }

    public Long longVal() {
        return new Long(((BigInteger)this.value).longValue());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SrUInteger) {
            return ((SrUInteger)obj).value().equals(this.value);
        }
        if (obj instanceof Integer) {
            return (long)((Integer)this.value).intValue() == this.longValue();
        }
        return false;
    }

    public boolean equals(int i) {
        return (long)i == this.longValue();
    }

    @Override
    public int getTypeNumber() {
        return 17;
    }

    public int compareTo(Object obj) {
        return ((BigInteger)this.value()).compareTo((BigInteger)((SrUInteger)obj).value());
    }

    public int compareLongValueTo(SrUInteger obj) {
        long toCompareVal;
        long myVal = this.longValue();
        if (myVal > (toCompareVal = obj.longValue())) {
            return 1;
        }
        if (myVal < toCompareVal) {
            return -1;
        }
        return 0;
    }
}

