/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util.types;

import com.sanrad.nms.server.exception.TypeMismatchException;
import com.sanrad.nms.server.util.types.SrOctetStringFormat;
import com.sanrad.nms.server.util.types.SrString;
import java.math.BigInteger;

public class SrLunFormat
extends SrOctetStringFormat {
    private static final byte[] MAX_BYTE_VALUE = new byte[]{0, -1, 0, 0, 0, 0, 0, 0};

    public SrLunFormat() {
        super(8);
    }

    public SrLunFormat(BigInteger intVal) {
        super(8, intVal);
    }

    public SrLunFormat(Integer val) {
        this(new BigInteger(val.toString()));
    }

    public SrLunFormat(int val) {
        this(new Integer(val));
    }

    public SrLunFormat(SrString val) {
        super(8, val);
    }

    public SrLunFormat(byte[] val) {
        super(8, val);
    }

    public SrLunFormat(int[] val) {
        this();
        if (val.length != 8) {
            throw new TypeMismatchException("Illegal input length");
        }
        for (int i = 0; i < val.length; ++i) {
            if (val[i] > 255 || val[i] < 0) {
                throw new TypeMismatchException("input value is not byte value");
            }
            ((byte[])this.value)[i] = (byte)val[i];
        }
    }

    public SrLunFormat(String strVal) {
        super(8, strVal);
    }

    public SrLunFormat add(SrLunFormat val) {
        return new SrLunFormat(super.add(val));
    }

    @Override
    public String errorDisplayString() {
        return "SrLunFormat: " + this.toDisplayString();
    }

    @Override
    public String toDisplayString() {
        BigInteger maxValue = new BigInteger(MAX_BYTE_VALUE);
        BigInteger orResult = maxValue.or((BigInteger)this.value);
        if (orResult.compareTo(maxValue) == 0) {
            return String.valueOf(this.toInt());
        }
        return super.toDisplayString();
    }
}

