/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util.types;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.SrType;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class SrDateAndTime
extends SrType
implements Comparable {
    private static SrLogger theLogger = SrLogger.getLogger();

    public SrDateAndTime() {
        super(new Long(0L), "SrDateAndTime");
    }

    public SrDateAndTime(Date date) {
        super(new Long(date.getTime()), "SrDateAndTime");
    }

    public SrDateAndTime(Long date) {
        super(date, "SrDateAndTime");
    }

    public SrDateAndTime(SrString date) {
        this(date.toString());
    }

    public SrDateAndTime(String date) {
        this();
        String newDate = "";
        newDate = date.length() > 18 ? date.substring(0, date.lastIndexOf(".")) : date;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd,HH:mm:ss");
        try {
            this.value = new Long(dateFormat.parse(newDate).getTime());
        }
        catch (ParseException e) {
            theLogger.warn(SrLogCategories.LEGACY, e, "Wrong DateAndTime Format in the agent: ", date);
        }
    }

    public SrDateAndTime(long[] date) {
        this();
        int i = date.length;
        while (i-- > 0) {
            if (date[i] <= 0L) continue;
            long year = 0L;
            int actualLength = Math.min(8, date.length);
            GregorianCalendar calendar = new GregorianCalendar();
            switch (actualLength) {
                case 8: {
                    calendar.set(14, (int)date[7] * 100);
                }
                case 7: {
                    calendar.set(13, (int)date[6]);
                }
                case 6: {
                    calendar.set(12, (int)date[5]);
                }
                case 5: {
                    calendar.set(11, (int)date[4]);
                }
                case 4: {
                    calendar.set(5, (int)date[3]);
                }
                case 3: {
                    calendar.set(2, Math.max(0, (int)date[2] - 1));
                }
                case 2: {
                    year += date[1];
                }
                case 1: {
                    calendar.set(1, (int)(year += date[0] * 256L));
                }
            }
            this.value = new Long(calendar.getTimeInMillis());
            break;
        }
    }

    @Override
    public Object value() {
        return new Long((Long)this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SrDateAndTime) {
            return this.value.equals(((SrDateAndTime)obj).value());
        }
        if (obj instanceof Long) {
            return this.value.equals(obj);
        }
        return false;
    }

    public boolean equals(long date) {
        return (Long)this.value == date;
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    public String getSnmpFormat() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date((Long)this.value));
        String snmpVal = "'";
        String year = Integer.toHexString(cal.get(1));
        if (year.length() == 3) {
            year = "0" + year;
        }
        snmpVal = snmpVal + year;
        String mon = Integer.toHexString(cal.get(2) + 1);
        if (mon.length() == 1) {
            mon = "0" + mon;
        }
        snmpVal = snmpVal + mon;
        String day = Integer.toHexString(cal.get(5));
        if (day.length() == 1) {
            day = "0" + day;
        }
        snmpVal = snmpVal + day;
        String hour = Integer.toHexString(cal.get(11));
        if (hour.length() == 1) {
            hour = "0" + hour;
        }
        snmpVal = snmpVal + hour;
        String min = Integer.toHexString(cal.get(12));
        if (min.length() == 1) {
            min = "0" + min;
        }
        snmpVal = snmpVal + min;
        String sec = Integer.toHexString(cal.get(13));
        if (sec.length() == 1) {
            sec = "0" + sec;
        }
        snmpVal = snmpVal + sec;
        String mill = Integer.toHexString(cal.get(14));
        if (mill.length() > 2) {
            mill = mill.substring(0, 2);
        } else if (mill.length() == 1) {
            mill = mill + "0";
        }
        snmpVal = snmpVal + mill;
        snmpVal = snmpVal + "2B0000'H";
        return snmpVal;
    }

    @Override
    public int getTypeNumber() {
        return 11;
    }

    public SrDateAndTime addTimeTicks(SrTimeTicks timeTicks) {
        long newTime = (Long)this.value + ((BigInteger)timeTicks.value()).longValue();
        return new SrDateAndTime(new Long(newTime));
    }

    public int compareTo(Object o) {
        if (o instanceof SrDateAndTime) {
            o = ((SrDateAndTime)o).value();
        }
        if (o instanceof Long) {
            return ((Long)this.value()).compareTo((Long)o);
        }
        throw new IllegalArgumentException("Cannot compare " + o + " and " + this.getClass());
    }
}

