/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util.types;

import com.sanrad.nms.server.util.types.SrType;
import java.util.BitSet;

public class SrBITS
extends SrType {
    private static final int BITS_IN_BYTE = 8;
    private int myNumberOfBytes = 8;

    protected SrBITS(int nBytes) {
        this(nBytes, -1);
    }

    private SrBITS(int nBytes, int aBitOn) {
        super("SrBITS");
        this.myNumberOfBytes = nBytes;
        this.value = new BitSet(nBytes * 8);
        if (aBitOn >= 0) {
            this.setIntVal(aBitOn);
        }
    }

    public SrBITS(String str) {
        super("SrBITS");
        int strLen = str.length();
        String newStr = "";
        newStr = this.isMonfoxHexaString(str) ? str.substring(1, strLen - 2) : str;
        this.value = new BitSet(newStr.length());
        int intVal = Integer.parseInt(newStr, 2);
        this.setIntVal(intVal);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SrBITS) {
            return ((SrBITS)obj).value().equals(this.value);
        }
        if (obj instanceof BitSet) {
            return obj.equals(this.value);
        }
        return false;
    }

    public Integer intVal() {
        int val = 0;
        for (int i = 7; i >= 0; --i) {
            if (((BitSet)this.value).get(i)) {
                val = val * 2 + 1;
                continue;
            }
            val *= 2;
        }
        return new Integer(val);
    }

    protected void setIntVal(int intVal) {
        String str = Integer.toBinaryString(intVal);
        for (int i = 0; i < 8 && i < str.length(); ++i) {
            if (str.charAt(str.length() - i - 1) != '1') continue;
            ((BitSet)this.value).set(i);
        }
    }

    public void setBit(int bitNumber) {
        ((BitSet)this.value).set(bitNumber);
    }

    public void clearBit(int bitNumber) {
        ((BitSet)this.value).clear(bitNumber);
    }

    public String toHexString() {
        StringBuilder valueBuilder = new StringBuilder();
        for (int i = 0; i < this.myNumberOfBytes; ++i) {
            StringBuilder bitString = new StringBuilder();
            for (int j = 0; j < 8; ++j) {
                if (((BitSet)this.value).get((i + 1) * j)) {
                    bitString.append('1');
                    continue;
                }
                bitString.append('0');
            }
            int intval = Integer.parseInt(bitString.toString(), 2);
            String hexVal = Integer.toHexString(intval);
            valueBuilder.append(hexVal);
        }
        return valueBuilder.toString();
    }

    public boolean getBit(int bitIndex) {
        return ((BitSet)this.value).get(bitIndex);
    }

    @Override
    public String errorDisplayString() {
        return "SrCBITS: " + this.value.toString();
    }

    @Override
    public int getTypeNumber() {
        return 12;
    }

    private boolean isMonfoxHexaString(String str) {
        if (str == null || str.length() < 5) {
            return false;
        }
        int len = str.length();
        return str.charAt(0) == '\'' && str.charAt(len - 2) == '\'' && (str.charAt(len - 1) == 'H' || str.charAt(len - 1) == 'h');
    }

    public int getSignificantBitUp() {
        int i = ((BitSet)this.value).length();
        while (i-- > 0) {
            if (!((BitSet)this.value).get(i)) continue;
            return i;
        }
        return -1;
    }
}

